// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribestreaming.model

import kotlinx.coroutines.flow.Flow

public class StartStreamTranscriptionRequest private constructor(builder: Builder) {
    /**
     * An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.
     *
     * For more information, see [Transcribing streaming audio](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html).
     */
    public val audioStream: Flow<aws.sdk.kotlin.services.transcribestreaming.model.AudioStream>? = builder.audioStream
    /**
     * Labels all personally identifiable information (PII) identified in your transcript.
     *
     * Content identification is performed at the segment level; PII specified in `PiiEntityTypes` is flagged upon complete transcription of an audio segment.
     *
     * You can’t set `ContentIdentificationType` and `ContentRedactionType` in the same request. If you set both, your request returns a `BadRequestException`.
     *
     * For more information, see [Redacting or identifying personally identifiable information](https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html).
     */
    public val contentIdentificationType: aws.sdk.kotlin.services.transcribestreaming.model.ContentIdentificationType? = builder.contentIdentificationType
    /**
     * Redacts all personally identifiable information (PII) identified in your transcript.
     *
     * Content redaction is performed at the segment level; PII specified in `PiiEntityTypes` is redacted upon complete transcription of an audio segment.
     *
     * You can’t set `ContentRedactionType` and `ContentIdentificationType` in the same request. If you set both, your request returns a `BadRequestException`.
     *
     * For more information, see [Redacting or identifying personally identifiable information](https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html).
     */
    public val contentRedactionType: aws.sdk.kotlin.services.transcribestreaming.model.ContentRedactionType? = builder.contentRedactionType
    /**
     * Enables channel identification in multi-channel audio.
     *
     * Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.
     *
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript is not separated by channel.
     *
     * For more information, see [Transcribing multi-channel audio](https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
     */
    public val enableChannelIdentification: kotlin.Boolean = builder.enableChannelIdentification
    /**
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see [Partial-result stabilization](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization).
     */
    public val enablePartialResultsStabilization: kotlin.Boolean = builder.enablePartialResultsStabilization
    /**
     * Enables automatic language identification for your transcription.
     *
     * If you include `IdentifyLanguage`, you can optionally include a list of language codes, using `LanguageOptions`, that you think may be present in your audio stream. Including language options can improve transcription accuracy.
     *
     * You can also include a preferred language using `PreferredLanguage`. Adding a preferred language can help Amazon Transcribe identify the language faster than if you omit this parameter.
     *
     * If you have multi-channel audio that contains different languages on each channel, and you've enabled channel identification, automatic language identification identifies the dominant language on each audio channel.
     *
     * Note that you must include either `LanguageCode` or `IdentifyLanguage` in your request. If you include both parameters, your request fails.
     *
     * Streaming language identification can't be combined with custom language models or redaction.
     */
    public val identifyLanguage: kotlin.Boolean = builder.identifyLanguage
    /**
     * Specify the language code that represents the language spoken in your audio.
     *
     * If you're unsure of the language spoken in your audio, consider using `IdentifyLanguage` to enable automatic language identification.
     *
     * For a list of languages supported with Amazon Transcribe streaming, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribestreaming.model.LanguageCode? = builder.languageCode
    /**
     * Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.
     *
     * The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the language model isn't applied. There are no errors or warnings associated with a language mismatch.
     *
     * For more information, see [Custom language models](https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html).
     */
    public val languageModelName: kotlin.String? = builder.languageModelName
    /**
     * Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
     *
     * Including language options can improve the accuracy of language identification.
     *
     * If you include `LanguageOptions` in your request, you must also include `IdentifyLanguage`.
     *
     * For a list of languages supported with Amazon Transcribe streaming, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
     *
     * You can only include one language dialect per language per stream. For example, you cannot include `en-US` and `en-AU` in the same request.
     */
    public val languageOptions: kotlin.String? = builder.languageOptions
    /**
     * Specify the encoding used for the input audio. Supported formats are:
     * + FLAC
     * + OPUS-encoded audio in an Ogg container
     * + PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
     *
     * For more information, see [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio).
     */
    public val mediaEncoding: aws.sdk.kotlin.services.transcribestreaming.model.MediaEncoding? = builder.mediaEncoding
    /**
     * The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.
     */
    public val mediaSampleRateHertz: kotlin.Int? = builder.mediaSampleRateHertz
    /**
     * Specify the number of channels in your audio stream. Up to two channels are supported.
     */
    public val numberOfChannels: kotlin.Int? = builder.numberOfChannels
    /**
     * Specify the level of stability to use when you enable partial results stabilization (`EnablePartialResultsStabilization`).
     *
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     *
     * For more information, see [Partial-result stabilization](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization).
     */
    public val partialResultsStability: aws.sdk.kotlin.services.transcribestreaming.model.PartialResultsStability? = builder.partialResultsStability
    /**
     * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select `ALL`.
     *
     * To include `PiiEntityTypes` in your request, you must also include either `ContentIdentificationType` or `ContentRedactionType`.
     *
     * Values must be comma-separated and can include: `BANK_ACCOUNT_NUMBER`, `BANK_ROUTING`, `CREDIT_DEBIT_NUMBER`, `CREDIT_DEBIT_CVV`, `CREDIT_DEBIT_EXPIRY`, `PIN`, `EMAIL`, `ADDRESS`, `NAME`, `PHONE`, `SSN`, or `ALL`.
     */
    public val piiEntityTypes: kotlin.String? = builder.piiEntityTypes
    /**
     * Specify a preferred language from the subset of languages codes you specified in `LanguageOptions`.
     *
     * You can only use this parameter if you've included `IdentifyLanguage` and `LanguageOptions` in your request.
     */
    public val preferredLanguage: aws.sdk.kotlin.services.transcribestreaming.model.LanguageCode? = builder.preferredLanguage
    /**
     * Specify a name for your transcription session. If you don't include this parameter in your request, Amazon Transcribe generates an ID and returns it in the response.
     *
     * You can use a session ID to retry a streaming session.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.
     *
     * For more information, see [Partitioning speakers (diarization)](https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
     */
    public val showSpeakerLabel: kotlin.Boolean = builder.showSpeakerLabel
    /**
     * Specify how you want your vocabulary filter applied to your transcript.
     *
     * To replace words with `***`, choose `mask`.
     *
     * To delete words, choose `remove`.
     *
     * To flag words without changing them, choose `tag`.
     */
    public val vocabularyFilterMethod: aws.sdk.kotlin.services.transcribestreaming.model.VocabularyFilterMethod? = builder.vocabularyFilterMethod
    /**
     * Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.
     *
     * If the language of the specified custom vocabulary filter doesn't match the language identified in your media, your job fails.
     *
     * This parameter is **not** intended for use with the `IdentifyLanguage` parameter. If you're including `IdentifyLanguage` in your request and want to use one or more vocabulary filters with your transcription, use the `VocabularyFilterNames` parameter instead.
     *
     * For more information, see [Using vocabulary filtering with unwanted words](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
     */
    public val vocabularyFilterName: kotlin.String? = builder.vocabularyFilterName
    /**
     * Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.
     *
     * If none of the languages of the specified custom vocabulary filters match the language identified in your media, your job fails.
     *
     * This parameter is only intended for use **with** the `IdentifyLanguage` parameter. If you're **not** including `IdentifyLanguage` in your request and want to use a custom vocabulary filter with your transcription, use the `VocabularyFilterName` parameter instead.
     *
     * For more information, see [Using vocabulary filtering with unwanted words](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
     */
    public val vocabularyFilterNames: kotlin.String? = builder.vocabularyFilterNames
    /**
     * Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.
     *
     * If the language of the specified custom vocabulary doesn't match the language identified in your media, your job fails.
     *
     * This parameter is **not** intended for use with the `IdentifyLanguage` parameter. If you're including `IdentifyLanguage` in your request and want to use one or more custom vocabularies with your transcription, use the `VocabularyNames` parameter instead.
     *
     * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName
    /**
     * Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.
     *
     * If none of the languages of the specified custom vocabularies match the language identified in your media, your job fails.
     *
     * This parameter is only intended for use **with** the `IdentifyLanguage` parameter. If you're **not** including `IdentifyLanguage` in your request and want to use a custom vocabulary with your transcription, use the `VocabularyName` parameter instead.
     *
     * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
     */
    public val vocabularyNames: kotlin.String? = builder.vocabularyNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribestreaming.model.StartStreamTranscriptionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartStreamTranscriptionRequest(")
        append("audioStream=$audioStream,")
        append("contentIdentificationType=$contentIdentificationType,")
        append("contentRedactionType=$contentRedactionType,")
        append("enableChannelIdentification=$enableChannelIdentification,")
        append("enablePartialResultsStabilization=$enablePartialResultsStabilization,")
        append("identifyLanguage=$identifyLanguage,")
        append("languageCode=$languageCode,")
        append("languageModelName=$languageModelName,")
        append("languageOptions=$languageOptions,")
        append("mediaEncoding=$mediaEncoding,")
        append("mediaSampleRateHertz=$mediaSampleRateHertz,")
        append("numberOfChannels=$numberOfChannels,")
        append("partialResultsStability=$partialResultsStability,")
        append("piiEntityTypes=$piiEntityTypes,")
        append("preferredLanguage=$preferredLanguage,")
        append("sessionId=$sessionId,")
        append("showSpeakerLabel=$showSpeakerLabel,")
        append("vocabularyFilterMethod=$vocabularyFilterMethod,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("vocabularyFilterNames=$vocabularyFilterNames,")
        append("vocabularyName=$vocabularyName,")
        append("vocabularyNames=$vocabularyNames)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioStream?.hashCode() ?: 0
        result = 31 * result + (contentIdentificationType?.hashCode() ?: 0)
        result = 31 * result + (contentRedactionType?.hashCode() ?: 0)
        result = 31 * result + (enableChannelIdentification.hashCode())
        result = 31 * result + (enablePartialResultsStabilization.hashCode())
        result = 31 * result + (identifyLanguage.hashCode())
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (languageModelName?.hashCode() ?: 0)
        result = 31 * result + (languageOptions?.hashCode() ?: 0)
        result = 31 * result + (mediaEncoding?.hashCode() ?: 0)
        result = 31 * result + (mediaSampleRateHertz ?: 0)
        result = 31 * result + (numberOfChannels ?: 0)
        result = 31 * result + (partialResultsStability?.hashCode() ?: 0)
        result = 31 * result + (piiEntityTypes?.hashCode() ?: 0)
        result = 31 * result + (preferredLanguage?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (showSpeakerLabel.hashCode())
        result = 31 * result + (vocabularyFilterMethod?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterNames?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartStreamTranscriptionRequest

        if (audioStream != other.audioStream) return false
        if (contentIdentificationType != other.contentIdentificationType) return false
        if (contentRedactionType != other.contentRedactionType) return false
        if (enableChannelIdentification != other.enableChannelIdentification) return false
        if (enablePartialResultsStabilization != other.enablePartialResultsStabilization) return false
        if (identifyLanguage != other.identifyLanguage) return false
        if (languageCode != other.languageCode) return false
        if (languageModelName != other.languageModelName) return false
        if (languageOptions != other.languageOptions) return false
        if (mediaEncoding != other.mediaEncoding) return false
        if (mediaSampleRateHertz != other.mediaSampleRateHertz) return false
        if (numberOfChannels != other.numberOfChannels) return false
        if (partialResultsStability != other.partialResultsStability) return false
        if (piiEntityTypes != other.piiEntityTypes) return false
        if (preferredLanguage != other.preferredLanguage) return false
        if (sessionId != other.sessionId) return false
        if (showSpeakerLabel != other.showSpeakerLabel) return false
        if (vocabularyFilterMethod != other.vocabularyFilterMethod) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (vocabularyFilterNames != other.vocabularyFilterNames) return false
        if (vocabularyName != other.vocabularyName) return false
        if (vocabularyNames != other.vocabularyNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribestreaming.model.StartStreamTranscriptionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.
         *
         * For more information, see [Transcribing streaming audio](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html).
         */
        public var audioStream: Flow<aws.sdk.kotlin.services.transcribestreaming.model.AudioStream>? = null
        /**
         * Labels all personally identifiable information (PII) identified in your transcript.
         *
         * Content identification is performed at the segment level; PII specified in `PiiEntityTypes` is flagged upon complete transcription of an audio segment.
         *
         * You can’t set `ContentIdentificationType` and `ContentRedactionType` in the same request. If you set both, your request returns a `BadRequestException`.
         *
         * For more information, see [Redacting or identifying personally identifiable information](https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html).
         */
        public var contentIdentificationType: aws.sdk.kotlin.services.transcribestreaming.model.ContentIdentificationType? = null
        /**
         * Redacts all personally identifiable information (PII) identified in your transcript.
         *
         * Content redaction is performed at the segment level; PII specified in `PiiEntityTypes` is redacted upon complete transcription of an audio segment.
         *
         * You can’t set `ContentRedactionType` and `ContentIdentificationType` in the same request. If you set both, your request returns a `BadRequestException`.
         *
         * For more information, see [Redacting or identifying personally identifiable information](https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html).
         */
        public var contentRedactionType: aws.sdk.kotlin.services.transcribestreaming.model.ContentRedactionType? = null
        /**
         * Enables channel identification in multi-channel audio.
         *
         * Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.
         *
         * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript is not separated by channel.
         *
         * For more information, see [Transcribing multi-channel audio](https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
         */
        public var enableChannelIdentification: kotlin.Boolean = false
        /**
         * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see [Partial-result stabilization](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization).
         */
        public var enablePartialResultsStabilization: kotlin.Boolean = false
        /**
         * Enables automatic language identification for your transcription.
         *
         * If you include `IdentifyLanguage`, you can optionally include a list of language codes, using `LanguageOptions`, that you think may be present in your audio stream. Including language options can improve transcription accuracy.
         *
         * You can also include a preferred language using `PreferredLanguage`. Adding a preferred language can help Amazon Transcribe identify the language faster than if you omit this parameter.
         *
         * If you have multi-channel audio that contains different languages on each channel, and you've enabled channel identification, automatic language identification identifies the dominant language on each audio channel.
         *
         * Note that you must include either `LanguageCode` or `IdentifyLanguage` in your request. If you include both parameters, your request fails.
         *
         * Streaming language identification can't be combined with custom language models or redaction.
         */
        public var identifyLanguage: kotlin.Boolean = false
        /**
         * Specify the language code that represents the language spoken in your audio.
         *
         * If you're unsure of the language spoken in your audio, consider using `IdentifyLanguage` to enable automatic language identification.
         *
         * For a list of languages supported with Amazon Transcribe streaming, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribestreaming.model.LanguageCode? = null
        /**
         * Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.
         *
         * The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the language model isn't applied. There are no errors or warnings associated with a language mismatch.
         *
         * For more information, see [Custom language models](https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html).
         */
        public var languageModelName: kotlin.String? = null
        /**
         * Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
         *
         * Including language options can improve the accuracy of language identification.
         *
         * If you include `LanguageOptions` in your request, you must also include `IdentifyLanguage`.
         *
         * For a list of languages supported with Amazon Transcribe streaming, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
         *
         * You can only include one language dialect per language per stream. For example, you cannot include `en-US` and `en-AU` in the same request.
         */
        public var languageOptions: kotlin.String? = null
        /**
         * Specify the encoding used for the input audio. Supported formats are:
         * + FLAC
         * + OPUS-encoded audio in an Ogg container
         * + PCM (only signed 16-bit little-endian audio formats, which does not include WAV)
         *
         * For more information, see [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio).
         */
        public var mediaEncoding: aws.sdk.kotlin.services.transcribestreaming.model.MediaEncoding? = null
        /**
         * The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.
         */
        public var mediaSampleRateHertz: kotlin.Int? = null
        /**
         * Specify the number of channels in your audio stream. Up to two channels are supported.
         */
        public var numberOfChannels: kotlin.Int? = null
        /**
         * Specify the level of stability to use when you enable partial results stabilization (`EnablePartialResultsStabilization`).
         *
         * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
         *
         * For more information, see [Partial-result stabilization](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization).
         */
        public var partialResultsStability: aws.sdk.kotlin.services.transcribestreaming.model.PartialResultsStability? = null
        /**
         * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select `ALL`.
         *
         * To include `PiiEntityTypes` in your request, you must also include either `ContentIdentificationType` or `ContentRedactionType`.
         *
         * Values must be comma-separated and can include: `BANK_ACCOUNT_NUMBER`, `BANK_ROUTING`, `CREDIT_DEBIT_NUMBER`, `CREDIT_DEBIT_CVV`, `CREDIT_DEBIT_EXPIRY`, `PIN`, `EMAIL`, `ADDRESS`, `NAME`, `PHONE`, `SSN`, or `ALL`.
         */
        public var piiEntityTypes: kotlin.String? = null
        /**
         * Specify a preferred language from the subset of languages codes you specified in `LanguageOptions`.
         *
         * You can only use this parameter if you've included `IdentifyLanguage` and `LanguageOptions` in your request.
         */
        public var preferredLanguage: aws.sdk.kotlin.services.transcribestreaming.model.LanguageCode? = null
        /**
         * Specify a name for your transcription session. If you don't include this parameter in your request, Amazon Transcribe generates an ID and returns it in the response.
         *
         * You can use a session ID to retry a streaming session.
         */
        public var sessionId: kotlin.String? = null
        /**
         * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.
         *
         * For more information, see [Partitioning speakers (diarization)](https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
         */
        public var showSpeakerLabel: kotlin.Boolean = false
        /**
         * Specify how you want your vocabulary filter applied to your transcript.
         *
         * To replace words with `***`, choose `mask`.
         *
         * To delete words, choose `remove`.
         *
         * To flag words without changing them, choose `tag`.
         */
        public var vocabularyFilterMethod: aws.sdk.kotlin.services.transcribestreaming.model.VocabularyFilterMethod? = null
        /**
         * Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.
         *
         * If the language of the specified custom vocabulary filter doesn't match the language identified in your media, your job fails.
         *
         * This parameter is **not** intended for use with the `IdentifyLanguage` parameter. If you're including `IdentifyLanguage` in your request and want to use one or more vocabulary filters with your transcription, use the `VocabularyFilterNames` parameter instead.
         *
         * For more information, see [Using vocabulary filtering with unwanted words](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
         */
        public var vocabularyFilterName: kotlin.String? = null
        /**
         * Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.
         *
         * If none of the languages of the specified custom vocabulary filters match the language identified in your media, your job fails.
         *
         * This parameter is only intended for use **with** the `IdentifyLanguage` parameter. If you're **not** including `IdentifyLanguage` in your request and want to use a custom vocabulary filter with your transcription, use the `VocabularyFilterName` parameter instead.
         *
         * For more information, see [Using vocabulary filtering with unwanted words](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
         */
        public var vocabularyFilterNames: kotlin.String? = null
        /**
         * Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.
         *
         * If the language of the specified custom vocabulary doesn't match the language identified in your media, your job fails.
         *
         * This parameter is **not** intended for use with the `IdentifyLanguage` parameter. If you're including `IdentifyLanguage` in your request and want to use one or more custom vocabularies with your transcription, use the `VocabularyNames` parameter instead.
         *
         * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
         */
        public var vocabularyName: kotlin.String? = null
        /**
         * Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.
         *
         * If none of the languages of the specified custom vocabularies match the language identified in your media, your job fails.
         *
         * This parameter is only intended for use **with** the `IdentifyLanguage` parameter. If you're **not** including `IdentifyLanguage` in your request and want to use a custom vocabulary with your transcription, use the `VocabularyName` parameter instead.
         *
         * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
         */
        public var vocabularyNames: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribestreaming.model.StartStreamTranscriptionRequest) : this() {
            this.audioStream = x.audioStream
            this.contentIdentificationType = x.contentIdentificationType
            this.contentRedactionType = x.contentRedactionType
            this.enableChannelIdentification = x.enableChannelIdentification
            this.enablePartialResultsStabilization = x.enablePartialResultsStabilization
            this.identifyLanguage = x.identifyLanguage
            this.languageCode = x.languageCode
            this.languageModelName = x.languageModelName
            this.languageOptions = x.languageOptions
            this.mediaEncoding = x.mediaEncoding
            this.mediaSampleRateHertz = x.mediaSampleRateHertz
            this.numberOfChannels = x.numberOfChannels
            this.partialResultsStability = x.partialResultsStability
            this.piiEntityTypes = x.piiEntityTypes
            this.preferredLanguage = x.preferredLanguage
            this.sessionId = x.sessionId
            this.showSpeakerLabel = x.showSpeakerLabel
            this.vocabularyFilterMethod = x.vocabularyFilterMethod
            this.vocabularyFilterName = x.vocabularyFilterName
            this.vocabularyFilterNames = x.vocabularyFilterNames
            this.vocabularyName = x.vocabularyName
            this.vocabularyNames = x.vocabularyNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribestreaming.model.StartStreamTranscriptionRequest = StartStreamTranscriptionRequest(this)
    }
}
