// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribestreaming.model



/**
 * The `Result` associated with a ``.
 *
 * Contains a set of transcription results from one or more audio segments, along with additional information per your request parameters. This can include information relating to alternative transcriptions, channel identification, partial result stabilization, language identification, and other transcription-related data.
 */
public class MedicalResult private constructor(builder: Builder) {
    /**
     * A list of possible alternative transcriptions for the input audio. Each alternative may contain one or more of `Items`, `Entities`, or `Transcript`.
     */
    public val alternatives: List<MedicalAlternative>? = builder.alternatives
    /**
     * Indicates the channel identified for the `Result`.
     */
    public val channelId: kotlin.String? = builder.channelId
    /**
     * The end time, in milliseconds, of the `Result`.
     */
    public val endTime: kotlin.Double = builder.endTime
    /**
     * Indicates if the segment is complete.
     *
     * If `IsPartial` is `true`, the segment is not complete. If `IsPartial` is `false`, the segment is complete.
     */
    public val isPartial: kotlin.Boolean = builder.isPartial
    /**
     * Provides a unique identifier for the `Result`.
     */
    public val resultId: kotlin.String? = builder.resultId
    /**
     * The start time, in milliseconds, of the `Result`.
     */
    public val startTime: kotlin.Double = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribestreaming.model.MedicalResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MedicalResult(")
        append("alternatives=$alternatives,")
        append("channelId=$channelId,")
        append("endTime=$endTime,")
        append("isPartial=$isPartial,")
        append("resultId=$resultId,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alternatives?.hashCode() ?: 0
        result = 31 * result + (channelId?.hashCode() ?: 0)
        result = 31 * result + (endTime.hashCode())
        result = 31 * result + (isPartial.hashCode())
        result = 31 * result + (resultId?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MedicalResult

        if (alternatives != other.alternatives) return false
        if (channelId != other.channelId) return false
        if (endTime != other.endTime) return false
        if (isPartial != other.isPartial) return false
        if (resultId != other.resultId) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribestreaming.model.MedicalResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of possible alternative transcriptions for the input audio. Each alternative may contain one or more of `Items`, `Entities`, or `Transcript`.
         */
        public var alternatives: List<MedicalAlternative>? = null
        /**
         * Indicates the channel identified for the `Result`.
         */
        public var channelId: kotlin.String? = null
        /**
         * The end time, in milliseconds, of the `Result`.
         */
        public var endTime: kotlin.Double = 0.0
        /**
         * Indicates if the segment is complete.
         *
         * If `IsPartial` is `true`, the segment is not complete. If `IsPartial` is `false`, the segment is complete.
         */
        public var isPartial: kotlin.Boolean = false
        /**
         * Provides a unique identifier for the `Result`.
         */
        public var resultId: kotlin.String? = null
        /**
         * The start time, in milliseconds, of the `Result`.
         */
        public var startTime: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribestreaming.model.MedicalResult) : this() {
            this.alternatives = x.alternatives
            this.channelId = x.channelId
            this.endTime = x.endTime
            this.isPartial = x.isPartial
            this.resultId = x.resultId
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribestreaming.model.MedicalResult = MedicalResult(this)
    }
}
