// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribestreaming.model



/**
 * A word, phrase, or punctuation mark in your transcription output, along with various associated attributes, such as confidence score, type, and start and end times.
 */
public class MedicalItem private constructor(builder: Builder) {
    /**
     * The confidence score associated with a word or phrase in your transcript.
     *
     * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.
     */
    public val confidence: kotlin.Double? = builder.confidence
    /**
     * The word or punctuation that was transcribed.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The end time, in milliseconds, of the transcribed item.
     */
    public val endTime: kotlin.Double = builder.endTime
    /**
     * If speaker partitioning is enabled, `Speaker` labels the speaker of the specified item.
     */
    public val speaker: kotlin.String? = builder.speaker
    /**
     * The start time, in milliseconds, of the transcribed item.
     */
    public val startTime: kotlin.Double = builder.startTime
    /**
     * The type of item identified. Options are: `PRONUNCIATION` (spoken words) and `PUNCTUATION`.
     */
    public val type: aws.sdk.kotlin.services.transcribestreaming.model.ItemType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribestreaming.model.MedicalItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MedicalItem(")
        append("confidence=$confidence,")
        append("content=$content,")
        append("endTime=$endTime,")
        append("speaker=$speaker,")
        append("startTime=$startTime,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = confidence?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (endTime.hashCode())
        result = 31 * result + (speaker?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MedicalItem

        if (confidence != other.confidence) return false
        if (content != other.content) return false
        if (endTime != other.endTime) return false
        if (speaker != other.speaker) return false
        if (startTime != other.startTime) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribestreaming.model.MedicalItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The confidence score associated with a word or phrase in your transcript.
         *
         * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.
         */
        public var confidence: kotlin.Double? = null
        /**
         * The word or punctuation that was transcribed.
         */
        public var content: kotlin.String? = null
        /**
         * The end time, in milliseconds, of the transcribed item.
         */
        public var endTime: kotlin.Double = 0.0
        /**
         * If speaker partitioning is enabled, `Speaker` labels the speaker of the specified item.
         */
        public var speaker: kotlin.String? = null
        /**
         * The start time, in milliseconds, of the transcribed item.
         */
        public var startTime: kotlin.Double = 0.0
        /**
         * The type of item identified. Options are: `PRONUNCIATION` (spoken words) and `PUNCTUATION`.
         */
        public var type: aws.sdk.kotlin.services.transcribestreaming.model.ItemType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribestreaming.model.MedicalItem) : this() {
            this.confidence = x.confidence
            this.content = x.content
            this.endTime = x.endTime
            this.speaker = x.speaker
            this.startTime = x.startTime
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribestreaming.model.MedicalItem = MedicalItem(this)
    }
}
