// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribestreaming.model



/**
 * A word, phrase, or punctuation mark in your transcription output, along with various associated attributes, such as confidence score, type, and start and end times.
 */
public class Item private constructor(builder: Builder) {
    /**
     * The confidence score associated with a word or phrase in your transcript.
     *
     * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.
     */
    public val confidence: kotlin.Double? = builder.confidence
    /**
     * The word or punctuation that was transcribed.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The end time, in milliseconds, of the transcribed item.
     */
    public val endTime: kotlin.Double = builder.endTime
    /**
     * If speaker partitioning is enabled, `Speaker` labels the speaker of the specified item.
     */
    public val speaker: kotlin.String? = builder.speaker
    /**
     * If partial result stabilization is enabled, `Stable` indicates whether the specified item is stable (`true`) or if it may change when the segment is complete (`false`).
     */
    public val stable: kotlin.Boolean? = builder.stable
    /**
     * The start time, in milliseconds, of the transcribed item.
     */
    public val startTime: kotlin.Double = builder.startTime
    /**
     * The type of item identified. Options are: `PRONUNCIATION` (spoken words) and `PUNCTUATION`.
     */
    public val type: aws.sdk.kotlin.services.transcribestreaming.model.ItemType? = builder.type
    /**
     * Indicates whether the specified item matches a word in the vocabulary filter included in your request. If `true`, there is a vocabulary filter match.
     */
    public val vocabularyFilterMatch: kotlin.Boolean = builder.vocabularyFilterMatch

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribestreaming.model.Item = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Item(")
        append("confidence=$confidence,")
        append("content=$content,")
        append("endTime=$endTime,")
        append("speaker=$speaker,")
        append("stable=$stable,")
        append("startTime=$startTime,")
        append("type=$type,")
        append("vocabularyFilterMatch=$vocabularyFilterMatch)")
    }

    override fun hashCode(): kotlin.Int {
        var result = confidence?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (endTime.hashCode())
        result = 31 * result + (speaker?.hashCode() ?: 0)
        result = 31 * result + (stable?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterMatch.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Item

        if (confidence != other.confidence) return false
        if (content != other.content) return false
        if (endTime != other.endTime) return false
        if (speaker != other.speaker) return false
        if (stable != other.stable) return false
        if (startTime != other.startTime) return false
        if (type != other.type) return false
        if (vocabularyFilterMatch != other.vocabularyFilterMatch) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribestreaming.model.Item = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The confidence score associated with a word or phrase in your transcript.
         *
         * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified item correctly matches the item spoken in your media.
         */
        public var confidence: kotlin.Double? = null
        /**
         * The word or punctuation that was transcribed.
         */
        public var content: kotlin.String? = null
        /**
         * The end time, in milliseconds, of the transcribed item.
         */
        public var endTime: kotlin.Double = 0.0
        /**
         * If speaker partitioning is enabled, `Speaker` labels the speaker of the specified item.
         */
        public var speaker: kotlin.String? = null
        /**
         * If partial result stabilization is enabled, `Stable` indicates whether the specified item is stable (`true`) or if it may change when the segment is complete (`false`).
         */
        public var stable: kotlin.Boolean? = null
        /**
         * The start time, in milliseconds, of the transcribed item.
         */
        public var startTime: kotlin.Double = 0.0
        /**
         * The type of item identified. Options are: `PRONUNCIATION` (spoken words) and `PUNCTUATION`.
         */
        public var type: aws.sdk.kotlin.services.transcribestreaming.model.ItemType? = null
        /**
         * Indicates whether the specified item matches a word in the vocabulary filter included in your request. If `true`, there is a vocabulary filter match.
         */
        public var vocabularyFilterMatch: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribestreaming.model.Item) : this() {
            this.confidence = x.confidence
            this.content = x.content
            this.endTime = x.endTime
            this.speaker = x.speaker
            this.stable = x.stable
            this.startTime = x.startTime
            this.type = x.type
            this.vocabularyFilterMatch = x.vocabularyFilterMatch
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribestreaming.model.Item = Item(this)
    }
}
