// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribestreaming.model



/**
 * Contains entities identified as personally identifiable information (PII) in your transcription output, along with various associated attributes. Examples include category, confidence score, type, stability score, and start and end times.
 */
public class Entity private constructor(builder: Builder) {
    /**
     * The category of information identified. The only category is `PII`.
     */
    public val category: kotlin.String? = builder.category
    /**
     * The confidence score associated with the identified PII entity in your audio.
     *
     * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.
     */
    public val confidence: kotlin.Double? = builder.confidence
    /**
     * The word or words identified as PII.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The end time, in milliseconds, of the utterance that was identified as PII.
     */
    public val endTime: kotlin.Double = builder.endTime
    /**
     * The start time, in milliseconds, of the utterance that was identified as PII.
     */
    public val startTime: kotlin.Double = builder.startTime
    /**
     * The type of PII identified. For example, `NAME` or `CREDIT_DEBIT_NUMBER`.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribestreaming.model.Entity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Entity(")
        append("category=$category,")
        append("confidence=$confidence,")
        append("content=$content,")
        append("endTime=$endTime,")
        append("startTime=$startTime,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (confidence?.hashCode() ?: 0)
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (endTime.hashCode())
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Entity

        if (category != other.category) return false
        if (confidence != other.confidence) return false
        if (content != other.content) return false
        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribestreaming.model.Entity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The category of information identified. The only category is `PII`.
         */
        public var category: kotlin.String? = null
        /**
         * The confidence score associated with the identified PII entity in your audio.
         *
         * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.
         */
        public var confidence: kotlin.Double? = null
        /**
         * The word or words identified as PII.
         */
        public var content: kotlin.String? = null
        /**
         * The end time, in milliseconds, of the utterance that was identified as PII.
         */
        public var endTime: kotlin.Double = 0.0
        /**
         * The start time, in milliseconds, of the utterance that was identified as PII.
         */
        public var startTime: kotlin.Double = 0.0
        /**
         * The type of PII identified. For example, `NAME` or `CREDIT_DEBIT_NUMBER`.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribestreaming.model.Entity) : this() {
            this.category = x.category
            this.confidence = x.confidence
            this.content = x.content
            this.endTime = x.endTime
            this.startTime = x.startTime
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribestreaming.model.Entity = Entity(this)
    }
}
