// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribestreaming

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.transcribestreaming.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.transcribestreaming.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Transcribe streaming offers two types of real-time transcription: **Standard** and **Medical**.
 * + **Standard transcriptions** are the most common option. Refer to for details.
 * + **Medical transcriptions** are tailored to medical professionals and incorporate medical terms. A common use case for this service is transcribing doctor-patient dialogue in real time, so doctors can focus on their patient instead of taking notes. Refer to for details.
 */
public interface TranscribeStreamingClient : SdkClient {

    override val serviceName: String
        get() = "Transcribe Streaming"
    /**
     * TranscribeStreamingClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): TranscribeStreamingClient {
            val config = Config.Builder().apply(block).build()
            return DefaultTranscribeStreamingClient(config)
        }

        public operator fun invoke(config: Config): TranscribeStreamingClient = DefaultTranscribeStreamingClient(config)

        /**
         * Construct a [TranscribeStreamingClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): TranscribeStreamingClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultTranscribeStreamingClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Starts a bidirectional HTTP/2 or WebSocket stream where audio is streamed to Amazon Transcribe Medical and the transcription results are streamed to your application.
     *
     * For more information on streaming with Amazon Transcribe Medical, see [Transcribing streaming audio](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html).
     */
    public suspend fun <T> startMedicalStreamTranscription(input: StartMedicalStreamTranscriptionRequest, block: suspend (StartMedicalStreamTranscriptionResponse) -> T): T

    /**
     * Starts a bidirectional HTTP/2 or WebSocket stream where audio is streamed to Amazon Transcribe and the transcription results are streamed to your application.
     *
     * The following are encoded as headers:
     * + language-code
     * + media-encoding
     * + sample-rate
     * + session-id
     *
     * For more information on streaming with Amazon Transcribe, see [Transcribing streaming audio](https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html).
     */
    public suspend fun <T> startStreamTranscription(input: StartStreamTranscriptionRequest, block: suspend (StartStreamTranscriptionResponse) -> T): T
}
