// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.serde

import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.LanguageCode
import aws.sdk.kotlin.services.transcribe.model.TranscribeException
import aws.sdk.kotlin.services.transcribe.model.VocabularyState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateVocabularyOperationDeserializer: HttpDeserializer.NonStreaming<CreateVocabularyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateVocabularyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateVocabularyError(context, call, payload)
        }
        val builder = CreateVocabularyResponse.Builder()

        if (payload != null) {
            deserializeCreateVocabularyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateVocabularyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TranscribeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateVocabularyOperationBody(builder: CreateVocabularyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LANGUAGECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("LanguageCode"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val VOCABULARYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VocabularyName"))
    val VOCABULARYSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("VocabularyState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILUREREASON_DESCRIPTOR)
        field(LANGUAGECODE_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(VOCABULARYNAME_DESCRIPTOR)
        field(VOCABULARYSTATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LANGUAGECODE_DESCRIPTOR.index -> builder.languageCode = deserializeString().let { LanguageCode.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                VOCABULARYNAME_DESCRIPTOR.index -> builder.vocabularyName = deserializeString()
                VOCABULARYSTATE_DESCRIPTOR.index -> builder.vocabularyState = deserializeString().let { VocabularyState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
