// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UntagResourceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon Transcribe resource you want to remove tags from. ARNs have the format `arn:partition:service:region:account-id:resource-type/resource-id`.
     *
     * For example, `arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name`.
     *
     * Valid values for `resource-type` are: `transcription-job`, `medical-transcription-job`, `vocabulary`, `medical-vocabulary`, `vocabulary-filter`, and `language-model`.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * Removes the specified tag keys from the specified Amazon Transcribe resource.
     */
    public val tagKeys: List<String>? = builder.tagKeys

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.UntagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UntagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("tagKeys=$tagKeys")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UntagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (tagKeys != other.tagKeys) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.UntagResourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon Transcribe resource you want to remove tags from. ARNs have the format `arn:partition:service:region:account-id:resource-type/resource-id`.
         *
         * For example, `arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name`.
         *
         * Valid values for `resource-type` are: `transcription-job`, `medical-transcription-job`, `vocabulary`, `medical-vocabulary`, `vocabulary-filter`, and `language-model`.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * Removes the specified tag keys from the specified Amazon Transcribe resource.
         */
        public var tagKeys: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.UntagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.tagKeys = x.tagKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.UntagResourceRequest = UntagResourceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
