// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetMedicalVocabularyResponse private constructor(builder: Builder) {
    /**
     * The Amazon S3 location where the specified custom medical vocabulary is stored; use this URI to view or download the custom vocabulary.
     */
    public val downloadUri: kotlin.String? = builder.downloadUri
    /**
     * If `VocabularyState` is `FAILED`, `FailureReason` contains information about why the custom medical vocabulary request failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The language code you selected for your custom medical vocabulary. US English (`en-US`) is the only language supported with Amazon Transcribe Medical.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * The date and time the specified custom medical vocabulary was last modified.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the custom medical vocabulary you requested information about.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName
    /**
     * The processing state of your custom medical vocabulary. If the state is `READY`, you can use the custom vocabulary in a `StartMedicalTranscriptionJob` request.
     */
    public val vocabularyState: aws.sdk.kotlin.services.transcribe.model.VocabularyState? = builder.vocabularyState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.GetMedicalVocabularyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMedicalVocabularyResponse(")
        append("downloadUri=$downloadUri,")
        append("failureReason=$failureReason,")
        append("languageCode=$languageCode,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("vocabularyName=$vocabularyName,")
        append("vocabularyState=$vocabularyState")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = downloadUri?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMedicalVocabularyResponse

        if (downloadUri != other.downloadUri) return false
        if (failureReason != other.failureReason) return false
        if (languageCode != other.languageCode) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (vocabularyName != other.vocabularyName) return false
        if (vocabularyState != other.vocabularyState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.GetMedicalVocabularyResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 location where the specified custom medical vocabulary is stored; use this URI to view or download the custom vocabulary.
         */
        public var downloadUri: kotlin.String? = null
        /**
         * If `VocabularyState` is `FAILED`, `FailureReason` contains information about why the custom medical vocabulary request failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The language code you selected for your custom medical vocabulary. US English (`en-US`) is the only language supported with Amazon Transcribe Medical.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * The date and time the specified custom medical vocabulary was last modified.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the custom medical vocabulary you requested information about.
         */
        public var vocabularyName: kotlin.String? = null
        /**
         * The processing state of your custom medical vocabulary. If the state is `READY`, you can use the custom vocabulary in a `StartMedicalTranscriptionJob` request.
         */
        public var vocabularyState: aws.sdk.kotlin.services.transcribe.model.VocabularyState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.GetMedicalVocabularyResponse) : this() {
            this.downloadUri = x.downloadUri
            this.failureReason = x.failureReason
            this.languageCode = x.languageCode
            this.lastModifiedTime = x.lastModifiedTime
            this.vocabularyName = x.vocabularyName
            this.vocabularyState = x.vocabularyState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.GetMedicalVocabularyResponse = GetMedicalVocabularyResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
