// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateCallAnalyticsCategoryRequest private constructor(builder: Builder) {
    /**
     * A unique name, chosen by you, for your Call Analytics category. It's helpful to use a detailed naming system that will make sense to you in the future. For example, it's better to use `sentiment-positive-last30seconds` for a category over a generic name like `test-category`.
     *
     * Category names are case sensitive.
     */
    public val categoryName: kotlin.String? = builder.categoryName
    /**
     * Choose whether you want to create a real-time or a post-call category for your Call Analytics transcription.
     *
     * Specifying `POST_CALL` assigns your category to post-call transcriptions; categories with this input type cannot be applied to streaming (real-time) transcriptions.
     *
     * Specifying `REAL_TIME` assigns your category to streaming transcriptions; categories with this input type cannot be applied to post-call transcriptions.
     *
     * If you do not include `InputType`, your category is created as a post-call category by default.
     */
    public val inputType: aws.sdk.kotlin.services.transcribe.model.InputType? = builder.inputType
    /**
     * Rules define a Call Analytics category. When creating a new category, you must create between 1 and 20 rules for that category. For each rule, you specify a filter you want applied to the attributes of a call. For example, you can choose a sentiment filter that detects if a customer's sentiment was positive during the last 30 seconds of the call.
     */
    public val rules: List<Rule>? = builder.rules
    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to a new call analytics category at the time you start this new job.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.CreateCallAnalyticsCategoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCallAnalyticsCategoryRequest(")
        append("categoryName=$categoryName,")
        append("inputType=$inputType,")
        append("rules=$rules,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = categoryName?.hashCode() ?: 0
        result = 31 * result + (inputType?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCallAnalyticsCategoryRequest

        if (categoryName != other.categoryName) return false
        if (inputType != other.inputType) return false
        if (rules != other.rules) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.CreateCallAnalyticsCategoryRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique name, chosen by you, for your Call Analytics category. It's helpful to use a detailed naming system that will make sense to you in the future. For example, it's better to use `sentiment-positive-last30seconds` for a category over a generic name like `test-category`.
         *
         * Category names are case sensitive.
         */
        public var categoryName: kotlin.String? = null
        /**
         * Choose whether you want to create a real-time or a post-call category for your Call Analytics transcription.
         *
         * Specifying `POST_CALL` assigns your category to post-call transcriptions; categories with this input type cannot be applied to streaming (real-time) transcriptions.
         *
         * Specifying `REAL_TIME` assigns your category to streaming transcriptions; categories with this input type cannot be applied to post-call transcriptions.
         *
         * If you do not include `InputType`, your category is created as a post-call category by default.
         */
        public var inputType: aws.sdk.kotlin.services.transcribe.model.InputType? = null
        /**
         * Rules define a Call Analytics category. When creating a new category, you must create between 1 and 20 rules for that category. For each rule, you specify a filter you want applied to the attributes of a call. For example, you can choose a sentiment filter that detects if a customer's sentiment was positive during the last 30 seconds of the call.
         */
        public var rules: List<Rule>? = null
        /**
         * Adds one or more custom tags, each in the form of a key:value pair, to a new call analytics category at the time you start this new job.
         *
         * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.CreateCallAnalyticsCategoryRequest) : this() {
            this.categoryName = x.categoryName
            this.inputType = x.inputType
            this.rules = x.rules
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.CreateCallAnalyticsCategoryRequest = CreateCallAnalyticsCategoryRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
