// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * If using automatic language identification in your request and you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter, include `LanguageIdSettings` with the relevant sub-parameters (`VocabularyName`, `LanguageModelName`, and `VocabularyFilterName`). Note that multi-language identification (`IdentifyMultipleLanguages`) doesn't support custom language models.
 *
 * `LanguageIdSettings` supports two to five language codes. Each language code you include can have an associated custom language model, custom vocabulary, and custom vocabulary filter. The language codes that you specify must match the languages of the associated custom language models, custom vocabularies, and custom vocabulary filters.
 *
 * It's recommended that you include `LanguageOptions` when using `LanguageIdSettings` to ensure that the correct language dialect is identified. For example, if you specify a custom vocabulary that is in `en-US` but Amazon Transcribe determines that the language spoken in your media is `en-AU`, your custom vocabulary *is not* applied to your transcription. If you include `LanguageOptions` and include `en-US` as the only English language dialect, your custom vocabulary *is* applied to your transcription.
 *
 * If you want to include a custom language model with your request but **do not** want to use automatic language identification, use instead the `` parameter with the `LanguageModelName` sub-parameter. If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but **do not** want to use automatic language identification, use instead the `` parameter with the `VocabularyName` or `VocabularyFilterName` (or both) sub-parameter.
 */
public class LanguageIdSettings private constructor(builder: Builder) {
    /**
     * The name of the custom language model you want to use when processing your transcription job. Note that custom language model names are case sensitive.
     *
     * The language of the specified custom language model must match the language code that you specify in your transcription request. If the languages do not match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.
     */
    public val languageModelName: kotlin.String? = builder.languageModelName
    /**
     * The name of the custom vocabulary filter you want to use when processing your transcription job. Custom vocabulary filter names are case sensitive.
     *
     * The language of the specified custom vocabulary filter must match the language code that you specify in your transcription request. If the languages do not match, the custom vocabulary filter isn't applied. There are no errors or warnings associated with a language mismatch.
     *
     * Note that if you include `VocabularyFilterName` in your request, you must also include `VocabularyFilterMethod`.
     */
    public val vocabularyFilterName: kotlin.String? = builder.vocabularyFilterName
    /**
     * The name of the custom vocabulary you want to use when processing your transcription job. Custom vocabulary names are case sensitive.
     *
     * The language of the specified custom vocabulary must match the language code that you specify in your transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no errors or warnings associated with a language mismatch.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.LanguageIdSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LanguageIdSettings(")
        append("languageModelName=$languageModelName,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("vocabularyName=$vocabularyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageModelName?.hashCode() ?: 0
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LanguageIdSettings

        if (languageModelName != other.languageModelName) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.LanguageIdSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the custom language model you want to use when processing your transcription job. Note that custom language model names are case sensitive.
         *
         * The language of the specified custom language model must match the language code that you specify in your transcription request. If the languages do not match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.
         */
        public var languageModelName: kotlin.String? = null
        /**
         * The name of the custom vocabulary filter you want to use when processing your transcription job. Custom vocabulary filter names are case sensitive.
         *
         * The language of the specified custom vocabulary filter must match the language code that you specify in your transcription request. If the languages do not match, the custom vocabulary filter isn't applied. There are no errors or warnings associated with a language mismatch.
         *
         * Note that if you include `VocabularyFilterName` in your request, you must also include `VocabularyFilterMethod`.
         */
        public var vocabularyFilterName: kotlin.String? = null
        /**
         * The name of the custom vocabulary you want to use when processing your transcription job. Custom vocabulary names are case sensitive.
         *
         * The language of the specified custom vocabulary must match the language code that you specify in your transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no errors or warnings associated with a language mismatch.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.LanguageIdSettings) : this() {
            this.languageModelName = x.languageModelName
            this.vocabularyFilterName = x.vocabularyFilterName
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.LanguageIdSettings = LanguageIdSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
