// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a skipped analytics feature during the analysis of a call analytics job.
 *
 * The `Feature` field indicates the type of analytics feature that was skipped.
 *
 * The `Message` field contains additional information or a message explaining why the analytics feature was skipped.
 *
 * The `ReasonCode` field provides a code indicating the reason why the analytics feature was skipped.
 */
public class CallAnalyticsSkippedFeature private constructor(builder: Builder) {
    /**
     * Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.
     */
    public val feature: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsFeature? = builder.feature
    /**
     * Contains additional information or a message explaining why a specific analytics feature was skipped during the analysis of a call analytics job.
     */
    public val message: kotlin.String? = builder.message
    /**
     * Provides a code indicating the reason why a specific analytics feature was skipped during the analysis of a call analytics job.
     */
    public val reasonCode: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsSkippedReasonCode? = builder.reasonCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsSkippedFeature = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CallAnalyticsSkippedFeature(")
        append("feature=$feature,")
        append("message=$message,")
        append("reasonCode=$reasonCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = feature?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (reasonCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CallAnalyticsSkippedFeature

        if (feature != other.feature) return false
        if (message != other.message) return false
        if (reasonCode != other.reasonCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsSkippedFeature = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.
         */
        public var feature: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsFeature? = null
        /**
         * Contains additional information or a message explaining why a specific analytics feature was skipped during the analysis of a call analytics job.
         */
        public var message: kotlin.String? = null
        /**
         * Provides a code indicating the reason why a specific analytics feature was skipped during the analysis of a call analytics job.
         */
        public var reasonCode: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsSkippedReasonCode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsSkippedFeature) : this() {
            this.feature = x.feature
            this.message = x.message
            this.reasonCode = x.reasonCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsSkippedFeature = CallAnalyticsSkippedFeature(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
