// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Generate subtitles for your media file with your transcription request.
 *
 * You can choose a start index of 0 or 1, and you can specify either WebVTT or SubRip (or both) as your output format.
 *
 * Note that your subtitle files are placed in the same location as your transcription output.
 */
public class Subtitles private constructor(builder: Builder) {
    /**
     * Specify the output format for your subtitle file; if you select both WebVTT (`vtt`) and SubRip (`srt`) formats, two output files are generated.
     */
    public val formats: List<SubtitleFormat>? = builder.formats
    /**
     * Specify the starting value that is assigned to the first subtitle segment.
     *
     * The default start index for Amazon Transcribe is `0`, which differs from the more widely used standard of `1`. If you're uncertain which value to use, we recommend choosing `1`, as this may improve compatibility with other services.
     */
    public val outputStartIndex: kotlin.Int? = builder.outputStartIndex

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.Subtitles = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Subtitles(")
        append("formats=$formats,")
        append("outputStartIndex=$outputStartIndex")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = formats?.hashCode() ?: 0
        result = 31 * result + (outputStartIndex ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Subtitles

        if (formats != other.formats) return false
        if (outputStartIndex != other.outputStartIndex) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.Subtitles = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specify the output format for your subtitle file; if you select both WebVTT (`vtt`) and SubRip (`srt`) formats, two output files are generated.
         */
        public var formats: List<SubtitleFormat>? = null
        /**
         * Specify the starting value that is assigned to the first subtitle segment.
         *
         * The default start index for Amazon Transcribe is `0`, which differs from the more widely used standard of `1`. If you're uncertain which value to use, we recommend choosing `1`, as this may improve compatibility with other services.
         */
        public var outputStartIndex: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.Subtitles) : this() {
            this.formats = x.formats
            this.outputStartIndex = x.outputStartIndex
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.Subtitles = Subtitles(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
