// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartMedicalScribeJobRequest private constructor(builder: Builder) {
    /**
     * Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first participant to speak, you would set `ChannelId` of the first `ChannelDefinition` in the list to `0` (to indicate the first channel) and `ParticipantRole` to `CLINICIAN` (to indicate that it's the clinician speaking). Then you would set the `ChannelId` of the second `ChannelDefinition` in the list to `1` (to indicate the second channel) and `ParticipantRole` to `PATIENT` (to indicate that it's the patient speaking).
     */
    public val channelDefinitions: List<MedicalScribeChannelDefinition>? = builder.channelDefinitions
    /**
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files, write to the output bucket, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions your request fails.
     *
     * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`.
     *
     * For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see [KMS encryption context](https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context) and [Asymmetric keys in KMS](https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html).
     */
    public val kmsEncryptionContext: Map<String, String>? = builder.kmsEncryptionContext
    /**
     * Describes the Amazon S3 location of the media file you want to use in your request.
     *
     * For information on supported media formats, refer to the `MediaFormat` parameter or the [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio) section in the Amazon S3 Developer Guide.
     */
    public val media: aws.sdk.kotlin.services.transcribe.model.Media? = builder.media
    /**
     * A unique name, chosen by you, for your Medical Scribe job.
     *
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new job with the same name as an existing job, you get a `ConflictException` error.
     */
    public val medicalScribeJobName: kotlin.String? = builder.medicalScribeJobName
    /**
     * The name of the Amazon S3 bucket where you want your Medical Scribe output stored. Do not include the `S3://` prefix of the specified bucket.
     *
     * Note that the role specified in the `DataAccessRoleArn` request parameter must have permission to use the specified location. You can change Amazon S3 permissions using the [Amazon Web Services Management Console](https://console.aws.amazon.com/s3). See also [Permissions Required for IAM User Roles](https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
     */
    public val outputBucketName: kotlin.String? = builder.outputBucketName
    /**
     * The KMS key you want to use to encrypt your Medical Scribe output.
     *
     * If using a key located in the **current** Amazon Web Services account, you can specify your KMS key in one of four ways:
     * + Use the KMS key ID itself. For example, `1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Use an alias for the KMS key ID. For example, `alias/ExampleAlias`.
     * + Use the Amazon Resource Name (ARN) for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
     *
     * If using a key located in a **different** Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:
     * + Use the ARN for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
     *
     * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
     *
     * Note that the role specified in the `DataAccessRoleArn` request parameter must have permission to use the specified KMS key.
     */
    public val outputEncryptionKmsKeyId: kotlin.String? = builder.outputEncryptionKmsKeyId
    /**
     * Makes it possible to control how your Medical Scribe job is processed using a `MedicalScribeSettings` object. Specify `ChannelIdentification` if `ChannelDefinitions` are set. Enabled `ShowSpeakerLabels` if `ChannelIdentification` and `ChannelDefinitions` are not set. One and only one of `ChannelIdentification` and `ShowSpeakerLabels` must be set. If `ShowSpeakerLabels` is set, `MaxSpeakerLabels` must also be set. Use `Settings` to specify a vocabulary or vocabulary filter or both using `VocabularyName`, `VocabularyFilterName`. `VocabularyFilterMethod` must be specified if `VocabularyFilterName` is set.
     */
    public val settings: aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings? = builder.settings
    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.StartMedicalScribeJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartMedicalScribeJobRequest(")
        append("channelDefinitions=$channelDefinitions,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("kmsEncryptionContext=$kmsEncryptionContext,")
        append("media=$media,")
        append("medicalScribeJobName=$medicalScribeJobName,")
        append("outputBucketName=$outputBucketName,")
        append("outputEncryptionKmsKeyId=$outputEncryptionKmsKeyId,")
        append("settings=$settings,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelDefinitions?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (kmsEncryptionContext?.hashCode() ?: 0)
        result = 31 * result + (media?.hashCode() ?: 0)
        result = 31 * result + (medicalScribeJobName?.hashCode() ?: 0)
        result = 31 * result + (outputBucketName?.hashCode() ?: 0)
        result = 31 * result + (outputEncryptionKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartMedicalScribeJobRequest

        if (channelDefinitions != other.channelDefinitions) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (kmsEncryptionContext != other.kmsEncryptionContext) return false
        if (media != other.media) return false
        if (medicalScribeJobName != other.medicalScribeJobName) return false
        if (outputBucketName != other.outputBucketName) return false
        if (outputEncryptionKmsKeyId != other.outputEncryptionKmsKeyId) return false
        if (settings != other.settings) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.StartMedicalScribeJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first participant to speak, you would set `ChannelId` of the first `ChannelDefinition` in the list to `0` (to indicate the first channel) and `ParticipantRole` to `CLINICIAN` (to indicate that it's the clinician speaking). Then you would set the `ChannelId` of the second `ChannelDefinition` in the list to `1` (to indicate the second channel) and `ParticipantRole` to `PATIENT` (to indicate that it's the patient speaking).
         */
        public var channelDefinitions: List<MedicalScribeChannelDefinition>? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files, write to the output bucket, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions your request fails.
         *
         * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`.
         *
         * For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see [KMS encryption context](https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context) and [Asymmetric keys in KMS](https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html).
         */
        public var kmsEncryptionContext: Map<String, String>? = null
        /**
         * Describes the Amazon S3 location of the media file you want to use in your request.
         *
         * For information on supported media formats, refer to the `MediaFormat` parameter or the [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio) section in the Amazon S3 Developer Guide.
         */
        public var media: aws.sdk.kotlin.services.transcribe.model.Media? = null
        /**
         * A unique name, chosen by you, for your Medical Scribe job.
         *
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new job with the same name as an existing job, you get a `ConflictException` error.
         */
        public var medicalScribeJobName: kotlin.String? = null
        /**
         * The name of the Amazon S3 bucket where you want your Medical Scribe output stored. Do not include the `S3://` prefix of the specified bucket.
         *
         * Note that the role specified in the `DataAccessRoleArn` request parameter must have permission to use the specified location. You can change Amazon S3 permissions using the [Amazon Web Services Management Console](https://console.aws.amazon.com/s3). See also [Permissions Required for IAM User Roles](https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
         */
        public var outputBucketName: kotlin.String? = null
        /**
         * The KMS key you want to use to encrypt your Medical Scribe output.
         *
         * If using a key located in the **current** Amazon Web Services account, you can specify your KMS key in one of four ways:
         * + Use the KMS key ID itself. For example, `1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Use an alias for the KMS key ID. For example, `alias/ExampleAlias`.
         * + Use the Amazon Resource Name (ARN) for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
         *
         * If using a key located in a **different** Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:
         * + Use the ARN for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
         *
         * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
         *
         * Note that the role specified in the `DataAccessRoleArn` request parameter must have permission to use the specified KMS key.
         */
        public var outputEncryptionKmsKeyId: kotlin.String? = null
        /**
         * Makes it possible to control how your Medical Scribe job is processed using a `MedicalScribeSettings` object. Specify `ChannelIdentification` if `ChannelDefinitions` are set. Enabled `ShowSpeakerLabels` if `ChannelIdentification` and `ChannelDefinitions` are not set. One and only one of `ChannelIdentification` and `ShowSpeakerLabels` must be set. If `ShowSpeakerLabels` is set, `MaxSpeakerLabels` must also be set. Use `Settings` to specify a vocabulary or vocabulary filter or both using `VocabularyName`, `VocabularyFilterName`. `VocabularyFilterMethod` must be specified if `VocabularyFilterName` is set.
         */
        public var settings: aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings? = null
        /**
         * Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.
         *
         * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.StartMedicalScribeJobRequest) : this() {
            this.channelDefinitions = x.channelDefinitions
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.kmsEncryptionContext = x.kmsEncryptionContext
            this.media = x.media
            this.medicalScribeJobName = x.medicalScribeJobName
            this.outputBucketName = x.outputBucketName
            this.outputEncryptionKmsKeyId = x.outputEncryptionKmsKeyId
            this.settings = x.settings
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.StartMedicalScribeJobRequest = StartMedicalScribeJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.Media] inside the given [block]
         */
        public fun media(block: aws.sdk.kotlin.services.transcribe.model.Media.Builder.() -> kotlin.Unit) {
            this.media = aws.sdk.kotlin.services.transcribe.model.Media.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
