// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Allows additional optional settings in your request, including channel identification, alternative transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your transcription job.
 */
public class Settings private constructor(builder: Builder) {
    /**
     * Enables channel identification in multi-channel audio.
     *
     * Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.
     *
     * For more information, see [Transcribing multi-channel audio](https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
     */
    public val channelIdentification: kotlin.Boolean? = builder.channelIdentification
    /**
     * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe to include in your transcript.
     *
     * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe, only the actual number of alternative transcriptions are included.
     *
     * If you include `MaxAlternatives` in your request, you must also include `ShowAlternatives` with a value of `true`.
     *
     * For more information, see [Alternative transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
     */
    public val maxAlternatives: kotlin.Int? = builder.maxAlternatives
    /**
     * Specify the maximum number of speakers you want to partition in your media.
     *
     * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a single speaker.
     *
     * If you specify the `MaxSpeakerLabels` field, you must set the `ShowSpeakerLabels` field to true.
     */
    public val maxSpeakerLabels: kotlin.Int? = builder.maxSpeakerLabels
    /**
     * To include alternative transcriptions within your transcription output, include `ShowAlternatives` in your transcription request.
     *
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript does not separate the speech by channel.
     *
     * If you include `ShowAlternatives`, you must also include `MaxAlternatives`, which is the maximum number of alternative transcriptions you want Amazon Transcribe to generate.
     *
     * For more information, see [Alternative transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
     */
    public val showAlternatives: kotlin.Boolean? = builder.showAlternatives
    /**
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.
     *
     * If you enable `ShowSpeakerLabels` in your request, you must also include `MaxSpeakerLabels`.
     *
     * For more information, see [Partitioning speakers (diarization)](https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
     */
    public val showSpeakerLabels: kotlin.Boolean? = builder.showSpeakerLabels
    /**
     * Specify how you want your custom vocabulary filter applied to your transcript.
     *
     * To replace words with `***`, choose `mask`.
     *
     * To delete words, choose `remove`.
     *
     * To flag words without changing them, choose `tag`.
     */
    public val vocabularyFilterMethod: aws.sdk.kotlin.services.transcribe.model.VocabularyFilterMethod? = builder.vocabularyFilterMethod
    /**
     * The name of the custom vocabulary filter you want to use in your transcription job request. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
     *
     * Note that if you include `VocabularyFilterName` in your request, you must also include `VocabularyFilterMethod`.
     */
    public val vocabularyFilterName: kotlin.String? = builder.vocabularyFilterName
    /**
     * The name of the custom vocabulary you want to use in your transcription job request. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Settings(")
        append("channelIdentification=$channelIdentification,")
        append("maxAlternatives=$maxAlternatives,")
        append("maxSpeakerLabels=$maxSpeakerLabels,")
        append("showAlternatives=$showAlternatives,")
        append("showSpeakerLabels=$showSpeakerLabels,")
        append("vocabularyFilterMethod=$vocabularyFilterMethod,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("vocabularyName=$vocabularyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelIdentification?.hashCode() ?: 0
        result = 31 * result + (maxAlternatives ?: 0)
        result = 31 * result + (maxSpeakerLabels ?: 0)
        result = 31 * result + (showAlternatives?.hashCode() ?: 0)
        result = 31 * result + (showSpeakerLabels?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterMethod?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Settings

        if (channelIdentification != other.channelIdentification) return false
        if (maxAlternatives != other.maxAlternatives) return false
        if (maxSpeakerLabels != other.maxSpeakerLabels) return false
        if (showAlternatives != other.showAlternatives) return false
        if (showSpeakerLabels != other.showSpeakerLabels) return false
        if (vocabularyFilterMethod != other.vocabularyFilterMethod) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.Settings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Enables channel identification in multi-channel audio.
         *
         * Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.
         *
         * For more information, see [Transcribing multi-channel audio](https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
         */
        public var channelIdentification: kotlin.Boolean? = null
        /**
         * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe to include in your transcript.
         *
         * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe, only the actual number of alternative transcriptions are included.
         *
         * If you include `MaxAlternatives` in your request, you must also include `ShowAlternatives` with a value of `true`.
         *
         * For more information, see [Alternative transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
         */
        public var maxAlternatives: kotlin.Int? = null
        /**
         * Specify the maximum number of speakers you want to partition in your media.
         *
         * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a single speaker.
         *
         * If you specify the `MaxSpeakerLabels` field, you must set the `ShowSpeakerLabels` field to true.
         */
        public var maxSpeakerLabels: kotlin.Int? = null
        /**
         * To include alternative transcriptions within your transcription output, include `ShowAlternatives` in your transcription request.
         *
         * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript does not separate the speech by channel.
         *
         * If you include `ShowAlternatives`, you must also include `MaxAlternatives`, which is the maximum number of alternative transcriptions you want Amazon Transcribe to generate.
         *
         * For more information, see [Alternative transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
         */
        public var showAlternatives: kotlin.Boolean? = null
        /**
         * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.
         *
         * If you enable `ShowSpeakerLabels` in your request, you must also include `MaxSpeakerLabels`.
         *
         * For more information, see [Partitioning speakers (diarization)](https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
         */
        public var showSpeakerLabels: kotlin.Boolean? = null
        /**
         * Specify how you want your custom vocabulary filter applied to your transcript.
         *
         * To replace words with `***`, choose `mask`.
         *
         * To delete words, choose `remove`.
         *
         * To flag words without changing them, choose `tag`.
         */
        public var vocabularyFilterMethod: aws.sdk.kotlin.services.transcribe.model.VocabularyFilterMethod? = null
        /**
         * The name of the custom vocabulary filter you want to use in your transcription job request. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         *
         * Note that if you include `VocabularyFilterName` in your request, you must also include `VocabularyFilterMethod`.
         */
        public var vocabularyFilterName: kotlin.String? = null
        /**
         * The name of the custom vocabulary you want to use in your transcription job request. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.Settings) : this() {
            this.channelIdentification = x.channelIdentification
            this.maxAlternatives = x.maxAlternatives
            this.maxSpeakerLabels = x.maxSpeakerLabels
            this.showAlternatives = x.showAlternatives
            this.showSpeakerLabels = x.showSpeakerLabels
            this.vocabularyFilterMethod = x.vocabularyFilterMethod
            this.vocabularyFilterName = x.vocabularyFilterName
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.Settings = Settings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
