// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.serde

import aws.sdk.kotlin.services.transcribe.model.LanguageCode
import aws.sdk.kotlin.services.transcribe.model.Media
import aws.sdk.kotlin.services.transcribe.model.MediaFormat
import aws.sdk.kotlin.services.transcribe.model.MedicalContentIdentificationType
import aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting
import aws.sdk.kotlin.services.transcribe.model.Specialty
import aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.Tag
import aws.sdk.kotlin.services.transcribe.model.Type
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartMedicalTranscriptionJobOperationSerializer: HttpSerializer.NonStreaming<StartMedicalTranscriptionJobRequest> {
    override fun serialize(context: ExecutionContext, input: StartMedicalTranscriptionJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeStartMedicalTranscriptionJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeStartMedicalTranscriptionJobOperationBody(context: ExecutionContext, input: StartMedicalTranscriptionJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTENTIDENTIFICATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ContentIdentificationType"))
    val KMSENCRYPTIONCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("KMSEncryptionContext"))
    val LANGUAGECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("LanguageCode"))
    val MEDIA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Media"))
    val MEDIAFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MediaFormat"))
    val MEDIASAMPLERATEHERTZ_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MediaSampleRateHertz"))
    val MEDICALTRANSCRIPTIONJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MedicalTranscriptionJobName"))
    val OUTPUTBUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputBucketName"))
    val OUTPUTENCRYPTIONKMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputEncryptionKMSKeyId"))
    val OUTPUTKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputKey"))
    val SETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Settings"))
    val SPECIALTY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Specialty"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTIDENTIFICATIONTYPE_DESCRIPTOR)
        field(KMSENCRYPTIONCONTEXT_DESCRIPTOR)
        field(LANGUAGECODE_DESCRIPTOR)
        field(MEDIA_DESCRIPTOR)
        field(MEDIAFORMAT_DESCRIPTOR)
        field(MEDIASAMPLERATEHERTZ_DESCRIPTOR)
        field(MEDICALTRANSCRIPTIONJOBNAME_DESCRIPTOR)
        field(OUTPUTBUCKETNAME_DESCRIPTOR)
        field(OUTPUTENCRYPTIONKMSKEYID_DESCRIPTOR)
        field(OUTPUTKEY_DESCRIPTOR)
        field(SETTINGS_DESCRIPTOR)
        field(SPECIALTY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.contentIdentificationType?.let { field(CONTENTIDENTIFICATIONTYPE_DESCRIPTOR, it.value) }
        if (input.kmsEncryptionContext != null) {
            mapField(KMSENCRYPTIONCONTEXT_DESCRIPTOR) {
                input.kmsEncryptionContext.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.languageCode?.let { field(LANGUAGECODE_DESCRIPTOR, it.value) }
        input.media?.let { field(MEDIA_DESCRIPTOR, it, ::serializeMediaDocument) }
        input.mediaFormat?.let { field(MEDIAFORMAT_DESCRIPTOR, it.value) }
        input.mediaSampleRateHertz?.let { field(MEDIASAMPLERATEHERTZ_DESCRIPTOR, it) }
        input.medicalTranscriptionJobName?.let { field(MEDICALTRANSCRIPTIONJOBNAME_DESCRIPTOR, it) }
        input.outputBucketName?.let { field(OUTPUTBUCKETNAME_DESCRIPTOR, it) }
        input.outputEncryptionKmsKeyId?.let { field(OUTPUTENCRYPTIONKMSKEYID_DESCRIPTOR, it) }
        input.outputKey?.let { field(OUTPUTKEY_DESCRIPTOR, it) }
        input.settings?.let { field(SETTINGS_DESCRIPTOR, it, ::serializeMedicalTranscriptionSettingDocument) }
        input.specialty?.let { field(SPECIALTY_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
