// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides detailed information about a specific transcription job.
 */
public class TranscriptionJobSummary private constructor(builder: Builder) {
    /**
     * The date and time the specified transcription job finished processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:33:13.922000-07:00` represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * The content redaction settings of the transcription job.
     */
    public val contentRedaction: aws.sdk.kotlin.services.transcribe.model.ContentRedaction? = builder.contentRedaction
    /**
     * The date and time the specified transcription job request was made.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * If `TranscriptionJobStatus` is `FAILED`, `FailureReason` contains information about why the transcription job failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The confidence score associated with the language identified in your media file.
     *
     * Confidence scores are values between 0 and 1; a larger value indicates a higher probability that the identified language correctly matches the language spoken in your media.
     */
    public val identifiedLanguageScore: kotlin.Float? = builder.identifiedLanguageScore
    /**
     * Indicates whether automatic language identification was enabled (`TRUE`) for the specified transcription job.
     */
    public val identifyLanguage: kotlin.Boolean? = builder.identifyLanguage
    /**
     * Indicates whether automatic multi-language identification was enabled (`TRUE`) for the specified transcription job.
     */
    public val identifyMultipleLanguages: kotlin.Boolean? = builder.identifyMultipleLanguages
    /**
     * The language code used to create your transcription.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * The language codes used to create your transcription job. This parameter is used with multi-language identification. For single-language identification, the singular version of this parameter, `LanguageCode`, is present.
     */
    public val languageCodes: List<LanguageCodeItem>? = builder.languageCodes
    /**
     * Provides the name of the custom language model that was included in the specified transcription job.
     *
     * Only use `ModelSettings` with the `LanguageModelName` sub-parameter if you're **not** using automatic language identification (``). If using `LanguageIdSettings` in your request, this parameter contains a `LanguageModelName` sub-parameter.
     */
    public val modelSettings: aws.sdk.kotlin.services.transcribe.model.ModelSettings? = builder.modelSettings
    /**
     * Indicates where the specified transcription output is stored.
     *
     * If the value is `CUSTOMER_BUCKET`, the location is the Amazon S3 bucket you specified using the `OutputBucketName` parameter in your request. If you also included `OutputKey` in your request, your output is located in the path you specified in your request.
     *
     * If the value is `SERVICE_BUCKET`, the location is a service-managed Amazon S3 bucket. To access a transcript stored in a service-managed bucket, use the URI shown in the `TranscriptFileUri` or `RedactedTranscriptFileUri` field.
     */
    public val outputLocationType: aws.sdk.kotlin.services.transcribe.model.OutputLocationType? = builder.outputLocationType
    /**
     * The date and time your transcription job began processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Indicates whether toxicity detection was enabled for the specified transcription job.
     */
    public val toxicityDetection: List<ToxicityDetectionSettings>? = builder.toxicityDetection
    /**
     * The name of the transcription job. Job names are case sensitive and must be unique within an Amazon Web Services account.
     */
    public val transcriptionJobName: kotlin.String? = builder.transcriptionJobName
    /**
     * Provides the status of your transcription job.
     *
     * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri` (or `RedactedTranscriptFileUri`, if you requested transcript redaction). If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     */
    public val transcriptionJobStatus: aws.sdk.kotlin.services.transcribe.model.TranscriptionJobStatus? = builder.transcriptionJobStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.TranscriptionJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TranscriptionJobSummary(")
        append("completionTime=$completionTime,")
        append("contentRedaction=$contentRedaction,")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("identifiedLanguageScore=$identifiedLanguageScore,")
        append("identifyLanguage=$identifyLanguage,")
        append("identifyMultipleLanguages=$identifyMultipleLanguages,")
        append("languageCode=$languageCode,")
        append("languageCodes=$languageCodes,")
        append("modelSettings=$modelSettings,")
        append("outputLocationType=$outputLocationType,")
        append("startTime=$startTime,")
        append("toxicityDetection=$toxicityDetection,")
        append("transcriptionJobName=$transcriptionJobName,")
        append("transcriptionJobStatus=$transcriptionJobStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionTime?.hashCode() ?: 0
        result = 31 * result + (contentRedaction?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (identifiedLanguageScore?.hashCode() ?: 0)
        result = 31 * result + (identifyLanguage?.hashCode() ?: 0)
        result = 31 * result + (identifyMultipleLanguages?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (languageCodes?.hashCode() ?: 0)
        result = 31 * result + (modelSettings?.hashCode() ?: 0)
        result = 31 * result + (outputLocationType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (toxicityDetection?.hashCode() ?: 0)
        result = 31 * result + (transcriptionJobName?.hashCode() ?: 0)
        result = 31 * result + (transcriptionJobStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TranscriptionJobSummary

        if (completionTime != other.completionTime) return false
        if (contentRedaction != other.contentRedaction) return false
        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (identifiedLanguageScore != other.identifiedLanguageScore) return false
        if (identifyLanguage != other.identifyLanguage) return false
        if (identifyMultipleLanguages != other.identifyMultipleLanguages) return false
        if (languageCode != other.languageCode) return false
        if (languageCodes != other.languageCodes) return false
        if (modelSettings != other.modelSettings) return false
        if (outputLocationType != other.outputLocationType) return false
        if (startTime != other.startTime) return false
        if (toxicityDetection != other.toxicityDetection) return false
        if (transcriptionJobName != other.transcriptionJobName) return false
        if (transcriptionJobStatus != other.transcriptionJobStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.TranscriptionJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the specified transcription job finished processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:33:13.922000-07:00` represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The content redaction settings of the transcription job.
         */
        public var contentRedaction: aws.sdk.kotlin.services.transcribe.model.ContentRedaction? = null
        /**
         * The date and time the specified transcription job request was made.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If `TranscriptionJobStatus` is `FAILED`, `FailureReason` contains information about why the transcription job failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The confidence score associated with the language identified in your media file.
         *
         * Confidence scores are values between 0 and 1; a larger value indicates a higher probability that the identified language correctly matches the language spoken in your media.
         */
        public var identifiedLanguageScore: kotlin.Float? = null
        /**
         * Indicates whether automatic language identification was enabled (`TRUE`) for the specified transcription job.
         */
        public var identifyLanguage: kotlin.Boolean? = null
        /**
         * Indicates whether automatic multi-language identification was enabled (`TRUE`) for the specified transcription job.
         */
        public var identifyMultipleLanguages: kotlin.Boolean? = null
        /**
         * The language code used to create your transcription.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * The language codes used to create your transcription job. This parameter is used with multi-language identification. For single-language identification, the singular version of this parameter, `LanguageCode`, is present.
         */
        public var languageCodes: List<LanguageCodeItem>? = null
        /**
         * Provides the name of the custom language model that was included in the specified transcription job.
         *
         * Only use `ModelSettings` with the `LanguageModelName` sub-parameter if you're **not** using automatic language identification (``). If using `LanguageIdSettings` in your request, this parameter contains a `LanguageModelName` sub-parameter.
         */
        public var modelSettings: aws.sdk.kotlin.services.transcribe.model.ModelSettings? = null
        /**
         * Indicates where the specified transcription output is stored.
         *
         * If the value is `CUSTOMER_BUCKET`, the location is the Amazon S3 bucket you specified using the `OutputBucketName` parameter in your request. If you also included `OutputKey` in your request, your output is located in the path you specified in your request.
         *
         * If the value is `SERVICE_BUCKET`, the location is a service-managed Amazon S3 bucket. To access a transcript stored in a service-managed bucket, use the URI shown in the `TranscriptFileUri` or `RedactedTranscriptFileUri` field.
         */
        public var outputLocationType: aws.sdk.kotlin.services.transcribe.model.OutputLocationType? = null
        /**
         * The date and time your transcription job began processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether toxicity detection was enabled for the specified transcription job.
         */
        public var toxicityDetection: List<ToxicityDetectionSettings>? = null
        /**
         * The name of the transcription job. Job names are case sensitive and must be unique within an Amazon Web Services account.
         */
        public var transcriptionJobName: kotlin.String? = null
        /**
         * Provides the status of your transcription job.
         *
         * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri` (or `RedactedTranscriptFileUri`, if you requested transcript redaction). If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
         */
        public var transcriptionJobStatus: aws.sdk.kotlin.services.transcribe.model.TranscriptionJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.TranscriptionJobSummary) : this() {
            this.completionTime = x.completionTime
            this.contentRedaction = x.contentRedaction
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.identifiedLanguageScore = x.identifiedLanguageScore
            this.identifyLanguage = x.identifyLanguage
            this.identifyMultipleLanguages = x.identifyMultipleLanguages
            this.languageCode = x.languageCode
            this.languageCodes = x.languageCodes
            this.modelSettings = x.modelSettings
            this.outputLocationType = x.outputLocationType
            this.startTime = x.startTime
            this.toxicityDetection = x.toxicityDetection
            this.transcriptionJobName = x.transcriptionJobName
            this.transcriptionJobStatus = x.transcriptionJobStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.TranscriptionJobSummary = TranscriptionJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.ContentRedaction] inside the given [block]
         */
        public fun contentRedaction(block: aws.sdk.kotlin.services.transcribe.model.ContentRedaction.Builder.() -> kotlin.Unit) {
            this.contentRedaction = aws.sdk.kotlin.services.transcribe.model.ContentRedaction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.ModelSettings] inside the given [block]
         */
        public fun modelSettings(block: aws.sdk.kotlin.services.transcribe.model.ModelSettings.Builder.() -> kotlin.Unit) {
            this.modelSettings = aws.sdk.kotlin.services.transcribe.model.ModelSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
