// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.paginators

import aws.sdk.kotlin.services.transcribe.TranscribeClient
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsCategoriesRequest
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsCategoriesResponse
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListLanguageModelsRequest
import aws.sdk.kotlin.services.transcribe.model.ListLanguageModelsResponse
import aws.sdk.kotlin.services.transcribe.model.ListMedicalScribeJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListMedicalScribeJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListMedicalVocabulariesRequest
import aws.sdk.kotlin.services.transcribe.model.ListMedicalVocabulariesResponse
import aws.sdk.kotlin.services.transcribe.model.ListTranscriptionJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListTranscriptionJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListVocabulariesRequest
import aws.sdk.kotlin.services.transcribe.model.ListVocabulariesResponse
import aws.sdk.kotlin.services.transcribe.model.ListVocabularyFiltersRequest
import aws.sdk.kotlin.services.transcribe.model.ListVocabularyFiltersResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListCallAnalyticsCategoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCallAnalyticsCategoriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCallAnalyticsCategoriesResponse]
 */
public fun TranscribeClient.listCallAnalyticsCategoriesPaginated(initialRequest: ListCallAnalyticsCategoriesRequest = ListCallAnalyticsCategoriesRequest { }): Flow<ListCallAnalyticsCategoriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCallAnalyticsCategoriesPaginated.listCallAnalyticsCategories(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCallAnalyticsCategoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCallAnalyticsCategoriesResponse]
 */
public fun TranscribeClient.listCallAnalyticsCategoriesPaginated(block: ListCallAnalyticsCategoriesRequest.Builder.() -> Unit): Flow<ListCallAnalyticsCategoriesResponse> =
    listCallAnalyticsCategoriesPaginated(ListCallAnalyticsCategoriesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListCallAnalyticsJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCallAnalyticsJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCallAnalyticsJobsResponse]
 */
public fun TranscribeClient.listCallAnalyticsJobsPaginated(initialRequest: ListCallAnalyticsJobsRequest = ListCallAnalyticsJobsRequest { }): Flow<ListCallAnalyticsJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCallAnalyticsJobsPaginated.listCallAnalyticsJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCallAnalyticsJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCallAnalyticsJobsResponse]
 */
public fun TranscribeClient.listCallAnalyticsJobsPaginated(block: ListCallAnalyticsJobsRequest.Builder.() -> Unit): Flow<ListCallAnalyticsJobsResponse> =
    listCallAnalyticsJobsPaginated(ListCallAnalyticsJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLanguageModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLanguageModelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLanguageModelsResponse]
 */
public fun TranscribeClient.listLanguageModelsPaginated(initialRequest: ListLanguageModelsRequest = ListLanguageModelsRequest { }): Flow<ListLanguageModelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLanguageModelsPaginated.listLanguageModels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLanguageModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLanguageModelsResponse]
 */
public fun TranscribeClient.listLanguageModelsPaginated(block: ListLanguageModelsRequest.Builder.() -> Unit): Flow<ListLanguageModelsResponse> =
    listLanguageModelsPaginated(ListLanguageModelsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMedicalScribeJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMedicalScribeJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMedicalScribeJobsResponse]
 */
public fun TranscribeClient.listMedicalScribeJobsPaginated(initialRequest: ListMedicalScribeJobsRequest = ListMedicalScribeJobsRequest { }): Flow<ListMedicalScribeJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMedicalScribeJobsPaginated.listMedicalScribeJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMedicalScribeJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMedicalScribeJobsResponse]
 */
public fun TranscribeClient.listMedicalScribeJobsPaginated(block: ListMedicalScribeJobsRequest.Builder.() -> Unit): Flow<ListMedicalScribeJobsResponse> =
    listMedicalScribeJobsPaginated(ListMedicalScribeJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMedicalTranscriptionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMedicalTranscriptionJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMedicalTranscriptionJobsResponse]
 */
public fun TranscribeClient.listMedicalTranscriptionJobsPaginated(initialRequest: ListMedicalTranscriptionJobsRequest = ListMedicalTranscriptionJobsRequest { }): Flow<ListMedicalTranscriptionJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMedicalTranscriptionJobsPaginated.listMedicalTranscriptionJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMedicalTranscriptionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMedicalTranscriptionJobsResponse]
 */
public fun TranscribeClient.listMedicalTranscriptionJobsPaginated(block: ListMedicalTranscriptionJobsRequest.Builder.() -> Unit): Flow<ListMedicalTranscriptionJobsResponse> =
    listMedicalTranscriptionJobsPaginated(ListMedicalTranscriptionJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMedicalVocabulariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMedicalVocabulariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMedicalVocabulariesResponse]
 */
public fun TranscribeClient.listMedicalVocabulariesPaginated(initialRequest: ListMedicalVocabulariesRequest = ListMedicalVocabulariesRequest { }): Flow<ListMedicalVocabulariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMedicalVocabulariesPaginated.listMedicalVocabularies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMedicalVocabulariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMedicalVocabulariesResponse]
 */
public fun TranscribeClient.listMedicalVocabulariesPaginated(block: ListMedicalVocabulariesRequest.Builder.() -> Unit): Flow<ListMedicalVocabulariesResponse> =
    listMedicalVocabulariesPaginated(ListMedicalVocabulariesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTranscriptionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTranscriptionJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTranscriptionJobsResponse]
 */
public fun TranscribeClient.listTranscriptionJobsPaginated(initialRequest: ListTranscriptionJobsRequest = ListTranscriptionJobsRequest { }): Flow<ListTranscriptionJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTranscriptionJobsPaginated.listTranscriptionJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTranscriptionJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTranscriptionJobsResponse]
 */
public fun TranscribeClient.listTranscriptionJobsPaginated(block: ListTranscriptionJobsRequest.Builder.() -> Unit): Flow<ListTranscriptionJobsResponse> =
    listTranscriptionJobsPaginated(ListTranscriptionJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListVocabulariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVocabulariesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVocabulariesResponse]
 */
public fun TranscribeClient.listVocabulariesPaginated(initialRequest: ListVocabulariesRequest = ListVocabulariesRequest { }): Flow<ListVocabulariesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVocabulariesPaginated.listVocabularies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVocabulariesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVocabulariesResponse]
 */
public fun TranscribeClient.listVocabulariesPaginated(block: ListVocabulariesRequest.Builder.() -> Unit): Flow<ListVocabulariesResponse> =
    listVocabulariesPaginated(ListVocabulariesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListVocabularyFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVocabularyFiltersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVocabularyFiltersResponse]
 */
public fun TranscribeClient.listVocabularyFiltersPaginated(initialRequest: ListVocabularyFiltersRequest = ListVocabularyFiltersRequest { }): Flow<ListVocabularyFiltersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVocabularyFiltersPaginated.listVocabularyFilters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVocabularyFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVocabularyFiltersResponse]
 */
public fun TranscribeClient.listVocabularyFiltersPaginated(block: ListVocabularyFiltersRequest.Builder.() -> Unit): Flow<ListVocabularyFiltersResponse> =
    listVocabularyFiltersPaginated(ListVocabularyFiltersRequest.Builder().apply(block).build())
