// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Makes it possible to control how your Medical Scribe job is processed using a `MedicalScribeSettings` object. Specify `ChannelIdentification` if `ChannelDefinitions` are set. Enabled `ShowSpeakerLabels` if `ChannelIdentification` and `ChannelDefinitions` are not set. One and only one of `ChannelIdentification` and `ShowSpeakerLabels` must be set. If `ShowSpeakerLabels` is set, `MaxSpeakerLabels` must also be set. Use `Settings` to specify a vocabulary or vocabulary filter or both using `VocabularyName`, `VocabularyFilterName`. `VocabularyFilterMethod` must be specified if `VocabularyFilterName` is set.
 */
public class MedicalScribeSettings private constructor(builder: Builder) {
    /**
     * Enables channel identification in multi-channel audio.
     *
     * Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.
     *
     * For more information, see [Transcribing multi-channel audio](https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
     */
    public val channelIdentification: kotlin.Boolean? = builder.channelIdentification
    /**
     * Specify the maximum number of speakers you want to partition in your media.
     *
     * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a single speaker.
     *
     * If you specify the `MaxSpeakerLabels` field, you must set the `ShowSpeakerLabels` field to true.
     */
    public val maxSpeakerLabels: kotlin.Int? = builder.maxSpeakerLabels
    /**
     * Enables speaker partitioning (diarization) in your Medical Scribe output. Speaker partitioning labels the speech from individual speakers in your media file.
     *
     * If you enable `ShowSpeakerLabels` in your request, you must also include `MaxSpeakerLabels`.
     *
     * For more information, see [Partitioning speakers (diarization)](https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
     */
    public val showSpeakerLabels: kotlin.Boolean? = builder.showSpeakerLabels
    /**
     * Specify how you want your custom vocabulary filter applied to your transcript.
     *
     * To replace words with `***`, choose `mask`.
     *
     * To delete words, choose `remove`.
     *
     * To flag words without changing them, choose `tag`.
     */
    public val vocabularyFilterMethod: aws.sdk.kotlin.services.transcribe.model.VocabularyFilterMethod? = builder.vocabularyFilterMethod
    /**
     * The name of the custom vocabulary filter you want to include in your Medical Scribe request. Custom vocabulary filter names are case sensitive.
     *
     * Note that if you include `VocabularyFilterName` in your request, you must also include `VocabularyFilterMethod`.
     */
    public val vocabularyFilterName: kotlin.String? = builder.vocabularyFilterName
    /**
     * The name of the custom vocabulary you want to include in your Medical Scribe request. Custom vocabulary names are case sensitive.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MedicalScribeSettings(")
        append("channelIdentification=$channelIdentification,")
        append("maxSpeakerLabels=$maxSpeakerLabels,")
        append("showSpeakerLabels=$showSpeakerLabels,")
        append("vocabularyFilterMethod=$vocabularyFilterMethod,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("vocabularyName=$vocabularyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelIdentification?.hashCode() ?: 0
        result = 31 * result + (maxSpeakerLabels ?: 0)
        result = 31 * result + (showSpeakerLabels?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterMethod?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MedicalScribeSettings

        if (channelIdentification != other.channelIdentification) return false
        if (maxSpeakerLabels != other.maxSpeakerLabels) return false
        if (showSpeakerLabels != other.showSpeakerLabels) return false
        if (vocabularyFilterMethod != other.vocabularyFilterMethod) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Enables channel identification in multi-channel audio.
         *
         * Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.
         *
         * For more information, see [Transcribing multi-channel audio](https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
         */
        public var channelIdentification: kotlin.Boolean? = null
        /**
         * Specify the maximum number of speakers you want to partition in your media.
         *
         * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a single speaker.
         *
         * If you specify the `MaxSpeakerLabels` field, you must set the `ShowSpeakerLabels` field to true.
         */
        public var maxSpeakerLabels: kotlin.Int? = null
        /**
         * Enables speaker partitioning (diarization) in your Medical Scribe output. Speaker partitioning labels the speech from individual speakers in your media file.
         *
         * If you enable `ShowSpeakerLabels` in your request, you must also include `MaxSpeakerLabels`.
         *
         * For more information, see [Partitioning speakers (diarization)](https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
         */
        public var showSpeakerLabels: kotlin.Boolean? = null
        /**
         * Specify how you want your custom vocabulary filter applied to your transcript.
         *
         * To replace words with `***`, choose `mask`.
         *
         * To delete words, choose `remove`.
         *
         * To flag words without changing them, choose `tag`.
         */
        public var vocabularyFilterMethod: aws.sdk.kotlin.services.transcribe.model.VocabularyFilterMethod? = null
        /**
         * The name of the custom vocabulary filter you want to include in your Medical Scribe request. Custom vocabulary filter names are case sensitive.
         *
         * Note that if you include `VocabularyFilterName` in your request, you must also include `VocabularyFilterMethod`.
         */
        public var vocabularyFilterName: kotlin.String? = null
        /**
         * The name of the custom vocabulary you want to include in your Medical Scribe request. Custom vocabulary names are case sensitive.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings) : this() {
            this.channelIdentification = x.channelIdentification
            this.maxSpeakerLabels = x.maxSpeakerLabels
            this.showSpeakerLabels = x.showSpeakerLabels
            this.vocabularyFilterMethod = x.vocabularyFilterMethod
            this.vocabularyFilterName = x.vocabularyFilterName
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings = MedicalScribeSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
