// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides detailed information about a specific Medical Scribe job.
 */
public class MedicalScribeJobSummary private constructor(builder: Builder) {
    /**
     * The date and time the specified Medical Scribe job finished processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a Medical Scribe job that finished processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * The date and time the specified Medical Scribe job request was made.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * If `MedicalScribeJobStatus` is `FAILED`, `FailureReason` contains information about why the transcription job failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The language code used to create your Medical Scribe job. US English (`en-US`) is the only supported language for Medical Scribe jobs.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.MedicalScribeLanguageCode? = builder.languageCode
    /**
     * The name of the Medical Scribe job. Job names are case sensitive and must be unique within an Amazon Web Services account.
     */
    public val medicalScribeJobName: kotlin.String? = builder.medicalScribeJobName
    /**
     * Provides the status of the specified Medical Scribe job.
     *
     * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `MedicalScribeOutput` If the status is `FAILED`, `FailureReason` provides details on why your Medical Scribe job failed.
     */
    public val medicalScribeJobStatus: aws.sdk.kotlin.services.transcribe.model.MedicalScribeJobStatus? = builder.medicalScribeJobStatus
    /**
     * The date and time your Medical Scribe job began processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.MedicalScribeJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MedicalScribeJobSummary(")
        append("completionTime=$completionTime,")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("languageCode=$languageCode,")
        append("medicalScribeJobName=$medicalScribeJobName,")
        append("medicalScribeJobStatus=$medicalScribeJobStatus,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionTime?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (medicalScribeJobName?.hashCode() ?: 0)
        result = 31 * result + (medicalScribeJobStatus?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MedicalScribeJobSummary

        if (completionTime != other.completionTime) return false
        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (languageCode != other.languageCode) return false
        if (medicalScribeJobName != other.medicalScribeJobName) return false
        if (medicalScribeJobStatus != other.medicalScribeJobStatus) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.MedicalScribeJobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the specified Medical Scribe job finished processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a Medical Scribe job that finished processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time the specified Medical Scribe job request was made.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If `MedicalScribeJobStatus` is `FAILED`, `FailureReason` contains information about why the transcription job failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The language code used to create your Medical Scribe job. US English (`en-US`) is the only supported language for Medical Scribe jobs.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.MedicalScribeLanguageCode? = null
        /**
         * The name of the Medical Scribe job. Job names are case sensitive and must be unique within an Amazon Web Services account.
         */
        public var medicalScribeJobName: kotlin.String? = null
        /**
         * Provides the status of the specified Medical Scribe job.
         *
         * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `MedicalScribeOutput` If the status is `FAILED`, `FailureReason` provides details on why your Medical Scribe job failed.
         */
        public var medicalScribeJobStatus: aws.sdk.kotlin.services.transcribe.model.MedicalScribeJobStatus? = null
        /**
         * The date and time your Medical Scribe job began processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.MedicalScribeJobSummary) : this() {
            this.completionTime = x.completionTime
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.languageCode = x.languageCode
            this.medicalScribeJobName = x.medicalScribeJobName
            this.medicalScribeJobStatus = x.medicalScribeJobStatus
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.MedicalScribeJobSummary = MedicalScribeJobSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
