// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartCallAnalyticsJobRequest private constructor(builder: Builder) {
    /**
     * A unique name, chosen by you, for your Call Analytics job.
     *
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new job with the same name as an existing job, you get a `ConflictException` error.
     */
    public val callAnalyticsJobName: kotlin.String? = builder.callAnalyticsJobName
    /**
     * Makes it possible to specify which speaker is on which channel. For example, if your agent is the first participant to speak, you would set `ChannelId` to `0` (to indicate the first channel) and `ParticipantRole` to `AGENT` (to indicate that it's the agent speaking).
     */
    public val channelDefinitions: List<ChannelDefinition>? = builder.channelDefinitions
    /**
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.
     *
     * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`.
     *
     * For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * Describes the Amazon S3 location of the media file you want to use in your Call Analytics request.
     */
    public val media: aws.sdk.kotlin.services.transcribe.model.Media? = builder.media
    /**
     * The KMS key you want to use to encrypt your Call Analytics output.
     *
     * If using a key located in the **current** Amazon Web Services account, you can specify your KMS key in one of four ways:
     * + Use the KMS key ID itself. For example, `1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Use an alias for the KMS key ID. For example, `alias/ExampleAlias`.
     * + Use the Amazon Resource Name (ARN) for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
     *
     * If using a key located in a **different** Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:
     * + Use the ARN for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
     *
     * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
     *
     * If you specify a KMS key to encrypt your output, you must also specify an output location using the `OutputLocation` parameter.
     *
     * Note that the role making the request must have permission to use the specified KMS key.
     */
    public val outputEncryptionKmsKeyId: kotlin.String? = builder.outputEncryptionKmsKeyId
    /**
     * The Amazon S3 location where you want your Call Analytics transcription output stored. You can use any of the following formats to specify the output location:
     * + s3://DOC-EXAMPLE-BUCKET
     * + s3://DOC-EXAMPLE-BUCKET/my-output-folder/
     * + s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
     *
     * Unless you specify a file name (option 3), the name of your output file has a default value that matches the name you specified for your transcription job using the `CallAnalyticsJobName` parameter.
     *
     * You can specify a KMS key to encrypt your output using the `OutputEncryptionKMSKeyId` parameter. If you do not specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption.
     *
     * If you do not specify `OutputLocation`, your transcript is placed in a service-managed Amazon S3 bucket and you are provided with a URI to access your transcript.
     */
    public val outputLocation: kotlin.String? = builder.outputLocation
    /**
     * Specify additional optional settings in your request, including content redaction; allows you to apply custom language models, vocabulary filters, and custom vocabularies to your Call Analytics job.
     */
    public val settings: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings? = builder.settings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.StartCallAnalyticsJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartCallAnalyticsJobRequest(")
        append("callAnalyticsJobName=$callAnalyticsJobName,")
        append("channelDefinitions=$channelDefinitions,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("media=$media,")
        append("outputEncryptionKmsKeyId=$outputEncryptionKmsKeyId,")
        append("outputLocation=$outputLocation,")
        append("settings=$settings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callAnalyticsJobName?.hashCode() ?: 0
        result = 31 * result + (channelDefinitions?.hashCode() ?: 0)
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (media?.hashCode() ?: 0)
        result = 31 * result + (outputEncryptionKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartCallAnalyticsJobRequest

        if (callAnalyticsJobName != other.callAnalyticsJobName) return false
        if (channelDefinitions != other.channelDefinitions) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (media != other.media) return false
        if (outputEncryptionKmsKeyId != other.outputEncryptionKmsKeyId) return false
        if (outputLocation != other.outputLocation) return false
        if (settings != other.settings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.StartCallAnalyticsJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique name, chosen by you, for your Call Analytics job.
         *
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new job with the same name as an existing job, you get a `ConflictException` error.
         */
        public var callAnalyticsJobName: kotlin.String? = null
        /**
         * Makes it possible to specify which speaker is on which channel. For example, if your agent is the first participant to speak, you would set `ChannelId` to `0` (to indicate the first channel) and `ParticipantRole` to `AGENT` (to indicate that it's the agent speaking).
         */
        public var channelDefinitions: List<ChannelDefinition>? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.
         *
         * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`.
         *
         * For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * Describes the Amazon S3 location of the media file you want to use in your Call Analytics request.
         */
        public var media: aws.sdk.kotlin.services.transcribe.model.Media? = null
        /**
         * The KMS key you want to use to encrypt your Call Analytics output.
         *
         * If using a key located in the **current** Amazon Web Services account, you can specify your KMS key in one of four ways:
         * + Use the KMS key ID itself. For example, `1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Use an alias for the KMS key ID. For example, `alias/ExampleAlias`.
         * + Use the Amazon Resource Name (ARN) for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
         *
         * If using a key located in a **different** Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:
         * + Use the ARN for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
         *
         * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
         *
         * If you specify a KMS key to encrypt your output, you must also specify an output location using the `OutputLocation` parameter.
         *
         * Note that the role making the request must have permission to use the specified KMS key.
         */
        public var outputEncryptionKmsKeyId: kotlin.String? = null
        /**
         * The Amazon S3 location where you want your Call Analytics transcription output stored. You can use any of the following formats to specify the output location:
         * + s3://DOC-EXAMPLE-BUCKET
         * + s3://DOC-EXAMPLE-BUCKET/my-output-folder/
         * + s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
         *
         * Unless you specify a file name (option 3), the name of your output file has a default value that matches the name you specified for your transcription job using the `CallAnalyticsJobName` parameter.
         *
         * You can specify a KMS key to encrypt your output using the `OutputEncryptionKMSKeyId` parameter. If you do not specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption.
         *
         * If you do not specify `OutputLocation`, your transcript is placed in a service-managed Amazon S3 bucket and you are provided with a URI to access your transcript.
         */
        public var outputLocation: kotlin.String? = null
        /**
         * Specify additional optional settings in your request, including content redaction; allows you to apply custom language models, vocabulary filters, and custom vocabularies to your Call Analytics job.
         */
        public var settings: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.StartCallAnalyticsJobRequest) : this() {
            this.callAnalyticsJobName = x.callAnalyticsJobName
            this.channelDefinitions = x.channelDefinitions
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.media = x.media
            this.outputEncryptionKmsKeyId = x.outputEncryptionKmsKeyId
            this.outputLocation = x.outputLocation
            this.settings = x.settings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.StartCallAnalyticsJobRequest = StartCallAnalyticsJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.Media] inside the given [block]
         */
        public fun media(block: aws.sdk.kotlin.services.transcribe.model.Media.Builder.() -> kotlin.Unit) {
            this.media = aws.sdk.kotlin.services.transcribe.model.Media.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
