// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the Amazon S3 location of the media file you want to use in your request.
 *
 * For information on supported media formats, refer to the `MediaFormat` parameter or the [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio) section in the Amazon S3 Developer Guide.
 */
public class Media private constructor(builder: Builder) {
    /**
     * The Amazon S3 location of the media file you want to transcribe. For example:
     * + `s3://DOC-EXAMPLE-BUCKET/my-media-file.flac`
     * + `s3://DOC-EXAMPLE-BUCKET/media-files/my-media-file.flac`
     *
     * Note that the Amazon S3 bucket that contains your input media must be located in the same Amazon Web Services Region where you're making your transcription request.
     */
    public val mediaFileUri: kotlin.String? = builder.mediaFileUri
    /**
     * The Amazon S3 location of the media file you want to redact. For example:
     * + `s3://DOC-EXAMPLE-BUCKET/my-media-file.flac`
     * + `s3://DOC-EXAMPLE-BUCKET/media-files/my-media-file.flac`
     *
     * Note that the Amazon S3 bucket that contains your input media must be located in the same Amazon Web Services Region where you're making your transcription request.
     *
     * `RedactedMediaFileUri` produces a redacted audio file in addition to a redacted transcript. It is only supported for Call Analytics (`StartCallAnalyticsJob`) transcription requests.
     */
    public val redactedMediaFileUri: kotlin.String? = builder.redactedMediaFileUri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.Media = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Media(")
        append("mediaFileUri=$mediaFileUri,")
        append("redactedMediaFileUri=$redactedMediaFileUri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mediaFileUri?.hashCode() ?: 0
        result = 31 * result + (redactedMediaFileUri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Media

        if (mediaFileUri != other.mediaFileUri) return false
        if (redactedMediaFileUri != other.redactedMediaFileUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.Media = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 location of the media file you want to transcribe. For example:
         * + `s3://DOC-EXAMPLE-BUCKET/my-media-file.flac`
         * + `s3://DOC-EXAMPLE-BUCKET/media-files/my-media-file.flac`
         *
         * Note that the Amazon S3 bucket that contains your input media must be located in the same Amazon Web Services Region where you're making your transcription request.
         */
        public var mediaFileUri: kotlin.String? = null
        /**
         * The Amazon S3 location of the media file you want to redact. For example:
         * + `s3://DOC-EXAMPLE-BUCKET/my-media-file.flac`
         * + `s3://DOC-EXAMPLE-BUCKET/media-files/my-media-file.flac`
         *
         * Note that the Amazon S3 bucket that contains your input media must be located in the same Amazon Web Services Region where you're making your transcription request.
         *
         * `RedactedMediaFileUri` produces a redacted audio file in addition to a redacted transcript. It is only supported for Call Analytics (`StartCallAnalyticsJob`) transcription requests.
         */
        public var redactedMediaFileUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.Media) : this() {
            this.mediaFileUri = x.mediaFileUri
            this.redactedMediaFileUri = x.redactedMediaFileUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.Media = Media(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
