// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListMedicalTranscriptionJobsRequest private constructor(builder: Builder) {
    /**
     * Returns only the medical transcription jobs that contain the specified string. The search is not case sensitive.
     */
    public val jobNameContains: kotlin.String? = builder.jobNameContains
    /**
     * The maximum number of medical transcription jobs to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If your `ListMedicalTranscriptionJobs` request returns more results than can be displayed, `NextToken` is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including `NextToken` with the value of the copied string. Repeat as needed to view all your results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Returns only medical transcription jobs with the specified status. Jobs are ordered by creation date, with the newest job first. If you do not include `Status`, all medical transcription jobs are returned.
     */
    public val status: aws.sdk.kotlin.services.transcribe.model.TranscriptionJobStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListMedicalTranscriptionJobsRequest(")
        append("jobNameContains=$jobNameContains,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobNameContains?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListMedicalTranscriptionJobsRequest

        if (jobNameContains != other.jobNameContains) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Returns only the medical transcription jobs that contain the specified string. The search is not case sensitive.
         */
        public var jobNameContains: kotlin.String? = null
        /**
         * The maximum number of medical transcription jobs to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If your `ListMedicalTranscriptionJobs` request returns more results than can be displayed, `NextToken` is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including `NextToken` with the value of the copied string. Repeat as needed to view all your results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Returns only medical transcription jobs with the specified status. Jobs are ordered by creation date, with the newest job first. If you do not include `Status`, all medical transcription jobs are returned.
         */
        public var status: aws.sdk.kotlin.services.transcribe.model.TranscriptionJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsRequest) : this() {
            this.jobNameContains = x.jobNameContains
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsRequest = ListMedicalTranscriptionJobsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
