// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateLanguageModelRequest private constructor(builder: Builder) {
    /**
     * The Amazon Transcribe standard language model, or base model, used to create your custom language model. Amazon Transcribe offers two options for base models: Wideband and Narrowband.
     *
     * If the audio you want to transcribe has a sample rate of 16,000 Hz or greater, choose `WideBand`. To transcribe audio with a sample rate less than 16,000 Hz, choose `NarrowBand`.
     */
    public val baseModelName: aws.sdk.kotlin.services.transcribe.model.BaseModelName? = builder.baseModelName
    /**
     * Contains the Amazon S3 location of the training data you want to use to create a new custom language model, and permissions to access this location.
     *
     * When using `InputDataConfig`, you must include these sub-parameters: `S3Uri`, which is the Amazon S3 location of your training data, and `DataAccessRoleArn`, which is the Amazon Resource Name (ARN) of the role that has permission to access your specified Amazon S3 location. You can optionally include `TuningDataS3Uri`, which is the Amazon S3 location of your tuning data. If you specify different Amazon S3 locations for training and tuning data, the ARN you use must have permissions to access both locations.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.transcribe.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The language code that represents the language of your model. Each custom language model must contain terms in only one language, and the language you select for your custom language model must match the language of your training and tuning data.
     *
     * For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table. Note that US English (`en-US`) is the only language supported with Amazon Transcribe Medical.
     *
     * A custom language model can only be used to transcribe files in the same language as the model. For example, if you create a custom language model using US English (`en-US`), you can only apply this model to files that contain English audio.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.ClmLanguageCode? = builder.languageCode
    /**
     * A unique name, chosen by you, for your custom language model.
     *
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new custom language model with the same name as an existing custom language model, you get a `ConflictException` error.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to a new custom language model at the time you create this new model.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.CreateLanguageModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLanguageModelRequest(")
        append("baseModelName=$baseModelName,")
        append("inputDataConfig=$inputDataConfig,")
        append("languageCode=$languageCode,")
        append("modelName=$modelName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseModelName?.hashCode() ?: 0
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLanguageModelRequest

        if (baseModelName != other.baseModelName) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (languageCode != other.languageCode) return false
        if (modelName != other.modelName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.CreateLanguageModelRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Transcribe standard language model, or base model, used to create your custom language model. Amazon Transcribe offers two options for base models: Wideband and Narrowband.
         *
         * If the audio you want to transcribe has a sample rate of 16,000 Hz or greater, choose `WideBand`. To transcribe audio with a sample rate less than 16,000 Hz, choose `NarrowBand`.
         */
        public var baseModelName: aws.sdk.kotlin.services.transcribe.model.BaseModelName? = null
        /**
         * Contains the Amazon S3 location of the training data you want to use to create a new custom language model, and permissions to access this location.
         *
         * When using `InputDataConfig`, you must include these sub-parameters: `S3Uri`, which is the Amazon S3 location of your training data, and `DataAccessRoleArn`, which is the Amazon Resource Name (ARN) of the role that has permission to access your specified Amazon S3 location. You can optionally include `TuningDataS3Uri`, which is the Amazon S3 location of your tuning data. If you specify different Amazon S3 locations for training and tuning data, the ARN you use must have permissions to access both locations.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.transcribe.model.InputDataConfig? = null
        /**
         * The language code that represents the language of your model. Each custom language model must contain terms in only one language, and the language you select for your custom language model must match the language of your training and tuning data.
         *
         * For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table. Note that US English (`en-US`) is the only language supported with Amazon Transcribe Medical.
         *
         * A custom language model can only be used to transcribe files in the same language as the model. For example, if you create a custom language model using US English (`en-US`), you can only apply this model to files that contain English audio.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.ClmLanguageCode? = null
        /**
         * A unique name, chosen by you, for your custom language model.
         *
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new custom language model with the same name as an existing custom language model, you get a `ConflictException` error.
         */
        public var modelName: kotlin.String? = null
        /**
         * Adds one or more custom tags, each in the form of a key:value pair, to a new custom language model at the time you create this new model.
         *
         * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.CreateLanguageModelRequest) : this() {
            this.baseModelName = x.baseModelName
            this.inputDataConfig = x.inputDataConfig
            this.languageCode = x.languageCode
            this.modelName = x.modelName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.CreateLanguageModelRequest = CreateLanguageModelRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.transcribe.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.transcribe.model.InputDataConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
