// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.serde

import aws.sdk.kotlin.services.transcribe.model.ContentRedaction
import aws.sdk.kotlin.services.transcribe.model.JobExecutionSettings
import aws.sdk.kotlin.services.transcribe.model.LanguageCode
import aws.sdk.kotlin.services.transcribe.model.LanguageIdSettings
import aws.sdk.kotlin.services.transcribe.model.Media
import aws.sdk.kotlin.services.transcribe.model.MediaFormat
import aws.sdk.kotlin.services.transcribe.model.ModelSettings
import aws.sdk.kotlin.services.transcribe.model.Settings
import aws.sdk.kotlin.services.transcribe.model.StartTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.Subtitles
import aws.sdk.kotlin.services.transcribe.model.Tag
import aws.sdk.kotlin.services.transcribe.model.ToxicityDetectionSettings
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartTranscriptionJobOperationSerializer: HttpSerialize<StartTranscriptionJobRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartTranscriptionJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeStartTranscriptionJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeStartTranscriptionJobOperationBody(context: ExecutionContext, input: StartTranscriptionJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTENTREDACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ContentRedaction"))
    val IDENTIFYLANGUAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IdentifyLanguage"))
    val IDENTIFYMULTIPLELANGUAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IdentifyMultipleLanguages"))
    val JOBEXECUTIONSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("JobExecutionSettings"))
    val KMSENCRYPTIONCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("KMSEncryptionContext"))
    val LANGUAGECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("LanguageCode"))
    val LANGUAGEIDSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("LanguageIdSettings"))
    val LANGUAGEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LanguageOptions"))
    val MEDIA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Media"))
    val MEDIAFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MediaFormat"))
    val MEDIASAMPLERATEHERTZ_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MediaSampleRateHertz"))
    val MODELSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ModelSettings"))
    val OUTPUTBUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputBucketName"))
    val OUTPUTENCRYPTIONKMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputEncryptionKMSKeyId"))
    val OUTPUTKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputKey"))
    val SETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Settings"))
    val SUBTITLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Subtitles"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TOXICITYDETECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ToxicityDetection"))
    val TRANSCRIPTIONJOBNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TranscriptionJobName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTREDACTION_DESCRIPTOR)
        field(IDENTIFYLANGUAGE_DESCRIPTOR)
        field(IDENTIFYMULTIPLELANGUAGES_DESCRIPTOR)
        field(JOBEXECUTIONSETTINGS_DESCRIPTOR)
        field(KMSENCRYPTIONCONTEXT_DESCRIPTOR)
        field(LANGUAGECODE_DESCRIPTOR)
        field(LANGUAGEIDSETTINGS_DESCRIPTOR)
        field(LANGUAGEOPTIONS_DESCRIPTOR)
        field(MEDIA_DESCRIPTOR)
        field(MEDIAFORMAT_DESCRIPTOR)
        field(MEDIASAMPLERATEHERTZ_DESCRIPTOR)
        field(MODELSETTINGS_DESCRIPTOR)
        field(OUTPUTBUCKETNAME_DESCRIPTOR)
        field(OUTPUTENCRYPTIONKMSKEYID_DESCRIPTOR)
        field(OUTPUTKEY_DESCRIPTOR)
        field(SETTINGS_DESCRIPTOR)
        field(SUBTITLES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TOXICITYDETECTION_DESCRIPTOR)
        field(TRANSCRIPTIONJOBNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.contentRedaction?.let { field(CONTENTREDACTION_DESCRIPTOR, it, ::serializeContentRedactionDocument) }
        input.identifyLanguage?.let { field(IDENTIFYLANGUAGE_DESCRIPTOR, it) }
        input.identifyMultipleLanguages?.let { field(IDENTIFYMULTIPLELANGUAGES_DESCRIPTOR, it) }
        input.jobExecutionSettings?.let { field(JOBEXECUTIONSETTINGS_DESCRIPTOR, it, ::serializeJobExecutionSettingsDocument) }
        if (input.kmsEncryptionContext != null) {
            mapField(KMSENCRYPTIONCONTEXT_DESCRIPTOR) {
                input.kmsEncryptionContext.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.languageCode?.let { field(LANGUAGECODE_DESCRIPTOR, it.value) }
        if (input.languageIdSettings != null) {
            mapField(LANGUAGEIDSETTINGS_DESCRIPTOR) {
                input.languageIdSettings.forEach { (key, value) -> entry(key.value, asSdkSerializable(value, ::serializeLanguageIdSettingsDocument)) }
            }
        }
        if (input.languageOptions != null) {
            listField(LANGUAGEOPTIONS_DESCRIPTOR) {
                for (el0 in input.languageOptions) {
                    serializeString(el0.value)
                }
            }
        }
        input.media?.let { field(MEDIA_DESCRIPTOR, it, ::serializeMediaDocument) }
        input.mediaFormat?.let { field(MEDIAFORMAT_DESCRIPTOR, it.value) }
        input.mediaSampleRateHertz?.let { field(MEDIASAMPLERATEHERTZ_DESCRIPTOR, it) }
        input.modelSettings?.let { field(MODELSETTINGS_DESCRIPTOR, it, ::serializeModelSettingsDocument) }
        input.outputBucketName?.let { field(OUTPUTBUCKETNAME_DESCRIPTOR, it) }
        input.outputEncryptionKmsKeyId?.let { field(OUTPUTENCRYPTIONKMSKEYID_DESCRIPTOR, it) }
        input.outputKey?.let { field(OUTPUTKEY_DESCRIPTOR, it) }
        input.settings?.let { field(SETTINGS_DESCRIPTOR, it, ::serializeSettingsDocument) }
        input.subtitles?.let { field(SUBTITLES_DESCRIPTOR, it, ::serializeSubtitlesDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        if (input.toxicityDetection != null) {
            listField(TOXICITYDETECTION_DESCRIPTOR) {
                for (el0 in input.toxicityDetection) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeToxicityDetectionSettingsDocument))
                }
            }
        }
        input.transcriptionJobName?.let { field(TRANSCRIPTIONJOBNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
