// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.serde

import aws.sdk.kotlin.services.transcribe.model.BaseModelName
import aws.sdk.kotlin.services.transcribe.model.ClmLanguageCode
import aws.sdk.kotlin.services.transcribe.model.CreateLanguageModelResponse
import aws.sdk.kotlin.services.transcribe.model.InputDataConfig
import aws.sdk.kotlin.services.transcribe.model.ModelStatus
import aws.sdk.kotlin.services.transcribe.model.TranscribeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateLanguageModelOperationDeserializer: HttpDeserialize<CreateLanguageModelResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateLanguageModelResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateLanguageModelError(context, call)
        }
        val builder = CreateLanguageModelResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateLanguageModelOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateLanguageModelError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> TranscribeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateLanguageModelOperationBody(builder: CreateLanguageModelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASEMODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("BaseModelName"))
    val INPUTDATACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputDataConfig"))
    val LANGUAGECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("LanguageCode"))
    val MODELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModelName"))
    val MODELSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ModelStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASEMODELNAME_DESCRIPTOR)
        field(INPUTDATACONFIG_DESCRIPTOR)
        field(LANGUAGECODE_DESCRIPTOR)
        field(MODELNAME_DESCRIPTOR)
        field(MODELSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASEMODELNAME_DESCRIPTOR.index -> builder.baseModelName = deserializeString().let { BaseModelName.fromValue(it) }
                INPUTDATACONFIG_DESCRIPTOR.index -> builder.inputDataConfig = deserializeInputDataConfigDocument(deserializer)
                LANGUAGECODE_DESCRIPTOR.index -> builder.languageCode = deserializeString().let { ClmLanguageCode.fromValue(it) }
                MODELNAME_DESCRIPTOR.index -> builder.modelName = deserializeString()
                MODELSTATUS_DESCRIPTOR.index -> builder.modelStatus = deserializeString().let { ModelStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
