// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a custom vocabulary, including the language of the custom vocabulary, when it was last modified, its name, and the processing state.
 */
public class VocabularyInfo private constructor(builder: Builder) {
    /**
     * The language code used to create your custom vocabulary. Each custom vocabulary must contain terms in only one language.
     *
     * A custom vocabulary can only be used to transcribe files in the same language as the custom vocabulary. For example, if you create a custom vocabulary using US English (`en-US`), you can only apply this custom vocabulary to files that contain English audio.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * The date and time the specified custom vocabulary was last modified.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * A unique name, chosen by you, for your custom vocabulary. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName
    /**
     * The processing state of your custom vocabulary. If the state is `READY`, you can use the custom vocabulary in a `StartTranscriptionJob` request.
     */
    public val vocabularyState: aws.sdk.kotlin.services.transcribe.model.VocabularyState? = builder.vocabularyState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.VocabularyInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VocabularyInfo(")
        append("languageCode=$languageCode,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("vocabularyName=$vocabularyName,")
        append("vocabularyState=$vocabularyState")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageCode?.hashCode() ?: 0
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VocabularyInfo

        if (languageCode != other.languageCode) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (vocabularyName != other.vocabularyName) return false
        if (vocabularyState != other.vocabularyState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.VocabularyInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The language code used to create your custom vocabulary. Each custom vocabulary must contain terms in only one language.
         *
         * A custom vocabulary can only be used to transcribe files in the same language as the custom vocabulary. For example, if you create a custom vocabulary using US English (`en-US`), you can only apply this custom vocabulary to files that contain English audio.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * The date and time the specified custom vocabulary was last modified.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique name, chosen by you, for your custom vocabulary. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         */
        public var vocabularyName: kotlin.String? = null
        /**
         * The processing state of your custom vocabulary. If the state is `READY`, you can use the custom vocabulary in a `StartTranscriptionJob` request.
         */
        public var vocabularyState: aws.sdk.kotlin.services.transcribe.model.VocabularyState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.VocabularyInfo) : this() {
            this.languageCode = x.languageCode
            this.lastModifiedTime = x.lastModifiedTime
            this.vocabularyName = x.vocabularyName
            this.vocabularyState = x.vocabularyState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.VocabularyInfo = VocabularyInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
