// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



public class StartMedicalTranscriptionJobRequest private constructor(builder: Builder) {
    /**
     * Labels all personal health information (PHI) identified in your transcript. For more information, see [Identifying personal health information (PHI) in a transcription](https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html).
     */
    public val contentIdentificationType: aws.sdk.kotlin.services.transcribe.model.MedicalContentIdentificationType? = builder.contentIdentificationType
    /**
     * A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see [KMS encryption context](https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context) and [Asymmetric keys in KMS](https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html).
     */
    public val kmsEncryptionContext: Map<String, String>? = builder.kmsEncryptionContext
    /**
     * The language code that represents the language spoken in the input media file. US English (`en-US`) is the only valid value for medical transcription jobs. Any other value you enter for language code results in a `BadRequestException` error.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * Describes the Amazon S3 location of the media file you want to use in your request.
     *
     * For information on supported media formats, refer to the `MediaFormat` parameter or the [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio) section in the Amazon S3 Developer Guide.
     */
    public val media: aws.sdk.kotlin.services.transcribe.model.Media? = builder.media
    /**
     * Specify the format of your input media file.
     */
    public val mediaFormat: aws.sdk.kotlin.services.transcribe.model.MediaFormat? = builder.mediaFormat
    /**
     * The sample rate, in hertz, of the audio track in your input media file.
     *
     * If you do not specify the media sample rate, Amazon Transcribe Medical determines it for you. If you specify the sample rate, it must match the rate detected by Amazon Transcribe Medical; if there's a mismatch between the value that you specify and the value detected, your job fails. Therefore, in most cases, it's advised to omit `MediaSampleRateHertz` and let Amazon Transcribe Medical determine the sample rate.
     */
    public val mediaSampleRateHertz: kotlin.Int? = builder.mediaSampleRateHertz
    /**
     * A unique name, chosen by you, for your medical transcription job. The name that you specify is also used as the default name of your transcription output file. If you want to specify a different name for your transcription output, use the `OutputKey` parameter.
     *
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new job with the same name as an existing job, you get a `ConflictException` error.
     */
    public val medicalTranscriptionJobName: kotlin.String? = builder.medicalTranscriptionJobName
    /**
     * The name of the Amazon S3 bucket where you want your medical transcription output stored. Do not include the `S3://` prefix of the specified bucket.
     *
     * If you want your output to go to a sub-folder of this bucket, specify it using the `OutputKey` parameter; `OutputBucketName` only accepts the name of a bucket.
     *
     * For example, if you want your output stored in `S3://DOC-EXAMPLE-BUCKET`, set `OutputBucketName` to `DOC-EXAMPLE-BUCKET`. However, if you want your output stored in `S3://DOC-EXAMPLE-BUCKET/test-files/`, set `OutputBucketName` to `DOC-EXAMPLE-BUCKET` and `OutputKey` to `test-files/`.
     *
     * Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon S3 permissions using the [Amazon Web Services Management Console](https://console.aws.amazon.com/s3). See also [Permissions Required for IAM User Roles](https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
     */
    public val outputBucketName: kotlin.String? = builder.outputBucketName
    /**
     * The KMS key you want to use to encrypt your medical transcription output.
     *
     * If using a key located in the **current** Amazon Web Services account, you can specify your KMS key in one of four ways:
     * + Use the KMS key ID itself. For example, `1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Use an alias for the KMS key ID. For example, `alias/ExampleAlias`.
     * + Use the Amazon Resource Name (ARN) for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
     *
     * If using a key located in a **different** Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:
     * + Use the ARN for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
     *
     * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
     *
     * If you specify a KMS key to encrypt your output, you must also specify an output location using the `OutputLocation` parameter.
     *
     * Note that the role making the request must have permission to use the specified KMS key.
     */
    public val outputEncryptionKmsKeyId: kotlin.String? = builder.outputEncryptionKmsKeyId
    /**
     * Use in combination with `OutputBucketName` to specify the output location of your transcript and, optionally, a unique name for your output file. The default name for your transcription output is the same as the name you specified for your medical transcription job (`MedicalTranscriptionJobName`).
     *
     * Here are some examples of how you can use `OutputKey`:
     * + If you specify 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName` and 'my-transcript.json' as the `OutputKey`, your transcription output path is `s3://DOC-EXAMPLE-BUCKET/my-transcript.json`.
     * + If you specify 'my-first-transcription' as the `MedicalTranscriptionJobName`, 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName`, and 'my-transcript' as the `OutputKey`, your transcription output path is `s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json`.
     * + If you specify 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName` and 'test-files/my-transcript.json' as the `OutputKey`, your transcription output path is `s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json`.
     * + If you specify 'my-first-transcription' as the `MedicalTranscriptionJobName`, 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName`, and 'test-files/my-transcript' as the `OutputKey`, your transcription output path is `s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json`.
     *
     * If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist, one is created for you.
     */
    public val outputKey: kotlin.String? = builder.outputKey
    /**
     * Specify additional optional settings in your request, including channel identification, alternative transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your transcription job.
     */
    public val settings: aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting? = builder.settings
    /**
     * Specify the predominant medical specialty represented in your media. For batch transcriptions, `PRIMARYCARE` is the only valid value. If you require additional specialties, refer to .
     */
    public val specialty: aws.sdk.kotlin.services.transcribe.model.Specialty? = builder.specialty
    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to a new medical transcription job at the time you start this new job.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specify whether your input media contains only one person (`DICTATION`) or contains a conversation between two people (`CONVERSATION`).
     *
     * For example, `DICTATION` could be used for a medical professional wanting to transcribe voice memos; `CONVERSATION` could be used for transcribing the doctor-patient dialogue during the patient's office visit.
     */
    public val type: aws.sdk.kotlin.services.transcribe.model.Type? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartMedicalTranscriptionJobRequest(")
        append("contentIdentificationType=$contentIdentificationType,")
        append("kmsEncryptionContext=$kmsEncryptionContext,")
        append("languageCode=$languageCode,")
        append("media=$media,")
        append("mediaFormat=$mediaFormat,")
        append("mediaSampleRateHertz=$mediaSampleRateHertz,")
        append("medicalTranscriptionJobName=$medicalTranscriptionJobName,")
        append("outputBucketName=$outputBucketName,")
        append("outputEncryptionKmsKeyId=$outputEncryptionKmsKeyId,")
        append("outputKey=$outputKey,")
        append("settings=$settings,")
        append("specialty=$specialty,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentIdentificationType?.hashCode() ?: 0
        result = 31 * result + (kmsEncryptionContext?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (media?.hashCode() ?: 0)
        result = 31 * result + (mediaFormat?.hashCode() ?: 0)
        result = 31 * result + (mediaSampleRateHertz ?: 0)
        result = 31 * result + (medicalTranscriptionJobName?.hashCode() ?: 0)
        result = 31 * result + (outputBucketName?.hashCode() ?: 0)
        result = 31 * result + (outputEncryptionKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputKey?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (specialty?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartMedicalTranscriptionJobRequest

        if (contentIdentificationType != other.contentIdentificationType) return false
        if (kmsEncryptionContext != other.kmsEncryptionContext) return false
        if (languageCode != other.languageCode) return false
        if (media != other.media) return false
        if (mediaFormat != other.mediaFormat) return false
        if (mediaSampleRateHertz != other.mediaSampleRateHertz) return false
        if (medicalTranscriptionJobName != other.medicalTranscriptionJobName) return false
        if (outputBucketName != other.outputBucketName) return false
        if (outputEncryptionKmsKeyId != other.outputEncryptionKmsKeyId) return false
        if (outputKey != other.outputKey) return false
        if (settings != other.settings) return false
        if (specialty != other.specialty) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Labels all personal health information (PHI) identified in your transcript. For more information, see [Identifying personal health information (PHI) in a transcription](https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html).
         */
        public var contentIdentificationType: aws.sdk.kotlin.services.transcribe.model.MedicalContentIdentificationType? = null
        /**
         * A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see [KMS encryption context](https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context) and [Asymmetric keys in KMS](https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html).
         */
        public var kmsEncryptionContext: Map<String, String>? = null
        /**
         * The language code that represents the language spoken in the input media file. US English (`en-US`) is the only valid value for medical transcription jobs. Any other value you enter for language code results in a `BadRequestException` error.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * Describes the Amazon S3 location of the media file you want to use in your request.
         *
         * For information on supported media formats, refer to the `MediaFormat` parameter or the [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio) section in the Amazon S3 Developer Guide.
         */
        public var media: aws.sdk.kotlin.services.transcribe.model.Media? = null
        /**
         * Specify the format of your input media file.
         */
        public var mediaFormat: aws.sdk.kotlin.services.transcribe.model.MediaFormat? = null
        /**
         * The sample rate, in hertz, of the audio track in your input media file.
         *
         * If you do not specify the media sample rate, Amazon Transcribe Medical determines it for you. If you specify the sample rate, it must match the rate detected by Amazon Transcribe Medical; if there's a mismatch between the value that you specify and the value detected, your job fails. Therefore, in most cases, it's advised to omit `MediaSampleRateHertz` and let Amazon Transcribe Medical determine the sample rate.
         */
        public var mediaSampleRateHertz: kotlin.Int? = null
        /**
         * A unique name, chosen by you, for your medical transcription job. The name that you specify is also used as the default name of your transcription output file. If you want to specify a different name for your transcription output, use the `OutputKey` parameter.
         *
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new job with the same name as an existing job, you get a `ConflictException` error.
         */
        public var medicalTranscriptionJobName: kotlin.String? = null
        /**
         * The name of the Amazon S3 bucket where you want your medical transcription output stored. Do not include the `S3://` prefix of the specified bucket.
         *
         * If you want your output to go to a sub-folder of this bucket, specify it using the `OutputKey` parameter; `OutputBucketName` only accepts the name of a bucket.
         *
         * For example, if you want your output stored in `S3://DOC-EXAMPLE-BUCKET`, set `OutputBucketName` to `DOC-EXAMPLE-BUCKET`. However, if you want your output stored in `S3://DOC-EXAMPLE-BUCKET/test-files/`, set `OutputBucketName` to `DOC-EXAMPLE-BUCKET` and `OutputKey` to `test-files/`.
         *
         * Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon S3 permissions using the [Amazon Web Services Management Console](https://console.aws.amazon.com/s3). See also [Permissions Required for IAM User Roles](https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
         */
        public var outputBucketName: kotlin.String? = null
        /**
         * The KMS key you want to use to encrypt your medical transcription output.
         *
         * If using a key located in the **current** Amazon Web Services account, you can specify your KMS key in one of four ways:
         * + Use the KMS key ID itself. For example, `1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Use an alias for the KMS key ID. For example, `alias/ExampleAlias`.
         * + Use the Amazon Resource Name (ARN) for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
         *
         * If using a key located in a **different** Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:
         * + Use the ARN for the KMS key ID. For example, `arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Use the ARN for the KMS key alias. For example, `arn:aws:kms:region:account-ID:alias/ExampleAlias`.
         *
         * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
         *
         * If you specify a KMS key to encrypt your output, you must also specify an output location using the `OutputLocation` parameter.
         *
         * Note that the role making the request must have permission to use the specified KMS key.
         */
        public var outputEncryptionKmsKeyId: kotlin.String? = null
        /**
         * Use in combination with `OutputBucketName` to specify the output location of your transcript and, optionally, a unique name for your output file. The default name for your transcription output is the same as the name you specified for your medical transcription job (`MedicalTranscriptionJobName`).
         *
         * Here are some examples of how you can use `OutputKey`:
         * + If you specify 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName` and 'my-transcript.json' as the `OutputKey`, your transcription output path is `s3://DOC-EXAMPLE-BUCKET/my-transcript.json`.
         * + If you specify 'my-first-transcription' as the `MedicalTranscriptionJobName`, 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName`, and 'my-transcript' as the `OutputKey`, your transcription output path is `s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json`.
         * + If you specify 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName` and 'test-files/my-transcript.json' as the `OutputKey`, your transcription output path is `s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json`.
         * + If you specify 'my-first-transcription' as the `MedicalTranscriptionJobName`, 'DOC-EXAMPLE-BUCKET' as the `OutputBucketName`, and 'test-files/my-transcript' as the `OutputKey`, your transcription output path is `s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json`.
         *
         * If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist, one is created for you.
         */
        public var outputKey: kotlin.String? = null
        /**
         * Specify additional optional settings in your request, including channel identification, alternative transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your transcription job.
         */
        public var settings: aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting? = null
        /**
         * Specify the predominant medical specialty represented in your media. For batch transcriptions, `PRIMARYCARE` is the only valid value. If you require additional specialties, refer to .
         */
        public var specialty: aws.sdk.kotlin.services.transcribe.model.Specialty? = null
        /**
         * Adds one or more custom tags, each in the form of a key:value pair, to a new medical transcription job at the time you start this new job.
         *
         * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
         */
        public var tags: List<Tag>? = null
        /**
         * Specify whether your input media contains only one person (`DICTATION`) or contains a conversation between two people (`CONVERSATION`).
         *
         * For example, `DICTATION` could be used for a medical professional wanting to transcribe voice memos; `CONVERSATION` could be used for transcribing the doctor-patient dialogue during the patient's office visit.
         */
        public var type: aws.sdk.kotlin.services.transcribe.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobRequest) : this() {
            this.contentIdentificationType = x.contentIdentificationType
            this.kmsEncryptionContext = x.kmsEncryptionContext
            this.languageCode = x.languageCode
            this.media = x.media
            this.mediaFormat = x.mediaFormat
            this.mediaSampleRateHertz = x.mediaSampleRateHertz
            this.medicalTranscriptionJobName = x.medicalTranscriptionJobName
            this.outputBucketName = x.outputBucketName
            this.outputEncryptionKmsKeyId = x.outputEncryptionKmsKeyId
            this.outputKey = x.outputKey
            this.settings = x.settings
            this.specialty = x.specialty
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobRequest = StartMedicalTranscriptionJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.Media] inside the given [block]
         */
        public fun media(block: aws.sdk.kotlin.services.transcribe.model.Media.Builder.() -> kotlin.Unit) {
            this.media = aws.sdk.kotlin.services.transcribe.model.Media.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
