// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Contains the Amazon S3 location of the training data you want to use to create a new custom language model, and permissions to access this location.
 *
 * When using `InputDataConfig`, you must include these sub-parameters: `S3Uri` and `DataAccessRoleArn`. You can optionally include `TuningDataS3Uri`.
 */
public class InputDataConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.
     *
     * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`.
     *
     * For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
     */
    public val dataAccessRoleArn: kotlin.String = requireNotNull(builder.dataAccessRoleArn) { "A non-null value must be provided for dataAccessRoleArn" }
    /**
     * The Amazon S3 location (URI) of the text files you want to use to train your custom language model.
     *
     * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-model-training-data/`
     */
    public val s3Uri: kotlin.String = requireNotNull(builder.s3Uri) { "A non-null value must be provided for s3Uri" }
    /**
     * The Amazon S3 location (URI) of the text files you want to use to tune your custom language model.
     *
     * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-model-tuning-data/`
     */
    public val tuningDataS3Uri: kotlin.String? = builder.tuningDataS3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.InputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputDataConfig(")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("s3Uri=$s3Uri,")
        append("tuningDataS3Uri=$tuningDataS3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataAccessRoleArn.hashCode()
        result = 31 * result + (s3Uri.hashCode())
        result = 31 * result + (tuningDataS3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputDataConfig

        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (s3Uri != other.s3Uri) return false
        if (tuningDataS3Uri != other.tuningDataS3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.InputDataConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.
         *
         * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`.
         *
         * For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The Amazon S3 location (URI) of the text files you want to use to train your custom language model.
         *
         * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-model-training-data/`
         */
        public var s3Uri: kotlin.String? = null
        /**
         * The Amazon S3 location (URI) of the text files you want to use to tune your custom language model.
         *
         * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-model-tuning-data/`
         */
        public var tuningDataS3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.InputDataConfig) : this() {
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.s3Uri = x.s3Uri
            this.tuningDataS3Uri = x.tuningDataS3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.InputDataConfig = InputDataConfig(this)

        internal fun correctErrors(): Builder {
            if (dataAccessRoleArn == null) dataAccessRoleArn = ""
            if (s3Uri == null) s3Uri = ""
            return this
        }
    }
}
