// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Makes it possible to redact or flag specified personally identifiable information (PII) in your transcript. If you use `ContentRedaction`, you must also include the sub-parameters: `RedactionOutput` and `RedactionType`. You can optionally include `PiiEntityTypes` to choose which types of PII you want to redact.
 */
public class ContentRedaction private constructor(builder: Builder) {
    /**
     * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select `ALL`. If you do not include `PiiEntityTypes` in your request, all PII is redacted.
     */
    public val piiEntityTypes: List<PiiEntityType>? = builder.piiEntityTypes
    /**
     * Specify if you want only a redacted transcript, or if you want a redacted and an unredacted transcript.
     *
     * When you choose `redacted` Amazon Transcribe creates only a redacted transcript.
     *
     * When you choose `redacted_and_unredacted` Amazon Transcribe creates a redacted and an unredacted transcript (as two separate files).
     */
    public val redactionOutput: aws.sdk.kotlin.services.transcribe.model.RedactionOutput = requireNotNull(builder.redactionOutput) { "A non-null value must be provided for redactionOutput" }
    /**
     * Specify the category of information you want to redact; `PII` (personally identifiable information) is the only valid value. You can use `PiiEntityTypes` to choose which types of PII you want to redact. If you do not include `PiiEntityTypes` in your request, all PII is redacted.
     */
    public val redactionType: aws.sdk.kotlin.services.transcribe.model.RedactionType = requireNotNull(builder.redactionType) { "A non-null value must be provided for redactionType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.ContentRedaction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContentRedaction(")
        append("piiEntityTypes=$piiEntityTypes,")
        append("redactionOutput=$redactionOutput,")
        append("redactionType=$redactionType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = piiEntityTypes?.hashCode() ?: 0
        result = 31 * result + (redactionOutput.hashCode())
        result = 31 * result + (redactionType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContentRedaction

        if (piiEntityTypes != other.piiEntityTypes) return false
        if (redactionOutput != other.redactionOutput) return false
        if (redactionType != other.redactionType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.ContentRedaction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select `ALL`. If you do not include `PiiEntityTypes` in your request, all PII is redacted.
         */
        public var piiEntityTypes: List<PiiEntityType>? = null
        /**
         * Specify if you want only a redacted transcript, or if you want a redacted and an unredacted transcript.
         *
         * When you choose `redacted` Amazon Transcribe creates only a redacted transcript.
         *
         * When you choose `redacted_and_unredacted` Amazon Transcribe creates a redacted and an unredacted transcript (as two separate files).
         */
        public var redactionOutput: aws.sdk.kotlin.services.transcribe.model.RedactionOutput? = null
        /**
         * Specify the category of information you want to redact; `PII` (personally identifiable information) is the only valid value. You can use `PiiEntityTypes` to choose which types of PII you want to redact. If you do not include `PiiEntityTypes` in your request, all PII is redacted.
         */
        public var redactionType: aws.sdk.kotlin.services.transcribe.model.RedactionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.ContentRedaction) : this() {
            this.piiEntityTypes = x.piiEntityTypes
            this.redactionOutput = x.redactionOutput
            this.redactionType = x.redactionType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.ContentRedaction = ContentRedaction(this)

        internal fun correctErrors(): Builder {
            if (redactionOutput == null) redactionOutput = RedactionOutput.SdkUnknown("no value provided")
            if (redactionType == null) redactionType = RedactionType.SdkUnknown("no value provided")
            return this
        }
    }
}
