// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides detailed information about a specific Call Analytics job.
 */
public class CallAnalyticsJobSummary private constructor(builder: Builder) {
    /**
     * The name of the Call Analytics job. Job names are case sensitive and must be unique within an Amazon Web Services account.
     */
    public val callAnalyticsJobName: kotlin.String? = builder.callAnalyticsJobName
    /**
     * Provides the status of your Call Analytics job.
     *
     * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri` (or `RedactedTranscriptFileUri`, if you requested transcript redaction). If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     */
    public val callAnalyticsJobStatus: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobStatus? = builder.callAnalyticsJobStatus
    /**
     * The date and time the specified Call Analytics job finished processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:33:13.922000-07:00` represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * The date and time the specified Call Analytics job request was made.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * If `CallAnalyticsJobStatus` is `FAILED`, `FailureReason` contains information about why the Call Analytics job failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The language code used to create your Call Analytics transcription.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * The date and time your Call Analytics job began processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CallAnalyticsJobSummary(")
        append("callAnalyticsJobName=$callAnalyticsJobName,")
        append("callAnalyticsJobStatus=$callAnalyticsJobStatus,")
        append("completionTime=$completionTime,")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("languageCode=$languageCode,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callAnalyticsJobName?.hashCode() ?: 0
        result = 31 * result + (callAnalyticsJobStatus?.hashCode() ?: 0)
        result = 31 * result + (completionTime?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CallAnalyticsJobSummary

        if (callAnalyticsJobName != other.callAnalyticsJobName) return false
        if (callAnalyticsJobStatus != other.callAnalyticsJobStatus) return false
        if (completionTime != other.completionTime) return false
        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (languageCode != other.languageCode) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Call Analytics job. Job names are case sensitive and must be unique within an Amazon Web Services account.
         */
        public var callAnalyticsJobName: kotlin.String? = null
        /**
         * Provides the status of your Call Analytics job.
         *
         * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri` (or `RedactedTranscriptFileUri`, if you requested transcript redaction). If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
         */
        public var callAnalyticsJobStatus: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobStatus? = null
        /**
         * The date and time the specified Call Analytics job finished processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:33:13.922000-07:00` represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time the specified Call Analytics job request was made.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If `CallAnalyticsJobStatus` is `FAILED`, `FailureReason` contains information about why the Call Analytics job failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The language code used to create your Call Analytics transcription.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * The date and time your Call Analytics job began processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSummary) : this() {
            this.callAnalyticsJobName = x.callAnalyticsJobName
            this.callAnalyticsJobStatus = x.callAnalyticsJobStatus
            this.completionTime = x.completionTime
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.languageCode = x.languageCode
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSummary = CallAnalyticsJobSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
