// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides detailed information about a Medical Scribe job.
 *
 * To view the status of the specified Medical Scribe job, check the `MedicalScribeJobStatus` field. If the status is `COMPLETED`, the job is finished and you can find the results at the locations specified in `MedicalScribeOutput`. If the status is `FAILED`, `FailureReason` provides details on why your Medical Scribe job failed.
 */
public class MedicalScribeJob private constructor(builder: Builder) {
    /**
     * Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first participant to speak, you would set `ChannelId` of the first `ChannelDefinition` in the list to `0` (to indicate the first channel) and `ParticipantRole` to `CLINICIAN` (to indicate that it's the clinician speaking). Then you would set the `ChannelId` of the second `ChannelDefinition` in the list to `1` (to indicate the second channel) and `ParticipantRole` to `PATIENT` (to indicate that it's the patient speaking).
     */
    public val channelDefinitions: List<MedicalScribeChannelDefinition>? = builder.channelDefinitions
    /**
     * The date and time the specified Medical Scribe job finished processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a Medical Scribe job that finished processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * The date and time the specified Medical Scribe job request was made.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files, write to the output bucket, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions your request fails.
     *
     * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`.
     *
     * For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * If `MedicalScribeJobStatus` is `FAILED`, `FailureReason` contains information about why the transcription job failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The language code used to create your Medical Scribe job. US English (`en-US`) is the only supported language for Medical Scribe jobs.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.MedicalScribeLanguageCode? = builder.languageCode
    /**
     * Describes the Amazon S3 location of the media file you want to use in your request.
     *
     * For information on supported media formats, refer to the `MediaFormat` parameter or the [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio) section in the Amazon S3 Developer Guide.
     */
    public val media: aws.sdk.kotlin.services.transcribe.model.Media? = builder.media
    /**
     * The name of the Medical Scribe job. Job names are case sensitive and must be unique within an Amazon Web Services account.
     */
    public val medicalScribeJobName: kotlin.String? = builder.medicalScribeJobName
    /**
     * Provides the status of the specified Medical Scribe job.
     *
     * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `MedicalScribeOutput` If the status is `FAILED`, `FailureReason` provides details on why your Medical Scribe job failed.
     */
    public val medicalScribeJobStatus: aws.sdk.kotlin.services.transcribe.model.MedicalScribeJobStatus? = builder.medicalScribeJobStatus
    /**
     * The location of the output of your Medical Scribe job. `ClinicalDocumentUri` holds the Amazon S3 URI for the Clinical Document and `TranscriptFileUri` holds the Amazon S3 URI for the Transcript.
     */
    public val medicalScribeOutput: aws.sdk.kotlin.services.transcribe.model.MedicalScribeOutput? = builder.medicalScribeOutput
    /**
     * Makes it possible to control how your Medical Scribe job is processed using a `MedicalScribeSettings` object. Specify `ChannelIdentification` if `ChannelDefinitions` are set. Enabled `ShowSpeakerLabels` if `ChannelIdentification` and `ChannelDefinitions` are not set. One and only one of `ChannelIdentification` and `ShowSpeakerLabels` must be set. If `ShowSpeakerLabels` is set, `MaxSpeakerLabels` must also be set. Use `Settings` to specify a vocabulary or vocabulary filter or both using `VocabularyName`, `VocabularyFilterName`. `VocabularyFilterMethod` must be specified if `VocabularyFilterName` is set.
     */
    public val settings: aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings? = builder.settings
    /**
     * The date and time your Medical Scribe job began processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.MedicalScribeJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MedicalScribeJob(")
        append("channelDefinitions=$channelDefinitions,")
        append("completionTime=$completionTime,")
        append("creationTime=$creationTime,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("failureReason=$failureReason,")
        append("languageCode=$languageCode,")
        append("media=$media,")
        append("medicalScribeJobName=$medicalScribeJobName,")
        append("medicalScribeJobStatus=$medicalScribeJobStatus,")
        append("medicalScribeOutput=$medicalScribeOutput,")
        append("settings=$settings,")
        append("startTime=$startTime,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelDefinitions?.hashCode() ?: 0
        result = 31 * result + (completionTime?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (media?.hashCode() ?: 0)
        result = 31 * result + (medicalScribeJobName?.hashCode() ?: 0)
        result = 31 * result + (medicalScribeJobStatus?.hashCode() ?: 0)
        result = 31 * result + (medicalScribeOutput?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MedicalScribeJob

        if (channelDefinitions != other.channelDefinitions) return false
        if (completionTime != other.completionTime) return false
        if (creationTime != other.creationTime) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (failureReason != other.failureReason) return false
        if (languageCode != other.languageCode) return false
        if (media != other.media) return false
        if (medicalScribeJobName != other.medicalScribeJobName) return false
        if (medicalScribeJobStatus != other.medicalScribeJobStatus) return false
        if (medicalScribeOutput != other.medicalScribeOutput) return false
        if (settings != other.settings) return false
        if (startTime != other.startTime) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.MedicalScribeJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first participant to speak, you would set `ChannelId` of the first `ChannelDefinition` in the list to `0` (to indicate the first channel) and `ParticipantRole` to `CLINICIAN` (to indicate that it's the clinician speaking). Then you would set the `ChannelId` of the second `ChannelDefinition` in the list to `1` (to indicate the second channel) and `ParticipantRole` to `PATIENT` (to indicate that it's the patient speaking).
         */
        public var channelDefinitions: List<MedicalScribeChannelDefinition>? = null
        /**
         * The date and time the specified Medical Scribe job finished processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a Medical Scribe job that finished processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time the specified Medical Scribe job request was made.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files, write to the output bucket, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions your request fails.
         *
         * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`.
         *
         * For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * If `MedicalScribeJobStatus` is `FAILED`, `FailureReason` contains information about why the transcription job failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The language code used to create your Medical Scribe job. US English (`en-US`) is the only supported language for Medical Scribe jobs.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.MedicalScribeLanguageCode? = null
        /**
         * Describes the Amazon S3 location of the media file you want to use in your request.
         *
         * For information on supported media formats, refer to the `MediaFormat` parameter or the [Media formats](https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio) section in the Amazon S3 Developer Guide.
         */
        public var media: aws.sdk.kotlin.services.transcribe.model.Media? = null
        /**
         * The name of the Medical Scribe job. Job names are case sensitive and must be unique within an Amazon Web Services account.
         */
        public var medicalScribeJobName: kotlin.String? = null
        /**
         * Provides the status of the specified Medical Scribe job.
         *
         * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `MedicalScribeOutput` If the status is `FAILED`, `FailureReason` provides details on why your Medical Scribe job failed.
         */
        public var medicalScribeJobStatus: aws.sdk.kotlin.services.transcribe.model.MedicalScribeJobStatus? = null
        /**
         * The location of the output of your Medical Scribe job. `ClinicalDocumentUri` holds the Amazon S3 URI for the Clinical Document and `TranscriptFileUri` holds the Amazon S3 URI for the Transcript.
         */
        public var medicalScribeOutput: aws.sdk.kotlin.services.transcribe.model.MedicalScribeOutput? = null
        /**
         * Makes it possible to control how your Medical Scribe job is processed using a `MedicalScribeSettings` object. Specify `ChannelIdentification` if `ChannelDefinitions` are set. Enabled `ShowSpeakerLabels` if `ChannelIdentification` and `ChannelDefinitions` are not set. One and only one of `ChannelIdentification` and `ShowSpeakerLabels` must be set. If `ShowSpeakerLabels` is set, `MaxSpeakerLabels` must also be set. Use `Settings` to specify a vocabulary or vocabulary filter or both using `VocabularyName`, `VocabularyFilterName`. `VocabularyFilterMethod` must be specified if `VocabularyFilterName` is set.
         */
        public var settings: aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings? = null
        /**
         * The date and time your Medical Scribe job began processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.
         *
         * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.MedicalScribeJob) : this() {
            this.channelDefinitions = x.channelDefinitions
            this.completionTime = x.completionTime
            this.creationTime = x.creationTime
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.failureReason = x.failureReason
            this.languageCode = x.languageCode
            this.media = x.media
            this.medicalScribeJobName = x.medicalScribeJobName
            this.medicalScribeJobStatus = x.medicalScribeJobStatus
            this.medicalScribeOutput = x.medicalScribeOutput
            this.settings = x.settings
            this.startTime = x.startTime
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.MedicalScribeJob = MedicalScribeJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.Media] inside the given [block]
         */
        public fun media(block: aws.sdk.kotlin.services.transcribe.model.Media.Builder.() -> kotlin.Unit) {
            this.media = aws.sdk.kotlin.services.transcribe.model.Media.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.MedicalScribeOutput] inside the given [block]
         */
        public fun medicalScribeOutput(block: aws.sdk.kotlin.services.transcribe.model.MedicalScribeOutput.Builder.() -> kotlin.Unit) {
            this.medicalScribeOutput = aws.sdk.kotlin.services.transcribe.model.MedicalScribeOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.transcribe.model.MedicalScribeSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
