// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



public class ListMedicalScribeJobsRequest private constructor(builder: Builder) {
    /**
     * Returns only the Medical Scribe jobs that contain the specified string. The search is not case sensitive.
     */
    public val jobNameContains: kotlin.String? = builder.jobNameContains
    /**
     * The maximum number of Medical Scribe jobs to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If your `ListMedicalScribeJobs` request returns more results than can be displayed, `NextToken` is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including `NextToken` with the value of the copied string. Repeat as needed to view all your results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Returns only Medical Scribe jobs with the specified status. Jobs are ordered by creation date, with the newest job first. If you do not include `Status`, all Medical Scribe jobs are returned.
     */
    public val status: aws.sdk.kotlin.services.transcribe.model.MedicalScribeJobStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.ListMedicalScribeJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListMedicalScribeJobsRequest(")
        append("jobNameContains=$jobNameContains,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobNameContains?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListMedicalScribeJobsRequest

        if (jobNameContains != other.jobNameContains) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.ListMedicalScribeJobsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Returns only the Medical Scribe jobs that contain the specified string. The search is not case sensitive.
         */
        public var jobNameContains: kotlin.String? = null
        /**
         * The maximum number of Medical Scribe jobs to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If your `ListMedicalScribeJobs` request returns more results than can be displayed, `NextToken` is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including `NextToken` with the value of the copied string. Repeat as needed to view all your results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Returns only Medical Scribe jobs with the specified status. Jobs are ordered by creation date, with the newest job first. If you do not include `Status`, all Medical Scribe jobs are returned.
         */
        public var status: aws.sdk.kotlin.services.transcribe.model.MedicalScribeJobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.ListMedicalScribeJobsRequest) : this() {
            this.jobNameContains = x.jobNameContains
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.ListMedicalScribeJobsRequest = ListMedicalScribeJobsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
