// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Provides additional optional settings for your request, including content redaction, automatic language identification; allows you to apply custom language models, custom vocabulary filters, and custom vocabularies.
 */
public class CallAnalyticsJobSettings private constructor(builder: Builder) {
    /**
     * Makes it possible to redact or flag specified personally identifiable information (PII) in your transcript. If you use `ContentRedaction`, you must also include the sub-parameters: `RedactionOutput` and `RedactionType`. You can optionally include `PiiEntityTypes` to choose which types of PII you want to redact.
     */
    public val contentRedaction: aws.sdk.kotlin.services.transcribe.model.ContentRedaction? = builder.contentRedaction
    /**
     * If using automatic language identification in your request and you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter, include `LanguageIdSettings` with the relevant sub-parameters (`VocabularyName`, `LanguageModelName`, and `VocabularyFilterName`).
     *
     * `LanguageIdSettings` supports two to five language codes. Each language code you include can have an associated custom language model, custom vocabulary, and custom vocabulary filter. The language codes that you specify must match the languages of the associated custom language models, custom vocabularies, and custom vocabulary filters.
     *
     * It's recommended that you include `LanguageOptions` when using `LanguageIdSettings` to ensure that the correct language dialect is identified. For example, if you specify a custom vocabulary that is in `en-US` but Amazon Transcribe determines that the language spoken in your media is `en-AU`, your custom vocabulary *is not* applied to your transcription. If you include `LanguageOptions` and include `en-US` as the only English language dialect, your custom vocabulary *is* applied to your transcription.
     *
     * If you want to include a custom language model, custom vocabulary, or custom vocabulary filter with your request but **do not** want to use automatic language identification, use instead the `` parameter with the `LanguageModelName`, `VocabularyName`, or `VocabularyFilterName` sub-parameters.
     *
     * For a list of languages supported with Call Analytics, refer to [Supported languages and language-specific features](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html).
     */
    public val languageIdSettings: Map<String, LanguageIdSettings>? = builder.languageIdSettings
    /**
     * The name of the custom language model you want to use when processing your Call Analytics job. Note that custom language model names are case sensitive.
     *
     * The language of the specified custom language model must match the language code that you specify in your transcription request. If the languages do not match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.
     */
    public val languageModelName: kotlin.String? = builder.languageModelName
    /**
     * You can specify two or more language codes that represent the languages you think may be present in your media. Including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
     *
     * Including language options can improve the accuracy of language identification.
     *
     * For a list of languages supported with Call Analytics, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
     *
     * To transcribe speech in Modern Standard Arabic (`ar-SA`), your media file must be encoded at a sample rate of 16,000 Hz or higher.
     */
    public val languageOptions: List<LanguageCode>? = builder.languageOptions
    /**
     * Contains `GenerateAbstractiveSummary`, which is a required parameter if you want to enable Generative call summarization in your Call Analytics request.
     */
    public val summarization: aws.sdk.kotlin.services.transcribe.model.Summarization? = builder.summarization
    /**
     * Specify how you want your custom vocabulary filter applied to your transcript.
     *
     * To replace words with `***`, choose `mask`.
     *
     * To delete words, choose `remove`.
     *
     * To flag words without changing them, choose `tag`.
     */
    public val vocabularyFilterMethod: aws.sdk.kotlin.services.transcribe.model.VocabularyFilterMethod? = builder.vocabularyFilterMethod
    /**
     * The name of the custom vocabulary filter you want to include in your Call Analytics transcription request. Custom vocabulary filter names are case sensitive.
     *
     * Note that if you include `VocabularyFilterName` in your request, you must also include `VocabularyFilterMethod`.
     */
    public val vocabularyFilterName: kotlin.String? = builder.vocabularyFilterName
    /**
     * The name of the custom vocabulary you want to include in your Call Analytics transcription request. Custom vocabulary names are case sensitive.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CallAnalyticsJobSettings(")
        append("contentRedaction=$contentRedaction,")
        append("languageIdSettings=$languageIdSettings,")
        append("languageModelName=$languageModelName,")
        append("languageOptions=$languageOptions,")
        append("summarization=$summarization,")
        append("vocabularyFilterMethod=$vocabularyFilterMethod,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("vocabularyName=$vocabularyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentRedaction?.hashCode() ?: 0
        result = 31 * result + (languageIdSettings?.hashCode() ?: 0)
        result = 31 * result + (languageModelName?.hashCode() ?: 0)
        result = 31 * result + (languageOptions?.hashCode() ?: 0)
        result = 31 * result + (summarization?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterMethod?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CallAnalyticsJobSettings

        if (contentRedaction != other.contentRedaction) return false
        if (languageIdSettings != other.languageIdSettings) return false
        if (languageModelName != other.languageModelName) return false
        if (languageOptions != other.languageOptions) return false
        if (summarization != other.summarization) return false
        if (vocabularyFilterMethod != other.vocabularyFilterMethod) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Makes it possible to redact or flag specified personally identifiable information (PII) in your transcript. If you use `ContentRedaction`, you must also include the sub-parameters: `RedactionOutput` and `RedactionType`. You can optionally include `PiiEntityTypes` to choose which types of PII you want to redact.
         */
        public var contentRedaction: aws.sdk.kotlin.services.transcribe.model.ContentRedaction? = null
        /**
         * If using automatic language identification in your request and you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter, include `LanguageIdSettings` with the relevant sub-parameters (`VocabularyName`, `LanguageModelName`, and `VocabularyFilterName`).
         *
         * `LanguageIdSettings` supports two to five language codes. Each language code you include can have an associated custom language model, custom vocabulary, and custom vocabulary filter. The language codes that you specify must match the languages of the associated custom language models, custom vocabularies, and custom vocabulary filters.
         *
         * It's recommended that you include `LanguageOptions` when using `LanguageIdSettings` to ensure that the correct language dialect is identified. For example, if you specify a custom vocabulary that is in `en-US` but Amazon Transcribe determines that the language spoken in your media is `en-AU`, your custom vocabulary *is not* applied to your transcription. If you include `LanguageOptions` and include `en-US` as the only English language dialect, your custom vocabulary *is* applied to your transcription.
         *
         * If you want to include a custom language model, custom vocabulary, or custom vocabulary filter with your request but **do not** want to use automatic language identification, use instead the `` parameter with the `LanguageModelName`, `VocabularyName`, or `VocabularyFilterName` sub-parameters.
         *
         * For a list of languages supported with Call Analytics, refer to [Supported languages and language-specific features](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html).
         */
        public var languageIdSettings: Map<String, LanguageIdSettings>? = null
        /**
         * The name of the custom language model you want to use when processing your Call Analytics job. Note that custom language model names are case sensitive.
         *
         * The language of the specified custom language model must match the language code that you specify in your transcription request. If the languages do not match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.
         */
        public var languageModelName: kotlin.String? = null
        /**
         * You can specify two or more language codes that represent the languages you think may be present in your media. Including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
         *
         * Including language options can improve the accuracy of language identification.
         *
         * For a list of languages supported with Call Analytics, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
         *
         * To transcribe speech in Modern Standard Arabic (`ar-SA`), your media file must be encoded at a sample rate of 16,000 Hz or higher.
         */
        public var languageOptions: List<LanguageCode>? = null
        /**
         * Contains `GenerateAbstractiveSummary`, which is a required parameter if you want to enable Generative call summarization in your Call Analytics request.
         */
        public var summarization: aws.sdk.kotlin.services.transcribe.model.Summarization? = null
        /**
         * Specify how you want your custom vocabulary filter applied to your transcript.
         *
         * To replace words with `***`, choose `mask`.
         *
         * To delete words, choose `remove`.
         *
         * To flag words without changing them, choose `tag`.
         */
        public var vocabularyFilterMethod: aws.sdk.kotlin.services.transcribe.model.VocabularyFilterMethod? = null
        /**
         * The name of the custom vocabulary filter you want to include in your Call Analytics transcription request. Custom vocabulary filter names are case sensitive.
         *
         * Note that if you include `VocabularyFilterName` in your request, you must also include `VocabularyFilterMethod`.
         */
        public var vocabularyFilterName: kotlin.String? = null
        /**
         * The name of the custom vocabulary you want to include in your Call Analytics transcription request. Custom vocabulary names are case sensitive.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings) : this() {
            this.contentRedaction = x.contentRedaction
            this.languageIdSettings = x.languageIdSettings
            this.languageModelName = x.languageModelName
            this.languageOptions = x.languageOptions
            this.summarization = x.summarization
            this.vocabularyFilterMethod = x.vocabularyFilterMethod
            this.vocabularyFilterName = x.vocabularyFilterName
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings = CallAnalyticsJobSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.ContentRedaction] inside the given [block]
         */
        public fun contentRedaction(block: aws.sdk.kotlin.services.transcribe.model.ContentRedaction.Builder.() -> kotlin.Unit) {
            this.contentRedaction = aws.sdk.kotlin.services.transcribe.model.ContentRedaction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.Summarization] inside the given [block]
         */
        public fun summarization(block: aws.sdk.kotlin.services.transcribe.model.Summarization.Builder.() -> kotlin.Unit) {
            this.summarization = aws.sdk.kotlin.services.transcribe.model.Summarization.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
