// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.transcribe.auth.DefaultTranscribeAuthSchemeProvider
import aws.sdk.kotlin.services.transcribe.auth.TranscribeAuthSchemeProvider
import aws.sdk.kotlin.services.transcribe.endpoints.DefaultTranscribeEndpointProvider
import aws.sdk.kotlin.services.transcribe.endpoints.TranscribeEndpointParameters
import aws.sdk.kotlin.services.transcribe.endpoints.TranscribeEndpointProvider
import aws.sdk.kotlin.services.transcribe.model.CreateCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.CreateCallAnalyticsCategoryResponse
import aws.sdk.kotlin.services.transcribe.model.CreateLanguageModelRequest
import aws.sdk.kotlin.services.transcribe.model.CreateLanguageModelResponse
import aws.sdk.kotlin.services.transcribe.model.CreateMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.CreateMedicalVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyFilterResponse
import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteCallAnalyticsCategoryResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteCallAnalyticsJobRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteCallAnalyticsJobResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteLanguageModelRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteLanguageModelResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalScribeJobRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalScribeJobResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteVocabularyFilterResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.DescribeLanguageModelRequest
import aws.sdk.kotlin.services.transcribe.model.DescribeLanguageModelResponse
import aws.sdk.kotlin.services.transcribe.model.GetCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.GetCallAnalyticsCategoryResponse
import aws.sdk.kotlin.services.transcribe.model.GetCallAnalyticsJobRequest
import aws.sdk.kotlin.services.transcribe.model.GetCallAnalyticsJobResponse
import aws.sdk.kotlin.services.transcribe.model.GetMedicalScribeJobRequest
import aws.sdk.kotlin.services.transcribe.model.GetMedicalScribeJobResponse
import aws.sdk.kotlin.services.transcribe.model.GetMedicalTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.GetMedicalTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.GetMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.GetMedicalVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.GetTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.GetTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.GetVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.GetVocabularyFilterResponse
import aws.sdk.kotlin.services.transcribe.model.GetVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.GetVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsCategoriesRequest
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsCategoriesResponse
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListLanguageModelsRequest
import aws.sdk.kotlin.services.transcribe.model.ListLanguageModelsResponse
import aws.sdk.kotlin.services.transcribe.model.ListMedicalScribeJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListMedicalScribeJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListMedicalVocabulariesRequest
import aws.sdk.kotlin.services.transcribe.model.ListMedicalVocabulariesResponse
import aws.sdk.kotlin.services.transcribe.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.transcribe.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.transcribe.model.ListTranscriptionJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListTranscriptionJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListVocabulariesRequest
import aws.sdk.kotlin.services.transcribe.model.ListVocabulariesResponse
import aws.sdk.kotlin.services.transcribe.model.ListVocabularyFiltersRequest
import aws.sdk.kotlin.services.transcribe.model.ListVocabularyFiltersResponse
import aws.sdk.kotlin.services.transcribe.model.StartCallAnalyticsJobRequest
import aws.sdk.kotlin.services.transcribe.model.StartCallAnalyticsJobResponse
import aws.sdk.kotlin.services.transcribe.model.StartMedicalScribeJobRequest
import aws.sdk.kotlin.services.transcribe.model.StartMedicalScribeJobResponse
import aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.StartTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.StartTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.TagResourceRequest
import aws.sdk.kotlin.services.transcribe.model.TagResourceResponse
import aws.sdk.kotlin.services.transcribe.model.UntagResourceRequest
import aws.sdk.kotlin.services.transcribe.model.UntagResourceResponse
import aws.sdk.kotlin.services.transcribe.model.UpdateCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateCallAnalyticsCategoryResponse
import aws.sdk.kotlin.services.transcribe.model.UpdateMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateMedicalVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyFilterResponse
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Transcribe"
public const val SdkVersion: String = "1.0.66"
public const val ServiceApiVersion: String = "2017-10-26"

/**
 * Amazon Transcribe offers three main types of batch transcription: **Standard**, **Medical**, and **Call Analytics**.
 * + **Standard transcriptions** are the most common option. Refer to for details.
 * + **Medical transcriptions** are tailored to medical professionals and incorporate medical terms. A common use case for this service is transcribing doctor-patient dialogue into after-visit notes. Refer to for details.
 * + **Call Analytics transcriptions** are designed for use with call center audio on two different channels; if you're looking for insight into customer service calls, use this option. Refer to for details.
 */
public interface TranscribeClient : SdkClient {
    /**
     * TranscribeClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, TranscribeClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Transcribe",
                "TRANSCRIBE",
                "transcribe",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, TranscribeClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): TranscribeClient = DefaultTranscribeClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: TranscribeEndpointProvider = builder.endpointProvider ?: DefaultTranscribeEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: TranscribeAuthSchemeProvider = builder.authSchemeProvider ?: DefaultTranscribeAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Transcribe"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: TranscribeEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: TranscribeAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new Call Analytics category.
     *
     * All categories are automatically applied to your Call Analytics transcriptions. Note that in order to apply categories to your transcriptions, you must create them before submitting your transcription request, as categories cannot be applied retroactively.
     *
     * When creating a new category, you can use the `InputType` parameter to label the category as a `POST_CALL` or a `REAL_TIME` category. `POST_CALL` categories can only be applied to post-call transcriptions and `REAL_TIME` categories can only be applied to real-time transcriptions. If you do not include `InputType`, your category is created as a `POST_CALL` category by default.
     *
     * Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules can include these parameters: , , , and .
     *
     * To update an existing category, see .
     *
     * To learn more about Call Analytics categories, see [Creating categories for post-call transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html) and [Creating categories for real-time transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html).
     */
    public suspend fun createCallAnalyticsCategory(input: CreateCallAnalyticsCategoryRequest): CreateCallAnalyticsCategoryResponse

    /**
     * Creates a new custom language model.
     *
     * When creating a new custom language model, you must specify:
     * + If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz) base model
     * + The location of your training and tuning files (this must be an Amazon S3 URI)
     * + The language of your model
     * + A unique name for your model
     */
    public suspend fun createLanguageModel(input: CreateLanguageModelRequest): CreateLanguageModelResponse

    /**
     * Creates a new custom medical vocabulary.
     *
     * Before creating a new custom medical vocabulary, you must first upload a text file that contains your vocabulary table into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your request using the `Phrases` flag; `CreateMedicalVocabulary` does not support the `Phrases` flag and only accepts vocabularies in table format.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
     */
    public suspend fun createMedicalVocabulary(input: CreateMedicalVocabularyRequest): CreateMedicalVocabularyResponse

    /**
     * Creates a new custom vocabulary.
     *
     * When creating a new custom vocabulary, you can either upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket and include the URI in your request. Or you can include a list of terms directly in your request using the `Phrases` flag.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
     */
    public suspend fun createVocabulary(input: CreateVocabularyRequest): CreateVocabularyResponse

    /**
     * Creates a new custom vocabulary filter.
     *
     * You can use custom vocabulary filters to mask, delete, or flag specific words from your transcript. Custom vocabulary filters are commonly used to mask profanity in transcripts.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Vocabulary filtering](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
     */
    public suspend fun createVocabularyFilter(input: CreateVocabularyFilterRequest): CreateVocabularyFilterResponse

    /**
     * Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete using `CategoryName`. Category names are case sensitive.
     */
    public suspend fun deleteCallAnalyticsCategory(input: DeleteCallAnalyticsCategoryRequest): DeleteCallAnalyticsCategoryResponse

    /**
     * Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using `CallAnalyticsJobName`. Job names are case sensitive.
     */
    public suspend fun deleteCallAnalyticsJob(input: DeleteCallAnalyticsJobRequest): DeleteCallAnalyticsJobResponse

    /**
     * Deletes a custom language model. To use this operation, specify the name of the language model you want to delete using `ModelName`. custom language model names are case sensitive.
     */
    public suspend fun deleteLanguageModel(input: DeleteLanguageModelRequest): DeleteLanguageModelResponse

    /**
     * Deletes a Medical Scribe job. To use this operation, specify the name of the job you want to delete using `MedicalScribeJobName`. Job names are case sensitive.
     */
    public suspend fun deleteMedicalScribeJob(input: DeleteMedicalScribeJobRequest): DeleteMedicalScribeJobResponse

    /**
     * Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using `MedicalTranscriptionJobName`. Job names are case sensitive.
     */
    public suspend fun deleteMedicalTranscriptionJob(input: DeleteMedicalTranscriptionJobRequest): DeleteMedicalTranscriptionJobResponse

    /**
     * Deletes a custom medical vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete using `VocabularyName`. Custom vocabulary names are case sensitive.
     */
    public suspend fun deleteMedicalVocabulary(input: DeleteMedicalVocabularyRequest): DeleteMedicalVocabularyResponse

    /**
     * Deletes a transcription job. To use this operation, specify the name of the job you want to delete using `TranscriptionJobName`. Job names are case sensitive.
     */
    public suspend fun deleteTranscriptionJob(input: DeleteTranscriptionJobRequest): DeleteTranscriptionJobResponse

    /**
     * Deletes a custom vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete using `VocabularyName`. Custom vocabulary names are case sensitive.
     */
    public suspend fun deleteVocabulary(input: DeleteVocabularyRequest): DeleteVocabularyResponse

    /**
     * Deletes a custom vocabulary filter. To use this operation, specify the name of the custom vocabulary filter you want to delete using `VocabularyFilterName`. Custom vocabulary filter names are case sensitive.
     */
    public suspend fun deleteVocabularyFilter(input: DeleteVocabularyFilterRequest): DeleteVocabularyFilterResponse

    /**
     * Provides information about the specified custom language model.
     *
     * This operation also shows if the base language model that you used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model.
     *
     * If you tried to create a new custom language model and the request wasn't successful, you can use `DescribeLanguageModel` to help identify the reason for this failure.
     */
    public suspend fun describeLanguageModel(input: DescribeLanguageModelRequest): DescribeLanguageModelResponse

    /**
     * Provides information about the specified Call Analytics category.
     *
     * To get a list of your Call Analytics categories, use the operation.
     */
    public suspend fun getCallAnalyticsCategory(input: GetCallAnalyticsCategoryRequest): GetCallAnalyticsCategoryResponse

    /**
     * Provides information about the specified Call Analytics job.
     *
     * To view the job's status, refer to `CallAnalyticsJobStatus`. If the status is `COMPLETED`, the job is finished. You can find your completed transcript at the URI specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the location specified in `RedactedTranscriptFileUri`.
     *
     * If you chose to redact the audio in your media file, you can find your redacted media file at the location specified in `RedactedMediaFileUri`.
     *
     * To get a list of your Call Analytics jobs, use the operation.
     */
    public suspend fun getCallAnalyticsJob(input: GetCallAnalyticsJobRequest): GetCallAnalyticsJobResponse

    /**
     * Provides information about the specified Medical Scribe job.
     *
     * To view the status of the specified medical transcription job, check the `MedicalScribeJobStatus` field. If the status is `COMPLETED`, the job is finished. You can find the results at the location specified in `MedicalScribeOutput`. If the status is `FAILED`, `FailureReason` provides details on why your Medical Scribe job failed.
     *
     * To get a list of your Medical Scribe jobs, use the operation.
     */
    public suspend fun getMedicalScribeJob(input: GetMedicalScribeJobRequest): GetMedicalScribeJobResponse

    /**
     * Provides information about the specified medical transcription job.
     *
     * To view the status of the specified medical transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished. You can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * To get a list of your medical transcription jobs, use the operation.
     */
    public suspend fun getMedicalTranscriptionJob(input: GetMedicalTranscriptionJobRequest): GetMedicalTranscriptionJobResponse

    /**
     * Provides information about the specified custom medical vocabulary.
     *
     * To view the status of the specified custom medical vocabulary, check the `VocabularyState` field. If the status is `READY`, your custom vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary failed.
     *
     * To get a list of your custom medical vocabularies, use the operation.
     */
    public suspend fun getMedicalVocabulary(input: GetMedicalVocabularyRequest): GetMedicalVocabularyResponse

    /**
     * Provides information about the specified transcription job.
     *
     * To view the status of the specified transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished. You can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * If you enabled content redaction, the redacted transcript can be found at the location specified in `RedactedTranscriptFileUri`.
     *
     * To get a list of your transcription jobs, use the operation.
     */
    public suspend fun getTranscriptionJob(input: GetTranscriptionJobRequest): GetTranscriptionJobResponse

    /**
     * Provides information about the specified custom vocabulary.
     *
     * To view the status of the specified custom vocabulary, check the `VocabularyState` field. If the status is `READY`, your custom vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your custom vocabulary failed.
     *
     * To get a list of your custom vocabularies, use the operation.
     */
    public suspend fun getVocabulary(input: GetVocabularyRequest): GetVocabularyResponse

    /**
     * Provides information about the specified custom vocabulary filter.
     *
     * To get a list of your custom vocabulary filters, use the operation.
     */
    public suspend fun getVocabularyFilter(input: GetVocabularyFilterRequest): GetVocabularyFilterResponse

    /**
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     *
     * To get detailed information about a specific Call Analytics category, use the operation.
     */
    public suspend fun listCallAnalyticsCategories(input: ListCallAnalyticsCategoriesRequest = ListCallAnalyticsCategoriesRequest { }): ListCallAnalyticsCategoriesResponse

    /**
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call Analytics jobs are returned.
     *
     * To get detailed information about a specific Call Analytics job, use the operation.
     */
    public suspend fun listCallAnalyticsJobs(input: ListCallAnalyticsJobsRequest = ListCallAnalyticsJobsRequest { }): ListCallAnalyticsJobsResponse

    /**
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all custom language models are returned.
     *
     * To get detailed information about a specific custom language model, use the operation.
     */
    public suspend fun listLanguageModels(input: ListLanguageModelsRequest = ListLanguageModelsRequest { }): ListLanguageModelsResponse

    /**
     * Provides a list of Medical Scribe jobs that match the specified criteria. If no criteria are specified, all Medical Scribe jobs are returned.
     *
     * To get detailed information about a specific Medical Scribe job, use the operation.
     */
    public suspend fun listMedicalScribeJobs(input: ListMedicalScribeJobsRequest = ListMedicalScribeJobsRequest { }): ListMedicalScribeJobsResponse

    /**
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified, all medical transcription jobs are returned.
     *
     * To get detailed information about a specific medical transcription job, use the operation.
     */
    public suspend fun listMedicalTranscriptionJobs(input: ListMedicalTranscriptionJobsRequest = ListMedicalTranscriptionJobsRequest { }): ListMedicalTranscriptionJobsResponse

    /**
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified, all custom medical vocabularies are returned.
     *
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     */
    public suspend fun listMedicalVocabularies(input: ListMedicalVocabulariesRequest = ListMedicalVocabulariesRequest { }): ListMedicalVocabulariesResponse

    /**
     * Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all transcription jobs are returned.
     *
     * To get detailed information about a specific transcription job, use the operation.
     */
    public suspend fun listTranscriptionJobs(input: ListTranscriptionJobsRequest = ListTranscriptionJobsRequest { }): ListTranscriptionJobsResponse

    /**
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
     *
     * To get detailed information about a specific custom vocabulary, use the operation.
     */
    public suspend fun listVocabularies(input: ListVocabulariesRequest = ListVocabulariesRequest { }): ListVocabulariesResponse

    /**
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
     *
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     */
    public suspend fun listVocabularyFilters(input: ListVocabularyFiltersRequest = ListVocabularyFiltersRequest { }): ListVocabularyFiltersResponse

    /**
     * Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to include in your request.
     *
     * In addition to many standard transcription features, Call Analytics provides you with call characteristics, call summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can also apply custom categories to flag specified conditions. To learn more about these features and insights, refer to [Analyzing call center audio with Call Analytics](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html).
     *
     * If you want to apply categories to your Call Analytics job, you must create them before submitting your job request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To learn more about Call Analytics categories, see [Creating categories for post-call transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html) and [Creating categories for real-time transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html).
     *
     * To make a `StartCallAnalyticsJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
     *
     * Note that job queuing is enabled by default for Call Analytics jobs.
     *
     * You must include the following parameters in your `StartCallAnalyticsJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `CallAnalyticsJobName`: A custom name that you create for your transcription job that's unique within your Amazon Web Services account.
     * + `DataAccessRoleArn`: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files.
     * + `Media` (`MediaFileUri` or `RedactedMediaFileUri`): The Amazon S3 location of your media file.
     *
     * With Call Analytics, you can redact the audio contained in your media file by including `RedactedMediaFileUri`, instead of `MediaFileUri`, to specify the location of your input audio. If you choose to redact your audio, you can find your redacted media at the location specified in the `RedactedMediaFileUri` field of your response.
     */
    public suspend fun startCallAnalyticsJob(input: StartCallAnalyticsJobRequest): StartCallAnalyticsJobResponse

    /**
     * Transcribes patient-clinician conversations and generates clinical notes.
     *
     * Amazon Web Services HealthScribe automatically provides rich conversation transcripts, identifies speaker roles, classifies dialogues, extracts medical terms, and generates preliminary clinical notes. To learn more about these features, refer to [Amazon Web Services HealthScribe](https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe.html).
     *
     * To make a `StartMedicalScribeJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartMedicalTranscriptionJob` request:
     * + `DataAccessRoleArn`: The ARN of an IAM role with the these minimum permissions: read permission on input file Amazon S3 bucket specified in `Media`, write permission on the Amazon S3 bucket specified in `OutputBucketName`, and full permissions on the KMS key specified in `OutputEncryptionKMSKeyId` (if set). The role should also allow `transcribe.amazonaws.com` to assume it.
     * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
     * + `MedicalScribeJobName`: A custom name you create for your MedicalScribe job that is unique within your Amazon Web Services account.
     * + `OutputBucketName`: The Amazon S3 bucket where you want your output files stored.
     * + `Settings`: A `MedicalScribeSettings` obect that must set exactly one of `ShowSpeakerLabels` or `ChannelIdentification` to true. If `ShowSpeakerLabels` is true, `MaxSpeakerLabels` must also be set.
     * + `ChannelDefinitions`: A `MedicalScribeChannelDefinitions` array should be set if and only if the `ChannelIdentification` value of `Settings` is set to true.
     */
    public suspend fun startMedicalScribeJob(input: StartMedicalScribeJobRequest): StartMedicalScribeJobResponse

    /**
     * Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you choose to include in your request.
     *
     * In addition to many standard transcription features, Amazon Transcribe Medical provides you with a robust medical vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To learn more about these features, refer to [How Amazon Transcribe Medical works](https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html).
     *
     * To make a `StartMedicalTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartMedicalTranscriptionJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `MedicalTranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
     * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
     * + `LanguageCode`: This must be `en-US`.
     * + `OutputBucketName`: The Amazon S3 bucket where you want your transcript stored. If you want your output stored in a sub-folder of this bucket, you must also include `OutputKey`.
     * + `Specialty`: This must be `PRIMARYCARE`.
     * + `Type`: Choose whether your audio is a conversation or a dictation.
     */
    public suspend fun startMedicalTranscriptionJob(input: StartMedicalTranscriptionJobRequest): StartMedicalTranscriptionJobResponse

    /**
     * Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in your request.
     *
     * To make a `StartTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartTranscriptionJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `TranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
     * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
     * + One of `LanguageCode`, `IdentifyLanguage`, or `IdentifyMultipleLanguages`: If you know the language of your media file, specify it using the `LanguageCode` parameter; you can find all valid language codes in the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table. If you do not know the languages spoken in your media, use either `IdentifyLanguage` or `IdentifyMultipleLanguages` and let Amazon Transcribe identify the languages for you.
     */
    public suspend fun startTranscriptionJob(input: StartTranscriptionJobRequest): StartTranscriptionJobResponse

    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified Amazon Transcribe resource.
     *
     * If you include `UntagResource` in your request, you must also include `ResourceArn` and `TagKeys`.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified Call Analytics category with new rules. Note that the `UpdateCallAnalyticsCategory` operation overwrites all existing rules contained in the specified category. You cannot append additional rules onto an existing category.
     *
     * To create a new category, see .
     */
    public suspend fun updateCallAnalyticsCategory(input: UpdateCallAnalyticsCategoryRequest): UpdateCallAnalyticsCategoryResponse

    /**
     * Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing custom vocabulary.
     */
    public suspend fun updateMedicalVocabulary(input: UpdateMedicalVocabularyRequest): UpdateMedicalVocabularyResponse

    /**
     * Updates an existing custom vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing custom vocabulary.
     */
    public suspend fun updateVocabulary(input: UpdateVocabularyRequest): UpdateVocabularyResponse

    /**
     * Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all previous entries; you cannot append new terms onto an existing custom vocabulary filter.
     */
    public suspend fun updateVocabularyFilter(input: UpdateVocabularyFilterRequest): UpdateVocabularyFilterResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun TranscribeClient.withConfig(block: TranscribeClient.Config.Builder.() -> Unit): TranscribeClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultTranscribeClient(newConfig)
}

/**
 * Creates a new Call Analytics category.
 *
 * All categories are automatically applied to your Call Analytics transcriptions. Note that in order to apply categories to your transcriptions, you must create them before submitting your transcription request, as categories cannot be applied retroactively.
 *
 * When creating a new category, you can use the `InputType` parameter to label the category as a `POST_CALL` or a `REAL_TIME` category. `POST_CALL` categories can only be applied to post-call transcriptions and `REAL_TIME` categories can only be applied to real-time transcriptions. If you do not include `InputType`, your category is created as a `POST_CALL` category by default.
 *
 * Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules can include these parameters: , , , and .
 *
 * To update an existing category, see .
 *
 * To learn more about Call Analytics categories, see [Creating categories for post-call transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html) and [Creating categories for real-time transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html).
 */
public suspend inline fun TranscribeClient.createCallAnalyticsCategory(crossinline block: CreateCallAnalyticsCategoryRequest.Builder.() -> Unit): CreateCallAnalyticsCategoryResponse = createCallAnalyticsCategory(CreateCallAnalyticsCategoryRequest.Builder().apply(block).build())

/**
 * Creates a new custom language model.
 *
 * When creating a new custom language model, you must specify:
 * + If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz) base model
 * + The location of your training and tuning files (this must be an Amazon S3 URI)
 * + The language of your model
 * + A unique name for your model
 */
public suspend inline fun TranscribeClient.createLanguageModel(crossinline block: CreateLanguageModelRequest.Builder.() -> Unit): CreateLanguageModelResponse = createLanguageModel(CreateLanguageModelRequest.Builder().apply(block).build())

/**
 * Creates a new custom medical vocabulary.
 *
 * Before creating a new custom medical vocabulary, you must first upload a text file that contains your vocabulary table into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your request using the `Phrases` flag; `CreateMedicalVocabulary` does not support the `Phrases` flag and only accepts vocabularies in table format.
 *
 * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
 *
 * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
 */
public suspend inline fun TranscribeClient.createMedicalVocabulary(crossinline block: CreateMedicalVocabularyRequest.Builder.() -> Unit): CreateMedicalVocabularyResponse = createMedicalVocabulary(CreateMedicalVocabularyRequest.Builder().apply(block).build())

/**
 * Creates a new custom vocabulary.
 *
 * When creating a new custom vocabulary, you can either upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket and include the URI in your request. Or you can include a list of terms directly in your request using the `Phrases` flag.
 *
 * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
 *
 * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
 */
public suspend inline fun TranscribeClient.createVocabulary(crossinline block: CreateVocabularyRequest.Builder.() -> Unit): CreateVocabularyResponse = createVocabulary(CreateVocabularyRequest.Builder().apply(block).build())

/**
 * Creates a new custom vocabulary filter.
 *
 * You can use custom vocabulary filters to mask, delete, or flag specific words from your transcript. Custom vocabulary filters are commonly used to mask profanity in transcripts.
 *
 * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
 *
 * For more information, see [Vocabulary filtering](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
 */
public suspend inline fun TranscribeClient.createVocabularyFilter(crossinline block: CreateVocabularyFilterRequest.Builder.() -> Unit): CreateVocabularyFilterResponse = createVocabularyFilter(CreateVocabularyFilterRequest.Builder().apply(block).build())

/**
 * Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete using `CategoryName`. Category names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteCallAnalyticsCategory(crossinline block: DeleteCallAnalyticsCategoryRequest.Builder.() -> Unit): DeleteCallAnalyticsCategoryResponse = deleteCallAnalyticsCategory(DeleteCallAnalyticsCategoryRequest.Builder().apply(block).build())

/**
 * Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using `CallAnalyticsJobName`. Job names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteCallAnalyticsJob(crossinline block: DeleteCallAnalyticsJobRequest.Builder.() -> Unit): DeleteCallAnalyticsJobResponse = deleteCallAnalyticsJob(DeleteCallAnalyticsJobRequest.Builder().apply(block).build())

/**
 * Deletes a custom language model. To use this operation, specify the name of the language model you want to delete using `ModelName`. custom language model names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteLanguageModel(crossinline block: DeleteLanguageModelRequest.Builder.() -> Unit): DeleteLanguageModelResponse = deleteLanguageModel(DeleteLanguageModelRequest.Builder().apply(block).build())

/**
 * Deletes a Medical Scribe job. To use this operation, specify the name of the job you want to delete using `MedicalScribeJobName`. Job names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteMedicalScribeJob(crossinline block: DeleteMedicalScribeJobRequest.Builder.() -> Unit): DeleteMedicalScribeJobResponse = deleteMedicalScribeJob(DeleteMedicalScribeJobRequest.Builder().apply(block).build())

/**
 * Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using `MedicalTranscriptionJobName`. Job names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteMedicalTranscriptionJob(crossinline block: DeleteMedicalTranscriptionJobRequest.Builder.() -> Unit): DeleteMedicalTranscriptionJobResponse = deleteMedicalTranscriptionJob(DeleteMedicalTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Deletes a custom medical vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete using `VocabularyName`. Custom vocabulary names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteMedicalVocabulary(crossinline block: DeleteMedicalVocabularyRequest.Builder.() -> Unit): DeleteMedicalVocabularyResponse = deleteMedicalVocabulary(DeleteMedicalVocabularyRequest.Builder().apply(block).build())

/**
 * Deletes a transcription job. To use this operation, specify the name of the job you want to delete using `TranscriptionJobName`. Job names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteTranscriptionJob(crossinline block: DeleteTranscriptionJobRequest.Builder.() -> Unit): DeleteTranscriptionJobResponse = deleteTranscriptionJob(DeleteTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Deletes a custom vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete using `VocabularyName`. Custom vocabulary names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteVocabulary(crossinline block: DeleteVocabularyRequest.Builder.() -> Unit): DeleteVocabularyResponse = deleteVocabulary(DeleteVocabularyRequest.Builder().apply(block).build())

/**
 * Deletes a custom vocabulary filter. To use this operation, specify the name of the custom vocabulary filter you want to delete using `VocabularyFilterName`. Custom vocabulary filter names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteVocabularyFilter(crossinline block: DeleteVocabularyFilterRequest.Builder.() -> Unit): DeleteVocabularyFilterResponse = deleteVocabularyFilter(DeleteVocabularyFilterRequest.Builder().apply(block).build())

/**
 * Provides information about the specified custom language model.
 *
 * This operation also shows if the base language model that you used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model.
 *
 * If you tried to create a new custom language model and the request wasn't successful, you can use `DescribeLanguageModel` to help identify the reason for this failure.
 */
public suspend inline fun TranscribeClient.describeLanguageModel(crossinline block: DescribeLanguageModelRequest.Builder.() -> Unit): DescribeLanguageModelResponse = describeLanguageModel(DescribeLanguageModelRequest.Builder().apply(block).build())

/**
 * Provides information about the specified Call Analytics category.
 *
 * To get a list of your Call Analytics categories, use the operation.
 */
public suspend inline fun TranscribeClient.getCallAnalyticsCategory(crossinline block: GetCallAnalyticsCategoryRequest.Builder.() -> Unit): GetCallAnalyticsCategoryResponse = getCallAnalyticsCategory(GetCallAnalyticsCategoryRequest.Builder().apply(block).build())

/**
 * Provides information about the specified Call Analytics job.
 *
 * To view the job's status, refer to `CallAnalyticsJobStatus`. If the status is `COMPLETED`, the job is finished. You can find your completed transcript at the URI specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
 *
 * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the location specified in `RedactedTranscriptFileUri`.
 *
 * If you chose to redact the audio in your media file, you can find your redacted media file at the location specified in `RedactedMediaFileUri`.
 *
 * To get a list of your Call Analytics jobs, use the operation.
 */
public suspend inline fun TranscribeClient.getCallAnalyticsJob(crossinline block: GetCallAnalyticsJobRequest.Builder.() -> Unit): GetCallAnalyticsJobResponse = getCallAnalyticsJob(GetCallAnalyticsJobRequest.Builder().apply(block).build())

/**
 * Provides information about the specified Medical Scribe job.
 *
 * To view the status of the specified medical transcription job, check the `MedicalScribeJobStatus` field. If the status is `COMPLETED`, the job is finished. You can find the results at the location specified in `MedicalScribeOutput`. If the status is `FAILED`, `FailureReason` provides details on why your Medical Scribe job failed.
 *
 * To get a list of your Medical Scribe jobs, use the operation.
 */
public suspend inline fun TranscribeClient.getMedicalScribeJob(crossinline block: GetMedicalScribeJobRequest.Builder.() -> Unit): GetMedicalScribeJobResponse = getMedicalScribeJob(GetMedicalScribeJobRequest.Builder().apply(block).build())

/**
 * Provides information about the specified medical transcription job.
 *
 * To view the status of the specified medical transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished. You can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
 *
 * To get a list of your medical transcription jobs, use the operation.
 */
public suspend inline fun TranscribeClient.getMedicalTranscriptionJob(crossinline block: GetMedicalTranscriptionJobRequest.Builder.() -> Unit): GetMedicalTranscriptionJobResponse = getMedicalTranscriptionJob(GetMedicalTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Provides information about the specified custom medical vocabulary.
 *
 * To view the status of the specified custom medical vocabulary, check the `VocabularyState` field. If the status is `READY`, your custom vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary failed.
 *
 * To get a list of your custom medical vocabularies, use the operation.
 */
public suspend inline fun TranscribeClient.getMedicalVocabulary(crossinline block: GetMedicalVocabularyRequest.Builder.() -> Unit): GetMedicalVocabularyResponse = getMedicalVocabulary(GetMedicalVocabularyRequest.Builder().apply(block).build())

/**
 * Provides information about the specified transcription job.
 *
 * To view the status of the specified transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished. You can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
 *
 * If you enabled content redaction, the redacted transcript can be found at the location specified in `RedactedTranscriptFileUri`.
 *
 * To get a list of your transcription jobs, use the operation.
 */
public suspend inline fun TranscribeClient.getTranscriptionJob(crossinline block: GetTranscriptionJobRequest.Builder.() -> Unit): GetTranscriptionJobResponse = getTranscriptionJob(GetTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Provides information about the specified custom vocabulary.
 *
 * To view the status of the specified custom vocabulary, check the `VocabularyState` field. If the status is `READY`, your custom vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your custom vocabulary failed.
 *
 * To get a list of your custom vocabularies, use the operation.
 */
public suspend inline fun TranscribeClient.getVocabulary(crossinline block: GetVocabularyRequest.Builder.() -> Unit): GetVocabularyResponse = getVocabulary(GetVocabularyRequest.Builder().apply(block).build())

/**
 * Provides information about the specified custom vocabulary filter.
 *
 * To get a list of your custom vocabulary filters, use the operation.
 */
public suspend inline fun TranscribeClient.getVocabularyFilter(crossinline block: GetVocabularyFilterRequest.Builder.() -> Unit): GetVocabularyFilterResponse = getVocabularyFilter(GetVocabularyFilterRequest.Builder().apply(block).build())

/**
 * Provides a list of Call Analytics categories, including all rules that make up each category.
 *
 * To get detailed information about a specific Call Analytics category, use the operation.
 */
public suspend inline fun TranscribeClient.listCallAnalyticsCategories(crossinline block: ListCallAnalyticsCategoriesRequest.Builder.() -> Unit): ListCallAnalyticsCategoriesResponse = listCallAnalyticsCategories(ListCallAnalyticsCategoriesRequest.Builder().apply(block).build())

/**
 * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call Analytics jobs are returned.
 *
 * To get detailed information about a specific Call Analytics job, use the operation.
 */
public suspend inline fun TranscribeClient.listCallAnalyticsJobs(crossinline block: ListCallAnalyticsJobsRequest.Builder.() -> Unit): ListCallAnalyticsJobsResponse = listCallAnalyticsJobs(ListCallAnalyticsJobsRequest.Builder().apply(block).build())

/**
 * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all custom language models are returned.
 *
 * To get detailed information about a specific custom language model, use the operation.
 */
public suspend inline fun TranscribeClient.listLanguageModels(crossinline block: ListLanguageModelsRequest.Builder.() -> Unit): ListLanguageModelsResponse = listLanguageModels(ListLanguageModelsRequest.Builder().apply(block).build())

/**
 * Provides a list of Medical Scribe jobs that match the specified criteria. If no criteria are specified, all Medical Scribe jobs are returned.
 *
 * To get detailed information about a specific Medical Scribe job, use the operation.
 */
public suspend inline fun TranscribeClient.listMedicalScribeJobs(crossinline block: ListMedicalScribeJobsRequest.Builder.() -> Unit): ListMedicalScribeJobsResponse = listMedicalScribeJobs(ListMedicalScribeJobsRequest.Builder().apply(block).build())

/**
 * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified, all medical transcription jobs are returned.
 *
 * To get detailed information about a specific medical transcription job, use the operation.
 */
public suspend inline fun TranscribeClient.listMedicalTranscriptionJobs(crossinline block: ListMedicalTranscriptionJobsRequest.Builder.() -> Unit): ListMedicalTranscriptionJobsResponse = listMedicalTranscriptionJobs(ListMedicalTranscriptionJobsRequest.Builder().apply(block).build())

/**
 * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified, all custom medical vocabularies are returned.
 *
 * To get detailed information about a specific custom medical vocabulary, use the operation.
 */
public suspend inline fun TranscribeClient.listMedicalVocabularies(crossinline block: ListMedicalVocabulariesRequest.Builder.() -> Unit): ListMedicalVocabulariesResponse = listMedicalVocabularies(ListMedicalVocabulariesRequest.Builder().apply(block).build())

/**
 * Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
 *
 * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
 */
public suspend inline fun TranscribeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all transcription jobs are returned.
 *
 * To get detailed information about a specific transcription job, use the operation.
 */
public suspend inline fun TranscribeClient.listTranscriptionJobs(crossinline block: ListTranscriptionJobsRequest.Builder.() -> Unit): ListTranscriptionJobsResponse = listTranscriptionJobs(ListTranscriptionJobsRequest.Builder().apply(block).build())

/**
 * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
 *
 * To get detailed information about a specific custom vocabulary, use the operation.
 */
public suspend inline fun TranscribeClient.listVocabularies(crossinline block: ListVocabulariesRequest.Builder.() -> Unit): ListVocabulariesResponse = listVocabularies(ListVocabulariesRequest.Builder().apply(block).build())

/**
 * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
 *
 * To get detailed information about a specific custom vocabulary filter, use the operation.
 */
public suspend inline fun TranscribeClient.listVocabularyFilters(crossinline block: ListVocabularyFiltersRequest.Builder.() -> Unit): ListVocabularyFiltersResponse = listVocabularyFilters(ListVocabularyFiltersRequest.Builder().apply(block).build())

/**
 * Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to include in your request.
 *
 * In addition to many standard transcription features, Call Analytics provides you with call characteristics, call summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can also apply custom categories to flag specified conditions. To learn more about these features and insights, refer to [Analyzing call center audio with Call Analytics](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html).
 *
 * If you want to apply categories to your Call Analytics job, you must create them before submitting your job request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To learn more about Call Analytics categories, see [Creating categories for post-call transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html) and [Creating categories for real-time transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html).
 *
 * To make a `StartCallAnalyticsJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
 *
 * Note that job queuing is enabled by default for Call Analytics jobs.
 *
 * You must include the following parameters in your `StartCallAnalyticsJob` request:
 * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
 * + `CallAnalyticsJobName`: A custom name that you create for your transcription job that's unique within your Amazon Web Services account.
 * + `DataAccessRoleArn`: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files.
 * + `Media` (`MediaFileUri` or `RedactedMediaFileUri`): The Amazon S3 location of your media file.
 *
 * With Call Analytics, you can redact the audio contained in your media file by including `RedactedMediaFileUri`, instead of `MediaFileUri`, to specify the location of your input audio. If you choose to redact your audio, you can find your redacted media at the location specified in the `RedactedMediaFileUri` field of your response.
 */
public suspend inline fun TranscribeClient.startCallAnalyticsJob(crossinline block: StartCallAnalyticsJobRequest.Builder.() -> Unit): StartCallAnalyticsJobResponse = startCallAnalyticsJob(StartCallAnalyticsJobRequest.Builder().apply(block).build())

/**
 * Transcribes patient-clinician conversations and generates clinical notes.
 *
 * Amazon Web Services HealthScribe automatically provides rich conversation transcripts, identifies speaker roles, classifies dialogues, extracts medical terms, and generates preliminary clinical notes. To learn more about these features, refer to [Amazon Web Services HealthScribe](https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe.html).
 *
 * To make a `StartMedicalScribeJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
 *
 * You must include the following parameters in your `StartMedicalTranscriptionJob` request:
 * + `DataAccessRoleArn`: The ARN of an IAM role with the these minimum permissions: read permission on input file Amazon S3 bucket specified in `Media`, write permission on the Amazon S3 bucket specified in `OutputBucketName`, and full permissions on the KMS key specified in `OutputEncryptionKMSKeyId` (if set). The role should also allow `transcribe.amazonaws.com` to assume it.
 * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
 * + `MedicalScribeJobName`: A custom name you create for your MedicalScribe job that is unique within your Amazon Web Services account.
 * + `OutputBucketName`: The Amazon S3 bucket where you want your output files stored.
 * + `Settings`: A `MedicalScribeSettings` obect that must set exactly one of `ShowSpeakerLabels` or `ChannelIdentification` to true. If `ShowSpeakerLabels` is true, `MaxSpeakerLabels` must also be set.
 * + `ChannelDefinitions`: A `MedicalScribeChannelDefinitions` array should be set if and only if the `ChannelIdentification` value of `Settings` is set to true.
 */
public suspend inline fun TranscribeClient.startMedicalScribeJob(crossinline block: StartMedicalScribeJobRequest.Builder.() -> Unit): StartMedicalScribeJobResponse = startMedicalScribeJob(StartMedicalScribeJobRequest.Builder().apply(block).build())

/**
 * Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you choose to include in your request.
 *
 * In addition to many standard transcription features, Amazon Transcribe Medical provides you with a robust medical vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To learn more about these features, refer to [How Amazon Transcribe Medical works](https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html).
 *
 * To make a `StartMedicalTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
 *
 * You must include the following parameters in your `StartMedicalTranscriptionJob` request:
 * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
 * + `MedicalTranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
 * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
 * + `LanguageCode`: This must be `en-US`.
 * + `OutputBucketName`: The Amazon S3 bucket where you want your transcript stored. If you want your output stored in a sub-folder of this bucket, you must also include `OutputKey`.
 * + `Specialty`: This must be `PRIMARYCARE`.
 * + `Type`: Choose whether your audio is a conversation or a dictation.
 */
public suspend inline fun TranscribeClient.startMedicalTranscriptionJob(crossinline block: StartMedicalTranscriptionJobRequest.Builder.() -> Unit): StartMedicalTranscriptionJobResponse = startMedicalTranscriptionJob(StartMedicalTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in your request.
 *
 * To make a `StartTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
 *
 * You must include the following parameters in your `StartTranscriptionJob` request:
 * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
 * + `TranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
 * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
 * + One of `LanguageCode`, `IdentifyLanguage`, or `IdentifyMultipleLanguages`: If you know the language of your media file, specify it using the `LanguageCode` parameter; you can find all valid language codes in the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table. If you do not know the languages spoken in your media, use either `IdentifyLanguage` or `IdentifyMultipleLanguages` and let Amazon Transcribe identify the languages for you.
 */
public suspend inline fun TranscribeClient.startTranscriptionJob(crossinline block: StartTranscriptionJobRequest.Builder.() -> Unit): StartTranscriptionJobResponse = startTranscriptionJob(StartTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
 *
 * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
 */
public suspend inline fun TranscribeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified Amazon Transcribe resource.
 *
 * If you include `UntagResource` in your request, you must also include `ResourceArn` and `TagKeys`.
 */
public suspend inline fun TranscribeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified Call Analytics category with new rules. Note that the `UpdateCallAnalyticsCategory` operation overwrites all existing rules contained in the specified category. You cannot append additional rules onto an existing category.
 *
 * To create a new category, see .
 */
public suspend inline fun TranscribeClient.updateCallAnalyticsCategory(crossinline block: UpdateCallAnalyticsCategoryRequest.Builder.() -> Unit): UpdateCallAnalyticsCategoryResponse = updateCallAnalyticsCategory(UpdateCallAnalyticsCategoryRequest.Builder().apply(block).build())

/**
 * Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing custom vocabulary.
 */
public suspend inline fun TranscribeClient.updateMedicalVocabulary(crossinline block: UpdateMedicalVocabularyRequest.Builder.() -> Unit): UpdateMedicalVocabularyResponse = updateMedicalVocabulary(UpdateMedicalVocabularyRequest.Builder().apply(block).build())

/**
 * Updates an existing custom vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing custom vocabulary.
 */
public suspend inline fun TranscribeClient.updateVocabulary(crossinline block: UpdateVocabularyRequest.Builder.() -> Unit): UpdateVocabularyResponse = updateVocabulary(UpdateVocabularyRequest.Builder().apply(block).build())

/**
 * Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all previous entries; you cannot append new terms onto an existing custom vocabulary filter.
 */
public suspend inline fun TranscribeClient.updateVocabularyFilter(crossinline block: UpdateVocabularyFilterRequest.Builder.() -> Unit): UpdateVocabularyFilterResponse = updateVocabularyFilter(UpdateVocabularyFilterRequest.Builder().apply(block).build())
