// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.transform

import aws.sdk.kotlin.services.transcribe.model.ListVocabulariesResponse
import aws.sdk.kotlin.services.transcribe.model.TranscribeException
import aws.sdk.kotlin.services.transcribe.model.VocabularyInfo
import aws.sdk.kotlin.services.transcribe.model.VocabularyState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListVocabulariesOperationDeserializer: HttpDeserialize<ListVocabulariesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListVocabulariesResponse {
        if (!response.status.isSuccess()) {
            throwListVocabulariesError(context, response)
        }
        val builder = ListVocabulariesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListVocabulariesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListVocabulariesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TranscribeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListVocabulariesOperationBody(builder: ListVocabulariesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val VOCABULARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Vocabularies"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(VOCABULARIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { VocabularyState.fromValue(it) }
                VOCABULARIES_DESCRIPTOR.index -> builder.vocabularies =
                    deserializer.deserializeList(VOCABULARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<VocabularyInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVocabularyInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
