// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.transform

import aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsResponse
import aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionJobSummary
import aws.sdk.kotlin.services.transcribe.model.TranscribeException
import aws.sdk.kotlin.services.transcribe.model.TranscriptionJobStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListMedicalTranscriptionJobsOperationDeserializer: HttpDeserialize<ListMedicalTranscriptionJobsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListMedicalTranscriptionJobsResponse {
        if (!response.status.isSuccess()) {
            throwListMedicalTranscriptionJobsError(context, response)
        }
        val builder = ListMedicalTranscriptionJobsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListMedicalTranscriptionJobsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListMedicalTranscriptionJobsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TranscribeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListMedicalTranscriptionJobsOperationBody(builder: ListMedicalTranscriptionJobsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MEDICALTRANSCRIPTIONJOBSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MedicalTranscriptionJobSummaries"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MEDICALTRANSCRIPTIONJOBSUMMARIES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MEDICALTRANSCRIPTIONJOBSUMMARIES_DESCRIPTOR.index -> builder.medicalTranscriptionJobSummaries =
                    deserializer.deserializeList(MEDICALTRANSCRIPTIONJOBSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<MedicalTranscriptionJobSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMedicalTranscriptionJobSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { TranscriptionJobStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
