// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.transform

import aws.sdk.kotlin.services.transcribe.model.GetVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.LanguageCode
import aws.sdk.kotlin.services.transcribe.model.TranscribeException
import aws.sdk.kotlin.services.transcribe.model.VocabularyState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetVocabularyOperationDeserializer: HttpDeserialize<GetVocabularyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetVocabularyResponse {
        if (!response.status.isSuccess()) {
            throwGetVocabularyError(context, response)
        }
        val builder = GetVocabularyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetVocabularyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetVocabularyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TranscribeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetVocabularyOperationBody(builder: GetVocabularyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOWNLOADURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DownloadUri"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FailureReason"))
    val LANGUAGECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("LanguageCode"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTime"))
    val VOCABULARYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VocabularyName"))
    val VOCABULARYSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("VocabularyState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOWNLOADURI_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(LANGUAGECODE_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(VOCABULARYNAME_DESCRIPTOR)
        field(VOCABULARYSTATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOWNLOADURI_DESCRIPTOR.index -> builder.downloadUri = deserializeString()
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                LANGUAGECODE_DESCRIPTOR.index -> builder.languageCode = deserializeString().let { LanguageCode.fromValue(it) }
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                VOCABULARYNAME_DESCRIPTOR.index -> builder.vocabularyName = deserializeString()
                VOCABULARYSTATE_DESCRIPTOR.index -> builder.vocabularyState = deserializeString().let { VocabularyState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
