// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.transform

import aws.sdk.kotlin.services.transcribe.model.GetMedicalTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionJob
import aws.sdk.kotlin.services.transcribe.model.TranscribeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetMedicalTranscriptionJobOperationDeserializer: HttpDeserialize<GetMedicalTranscriptionJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMedicalTranscriptionJobResponse {
        if (!response.status.isSuccess()) {
            throwGetMedicalTranscriptionJobError(context, response)
        }
        val builder = GetMedicalTranscriptionJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMedicalTranscriptionJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetMedicalTranscriptionJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TranscribeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMedicalTranscriptionJobOperationBody(builder: GetMedicalTranscriptionJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MEDICALTRANSCRIPTIONJOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MedicalTranscriptionJob"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MEDICALTRANSCRIPTIONJOB_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MEDICALTRANSCRIPTIONJOB_DESCRIPTOR.index -> builder.medicalTranscriptionJob = deserializeMedicalTranscriptionJobDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
