// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a custom vocabulary filter, including the language of the filter, when it was last modified, and its name.
 */
public class VocabularyFilterInfo private constructor(builder: Builder) {
    /**
     * The language code that represents the language of the entries in your vocabulary filter. Each custom vocabulary filter must contain terms in only one language.
     *
     * A custom vocabulary filter can only be used to transcribe files in the same language as the filter. For example, if you create a custom vocabulary filter using US English (`en-US`), you can only apply this filter to files that contain English audio.
     *
     * For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * The date and time the specified custom vocabulary filter was last modified.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * A unique name, chosen by you, for your custom vocabulary filter. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
     */
    public val vocabularyFilterName: kotlin.String? = builder.vocabularyFilterName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.VocabularyFilterInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VocabularyFilterInfo(")
        append("languageCode=$languageCode,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("vocabularyFilterName=$vocabularyFilterName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageCode?.hashCode() ?: 0
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VocabularyFilterInfo

        if (languageCode != other.languageCode) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.VocabularyFilterInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The language code that represents the language of the entries in your vocabulary filter. Each custom vocabulary filter must contain terms in only one language.
         *
         * A custom vocabulary filter can only be used to transcribe files in the same language as the filter. For example, if you create a custom vocabulary filter using US English (`en-US`), you can only apply this filter to files that contain English audio.
         *
         * For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * The date and time the specified custom vocabulary filter was last modified.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique name, chosen by you, for your custom vocabulary filter. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         */
        public var vocabularyFilterName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.VocabularyFilterInfo) : this() {
            this.languageCode = x.languageCode
            this.lastModifiedTime = x.lastModifiedTime
            this.vocabularyFilterName = x.vocabularyFilterName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.VocabularyFilterInfo = VocabularyFilterInfo(this)
    }
}
