// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Adds metadata, in the form of a key:value pair, to the specified resource.
 *
 * For example, you could add the tag `Department:Sales` to a resource to indicate that it pertains to your organization's sales department. You can also use tags for tag-based access control.
 *
 * To learn more about tagging, see [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
 */
public class Tag private constructor(builder: Builder) {
    /**
     * The first part of a key:value pair that forms a tag associated with a given resource. For example, in the tag `Department:Sales`, the key is 'Department'.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The second part of a key:value pair that forms a tag associated with a given resource. For example, in the tag `Department:Sales`, the value is 'Sales'.
     *
     * Note that you can set the value of a tag to an empty string, but you can't set the value of a tag to null. Omitting the tag value is the same as using an empty string.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.Tag = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tag(")
        append("key=$key,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Tag

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.Tag = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The first part of a key:value pair that forms a tag associated with a given resource. For example, in the tag `Department:Sales`, the key is 'Department'.
         */
        public var key: kotlin.String? = null
        /**
         * The second part of a key:value pair that forms a tag associated with a given resource. For example, in the tag `Department:Sales`, the value is 'Sales'.
         *
         * Note that you can set the value of a tag to an empty string, but you can't set the value of a tag to null. Omitting the tag value is the same as using an empty string.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.Tag) : this() {
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.Tag = Tag(this)
    }
}
