// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Provides information about your subtitle file, including format, start index, and Amazon S3 location.
 */
public class SubtitlesOutput private constructor(builder: Builder) {
    /**
     * Provides the format of your subtitle files. If your request included both WebVTT (`vtt`) and SubRip (`srt`) formats, both formats are shown.
     */
    public val formats: List<SubtitleFormat>? = builder.formats
    /**
     * Provides the start index value for your subtitle files. If you did not specify a value in your request, the default value of `0` is used.
     */
    public val outputStartIndex: kotlin.Int? = builder.outputStartIndex
    /**
     * The Amazon S3 location of your transcript. You can use this URI to access or download your subtitle file. Your subtitle file is stored in the same location as your transcript. If you specified both WebVTT and SubRip subtitle formats, two URIs are provided.
     *
     * If you included `OutputBucketName` in your transcription job request, this is the URI of that bucket. If you also included `OutputKey` in your request, your output is located in the path you specified in your request.
     *
     * If you didn't include `OutputBucketName` in your transcription job request, your subtitle file is stored in a service-managed bucket, and `TranscriptFileUri` provides you with a temporary URI you can use for secure access to your subtitle file.
     *
     * Temporary URIs for service-managed Amazon S3 buckets are only valid for 15 minutes. If you get an `AccesDenied` error, you can get a new temporary URI by running a `GetTranscriptionJob` or `ListTranscriptionJob` request.
     */
    public val subtitleFileUris: List<String>? = builder.subtitleFileUris

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.SubtitlesOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubtitlesOutput(")
        append("formats=$formats,")
        append("outputStartIndex=$outputStartIndex,")
        append("subtitleFileUris=$subtitleFileUris")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = formats?.hashCode() ?: 0
        result = 31 * result + (outputStartIndex ?: 0)
        result = 31 * result + (subtitleFileUris?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubtitlesOutput

        if (formats != other.formats) return false
        if (outputStartIndex != other.outputStartIndex) return false
        if (subtitleFileUris != other.subtitleFileUris) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.SubtitlesOutput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides the format of your subtitle files. If your request included both WebVTT (`vtt`) and SubRip (`srt`) formats, both formats are shown.
         */
        public var formats: List<SubtitleFormat>? = null
        /**
         * Provides the start index value for your subtitle files. If you did not specify a value in your request, the default value of `0` is used.
         */
        public var outputStartIndex: kotlin.Int? = null
        /**
         * The Amazon S3 location of your transcript. You can use this URI to access or download your subtitle file. Your subtitle file is stored in the same location as your transcript. If you specified both WebVTT and SubRip subtitle formats, two URIs are provided.
         *
         * If you included `OutputBucketName` in your transcription job request, this is the URI of that bucket. If you also included `OutputKey` in your request, your output is located in the path you specified in your request.
         *
         * If you didn't include `OutputBucketName` in your transcription job request, your subtitle file is stored in a service-managed bucket, and `TranscriptFileUri` provides you with a temporary URI you can use for secure access to your subtitle file.
         *
         * Temporary URIs for service-managed Amazon S3 buckets are only valid for 15 minutes. If you get an `AccesDenied` error, you can get a new temporary URI by running a `GetTranscriptionJob` or `ListTranscriptionJob` request.
         */
        public var subtitleFileUris: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.SubtitlesOutput) : this() {
            this.formats = x.formats
            this.outputStartIndex = x.outputStartIndex
            this.subtitleFileUris = x.subtitleFileUris
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.SubtitlesOutput = SubtitlesOutput(this)
    }
}
