// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a custom language model, including the base model name, when the model was created, the location of the files used to train the model, when the model was last modified, the name you chose for the model, its language, its processing state, and if there is an upgrade available for the base model.
 */
public class LanguageModel private constructor(builder: Builder) {
    /**
     * The Amazon Transcribe standard language model, or base model, used to create your custom language model.
     */
    public val baseModelName: aws.sdk.kotlin.services.transcribe.model.BaseModelName? = builder.baseModelName
    /**
     * The date and time the specified custom language model was created.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * If `ModelStatus` is `FAILED`, `FailureReason` contains information about why the custom language model request failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The Amazon S3 location of the input files used to train and tune your custom language model, in addition to the data access role ARN (Amazon Resource Name) that has permissions to access these data.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.transcribe.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The language code used to create your custom language model. Each custom language model must contain terms in only one language, and the language you select for your custom language model must match the language of your training and tuning data.
     *
     * For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table. Note that U.S. English (`en-US`) is the only language supported with Amazon Transcribe Medical.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.ClmLanguageCode? = builder.languageCode
    /**
     * The date and time the specified custom language model was last modified.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * A unique name, chosen by you, for your custom language model.
     *
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
     */
    public val modelName: kotlin.String? = builder.modelName
    /**
     * The status of the specified custom language model. When the status displays as `COMPLETED` the model is ready for use.
     */
    public val modelStatus: aws.sdk.kotlin.services.transcribe.model.ModelStatus? = builder.modelStatus
    /**
     * Shows if a more current base model is available for use with the specified custom language model.
     *
     * If `false`, your custom language model is using the most up-to-date base model.
     *
     * If `true`, there is a newer base model available than the one your language model is using.
     *
     * Note that to update a base model, you must recreate the custom language model using the new base model. Base model upgrades for existing custom language models are not supported.
     */
    public val upgradeAvailability: kotlin.Boolean? = builder.upgradeAvailability

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.LanguageModel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LanguageModel(")
        append("baseModelName=$baseModelName,")
        append("createTime=$createTime,")
        append("failureReason=$failureReason,")
        append("inputDataConfig=$inputDataConfig,")
        append("languageCode=$languageCode,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("modelName=$modelName,")
        append("modelStatus=$modelStatus,")
        append("upgradeAvailability=$upgradeAvailability")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseModelName?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (modelStatus?.hashCode() ?: 0)
        result = 31 * result + (upgradeAvailability?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LanguageModel

        if (baseModelName != other.baseModelName) return false
        if (createTime != other.createTime) return false
        if (failureReason != other.failureReason) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (languageCode != other.languageCode) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (modelName != other.modelName) return false
        if (modelStatus != other.modelStatus) return false
        if (upgradeAvailability != other.upgradeAvailability) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.LanguageModel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Transcribe standard language model, or base model, used to create your custom language model.
         */
        public var baseModelName: aws.sdk.kotlin.services.transcribe.model.BaseModelName? = null
        /**
         * The date and time the specified custom language model was created.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If `ModelStatus` is `FAILED`, `FailureReason` contains information about why the custom language model request failed. See also: [Common Errors](https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The Amazon S3 location of the input files used to train and tune your custom language model, in addition to the data access role ARN (Amazon Resource Name) that has permissions to access these data.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.transcribe.model.InputDataConfig? = null
        /**
         * The language code used to create your custom language model. Each custom language model must contain terms in only one language, and the language you select for your custom language model must match the language of your training and tuning data.
         *
         * For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table. Note that U.S. English (`en-US`) is the only language supported with Amazon Transcribe Medical.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.ClmLanguageCode? = null
        /**
         * The date and time the specified custom language model was last modified.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents 12:32 PM UTC-7 on May 4, 2022.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique name, chosen by you, for your custom language model.
         *
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         */
        public var modelName: kotlin.String? = null
        /**
         * The status of the specified custom language model. When the status displays as `COMPLETED` the model is ready for use.
         */
        public var modelStatus: aws.sdk.kotlin.services.transcribe.model.ModelStatus? = null
        /**
         * Shows if a more current base model is available for use with the specified custom language model.
         *
         * If `false`, your custom language model is using the most up-to-date base model.
         *
         * If `true`, there is a newer base model available than the one your language model is using.
         *
         * Note that to update a base model, you must recreate the custom language model using the new base model. Base model upgrades for existing custom language models are not supported.
         */
        public var upgradeAvailability: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.LanguageModel) : this() {
            this.baseModelName = x.baseModelName
            this.createTime = x.createTime
            this.failureReason = x.failureReason
            this.inputDataConfig = x.inputDataConfig
            this.languageCode = x.languageCode
            this.lastModifiedTime = x.lastModifiedTime
            this.modelName = x.modelName
            this.modelStatus = x.modelStatus
            this.upgradeAvailability = x.upgradeAvailability
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.LanguageModel = LanguageModel(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.transcribe.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.transcribe.model.InputDataConfig.invoke(block)
        }
    }
}
