// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



public class CreateVocabularyRequest private constructor(builder: Builder) {
    /**
     * The language code that represents the language of the entries in your custom vocabulary. Each custom vocabulary must contain terms in only one language.
     *
     * A custom vocabulary can only be used to transcribe files in the same language as the custom vocabulary. For example, if you create a custom vocabulary using US English (`en-US`), you can only apply this custom vocabulary to files that contain English audio.
     *
     * For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * Use this parameter if you want to create your custom vocabulary by including all desired terms, as comma-separated values, within your request. The other option for creating your custom vocabulary is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the `VocabularyFileUri` parameter.
     *
     * Note that if you include `Phrases` in your request, you cannot use `VocabularyFileUri`; you must choose one or the other.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     */
    public val phrases: List<String>? = builder.phrases
    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to a new custom vocabulary at the time you create this new custom vocabulary.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Amazon S3 location of the text file that contains your custom vocabulary. The URI must be located in the same Amazon Web Services Region as the resource you're calling.
     *
     * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt`
     *
     * Note that if you include `VocabularyFileUri` in your request, you cannot use the `Phrases` flag; you must choose one or the other.
     */
    public val vocabularyFileUri: kotlin.String? = builder.vocabularyFileUri
    /**
     * A unique name, chosen by you, for your new custom vocabulary.
     *
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new custom vocabulary with the same name as an existing custom vocabulary, you get a `ConflictException` error.
     */
    public val vocabularyName: kotlin.String? = requireNotNull(builder.vocabularyName) { "A non-null value must be provided for vocabularyName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.CreateVocabularyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateVocabularyRequest(")
        append("languageCode=$languageCode,")
        append("phrases=$phrases,")
        append("tags=$tags,")
        append("vocabularyFileUri=$vocabularyFileUri,")
        append("vocabularyName=$vocabularyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageCode?.hashCode() ?: 0
        result = 31 * result + (phrases?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFileUri?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateVocabularyRequest

        if (languageCode != other.languageCode) return false
        if (phrases != other.phrases) return false
        if (tags != other.tags) return false
        if (vocabularyFileUri != other.vocabularyFileUri) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.CreateVocabularyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The language code that represents the language of the entries in your custom vocabulary. Each custom vocabulary must contain terms in only one language.
         *
         * A custom vocabulary can only be used to transcribe files in the same language as the custom vocabulary. For example, if you create a custom vocabulary using US English (`en-US`), you can only apply this custom vocabulary to files that contain English audio.
         *
         * For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * Use this parameter if you want to create your custom vocabulary by including all desired terms, as comma-separated values, within your request. The other option for creating your custom vocabulary is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the `VocabularyFileUri` parameter.
         *
         * Note that if you include `Phrases` in your request, you cannot use `VocabularyFileUri`; you must choose one or the other.
         *
         * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
         */
        public var phrases: List<String>? = null
        /**
         * Adds one or more custom tags, each in the form of a key:value pair, to a new custom vocabulary at the time you create this new custom vocabulary.
         *
         * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
         */
        public var tags: List<Tag>? = null
        /**
         * The Amazon S3 location of the text file that contains your custom vocabulary. The URI must be located in the same Amazon Web Services Region as the resource you're calling.
         *
         * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt`
         *
         * Note that if you include `VocabularyFileUri` in your request, you cannot use the `Phrases` flag; you must choose one or the other.
         */
        public var vocabularyFileUri: kotlin.String? = null
        /**
         * A unique name, chosen by you, for your new custom vocabulary.
         *
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new custom vocabulary with the same name as an existing custom vocabulary, you get a `ConflictException` error.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.CreateVocabularyRequest) : this() {
            this.languageCode = x.languageCode
            this.phrases = x.phrases
            this.tags = x.tags
            this.vocabularyFileUri = x.vocabularyFileUri
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.CreateVocabularyRequest = CreateVocabularyRequest(this)
    }
}
