// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



public class CreateMedicalVocabularyRequest private constructor(builder: Builder) {
    /**
     * The language code that represents the language of the entries in your custom vocabulary. US English (`en-US`) is the only language supported with Amazon Transcribe Medical.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to a new custom medical vocabulary at the time you create this new custom vocabulary.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Amazon S3 location (URI) of the text file that contains your custom medical vocabulary. The URI must be in the same Amazon Web Services Region as the resource you're calling.
     *
     * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt`
     */
    public val vocabularyFileUri: kotlin.String? = builder.vocabularyFileUri
    /**
     * A unique name, chosen by you, for your new custom medical vocabulary.
     *
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new custom medical vocabulary with the same name as an existing custom medical vocabulary, you get a `ConflictException` error.
     */
    public val vocabularyName: kotlin.String? = requireNotNull(builder.vocabularyName) { "A non-null value must be provided for vocabularyName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.CreateMedicalVocabularyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMedicalVocabularyRequest(")
        append("languageCode=$languageCode,")
        append("tags=$tags,")
        append("vocabularyFileUri=$vocabularyFileUri,")
        append("vocabularyName=$vocabularyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageCode?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vocabularyFileUri?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMedicalVocabularyRequest

        if (languageCode != other.languageCode) return false
        if (tags != other.tags) return false
        if (vocabularyFileUri != other.vocabularyFileUri) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.CreateMedicalVocabularyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The language code that represents the language of the entries in your custom vocabulary. US English (`en-US`) is the only language supported with Amazon Transcribe Medical.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * Adds one or more custom tags, each in the form of a key:value pair, to a new custom medical vocabulary at the time you create this new custom vocabulary.
         *
         * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
         */
        public var tags: List<Tag>? = null
        /**
         * The Amazon S3 location (URI) of the text file that contains your custom medical vocabulary. The URI must be in the same Amazon Web Services Region as the resource you're calling.
         *
         * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt`
         */
        public var vocabularyFileUri: kotlin.String? = null
        /**
         * A unique name, chosen by you, for your new custom medical vocabulary.
         *
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new custom medical vocabulary with the same name as an existing custom medical vocabulary, you get a `ConflictException` error.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.CreateMedicalVocabularyRequest) : this() {
            this.languageCode = x.languageCode
            this.tags = x.tags
            this.vocabularyFileUri = x.vocabularyFileUri
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.CreateMedicalVocabularyRequest = CreateMedicalVocabularyRequest(this)
    }
}
