// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.transcribe.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.transcribe.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.transcribe.model.*
import aws.sdk.kotlin.services.transcribe.model.CreateCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.CreateLanguageModelRequest
import aws.sdk.kotlin.services.transcribe.model.CreateMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteCallAnalyticsJobRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteLanguageModelRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.DescribeLanguageModelRequest
import aws.sdk.kotlin.services.transcribe.model.GetCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.GetCallAnalyticsJobRequest
import aws.sdk.kotlin.services.transcribe.model.GetMedicalTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.GetMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.GetTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.GetVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.GetVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsCategoriesRequest
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListLanguageModelsRequest
import aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListMedicalVocabulariesRequest
import aws.sdk.kotlin.services.transcribe.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.transcribe.model.ListTranscriptionJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListVocabulariesRequest
import aws.sdk.kotlin.services.transcribe.model.ListVocabularyFiltersRequest
import aws.sdk.kotlin.services.transcribe.model.StartCallAnalyticsJobRequest
import aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.StartTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.TagResourceRequest
import aws.sdk.kotlin.services.transcribe.model.UntagResourceRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyRequest
import aws.sdk.kotlin.services.transcribe.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Transcribe"
public const val ServiceApiVersion: String = "2017-10-26"
public const val SdkVersion: String = "0.21.0-beta"

internal class DefaultTranscribeClient(override val config: TranscribeClient.Config) : TranscribeClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a new Call Analytics category.
     *
     * All categories are automatically applied to your Call Analytics transcriptions. Note that in order to apply categories to your transcriptions, you must create them before submitting your transcription request, as categories cannot be applied retroactively.
     *
     * When creating a new category, you can use the `InputType` parameter to label the category as a batch category (`POST_CALL`) or a streaming category (`REAL_TIME`). Batch categories can only be applied to batch transcriptions and streaming categories can only be applied to streaming transcriptions. If you do not include `InputType`, your category is created as a batch category by default.
     *
     * Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules can include these parameters: , , , and .
     *
     * To update an existing category, see .
     *
     * To learn more about Call Analytics categories, see [Creating categories for batch transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html) and [Creating categories for streaming transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html).
     */
    override suspend fun createCallAnalyticsCategory(input: CreateCallAnalyticsCategoryRequest): CreateCallAnalyticsCategoryResponse {
        val op = SdkHttpOperation.build<CreateCallAnalyticsCategoryRequest, CreateCallAnalyticsCategoryResponse> {
            serializer = CreateCallAnalyticsCategoryOperationSerializer()
            deserializer = CreateCallAnalyticsCategoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCallAnalyticsCategory"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateCallAnalyticsCategoryRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateCallAnalyticsCategory-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new custom language model.
     *
     * When creating a new custom language model, you must specify:
     * + If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz) base model
     * + The location of your training and tuning files (this must be an Amazon S3 URI)
     * + The language of your model
     * + A unique name for your model
     */
    override suspend fun createLanguageModel(input: CreateLanguageModelRequest): CreateLanguageModelResponse {
        val op = SdkHttpOperation.build<CreateLanguageModelRequest, CreateLanguageModelResponse> {
            serializer = CreateLanguageModelOperationSerializer()
            deserializer = CreateLanguageModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLanguageModel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateLanguageModelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateLanguageModel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new custom medical vocabulary.
     *
     * Before creating a new custom medical vocabulary, you must first upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your request using the `Phrases` flag; `CreateMedicalVocabulary` does not support the `Phrases` flag.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
     */
    override suspend fun createMedicalVocabulary(input: CreateMedicalVocabularyRequest): CreateMedicalVocabularyResponse {
        val op = SdkHttpOperation.build<CreateMedicalVocabularyRequest, CreateMedicalVocabularyResponse> {
            serializer = CreateMedicalVocabularyOperationSerializer()
            deserializer = CreateMedicalVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMedicalVocabulary"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateMedicalVocabularyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateMedicalVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new custom vocabulary.
     *
     * When creating a new custom vocabulary, you can either upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket and include the URI in your request. Or you can include a list of terms directly in your request using the `Phrases` flag.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Custom vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
     */
    override suspend fun createVocabulary(input: CreateVocabularyRequest): CreateVocabularyResponse {
        val op = SdkHttpOperation.build<CreateVocabularyRequest, CreateVocabularyResponse> {
            serializer = CreateVocabularyOperationSerializer()
            deserializer = CreateVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVocabulary"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateVocabularyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new custom vocabulary filter.
     *
     * You can use custom vocabulary filters to mask, delete, or flag specific words from your transcript. Custom vocabulary filters are commonly used to mask profanity in transcripts.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Vocabulary filtering](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
     */
    override suspend fun createVocabularyFilter(input: CreateVocabularyFilterRequest): CreateVocabularyFilterResponse {
        val op = SdkHttpOperation.build<CreateVocabularyFilterRequest, CreateVocabularyFilterResponse> {
            serializer = CreateVocabularyFilterOperationSerializer()
            deserializer = CreateVocabularyFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVocabularyFilter"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateVocabularyFilterRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateVocabularyFilter-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete using `CategoryName`. Category names are case sensitive.
     */
    override suspend fun deleteCallAnalyticsCategory(input: DeleteCallAnalyticsCategoryRequest): DeleteCallAnalyticsCategoryResponse {
        val op = SdkHttpOperation.build<DeleteCallAnalyticsCategoryRequest, DeleteCallAnalyticsCategoryResponse> {
            serializer = DeleteCallAnalyticsCategoryOperationSerializer()
            deserializer = DeleteCallAnalyticsCategoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCallAnalyticsCategory"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteCallAnalyticsCategoryRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteCallAnalyticsCategory-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using `CallAnalyticsJobName`. Job names are case sensitive.
     */
    override suspend fun deleteCallAnalyticsJob(input: DeleteCallAnalyticsJobRequest): DeleteCallAnalyticsJobResponse {
        val op = SdkHttpOperation.build<DeleteCallAnalyticsJobRequest, DeleteCallAnalyticsJobResponse> {
            serializer = DeleteCallAnalyticsJobOperationSerializer()
            deserializer = DeleteCallAnalyticsJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCallAnalyticsJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteCallAnalyticsJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteCallAnalyticsJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a custom language model. To use this operation, specify the name of the language model you want to delete using `ModelName`. custom language model names are case sensitive.
     */
    override suspend fun deleteLanguageModel(input: DeleteLanguageModelRequest): DeleteLanguageModelResponse {
        val op = SdkHttpOperation.build<DeleteLanguageModelRequest, DeleteLanguageModelResponse> {
            serializer = DeleteLanguageModelOperationSerializer()
            deserializer = DeleteLanguageModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLanguageModel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteLanguageModelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteLanguageModel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using `MedicalTranscriptionJobName`. Job names are case sensitive.
     */
    override suspend fun deleteMedicalTranscriptionJob(input: DeleteMedicalTranscriptionJobRequest): DeleteMedicalTranscriptionJobResponse {
        val op = SdkHttpOperation.build<DeleteMedicalTranscriptionJobRequest, DeleteMedicalTranscriptionJobResponse> {
            serializer = DeleteMedicalTranscriptionJobOperationSerializer()
            deserializer = DeleteMedicalTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMedicalTranscriptionJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteMedicalTranscriptionJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteMedicalTranscriptionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a custom medical vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete using `VocabularyName`. Custom vocabulary names are case sensitive.
     */
    override suspend fun deleteMedicalVocabulary(input: DeleteMedicalVocabularyRequest): DeleteMedicalVocabularyResponse {
        val op = SdkHttpOperation.build<DeleteMedicalVocabularyRequest, DeleteMedicalVocabularyResponse> {
            serializer = DeleteMedicalVocabularyOperationSerializer()
            deserializer = DeleteMedicalVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMedicalVocabulary"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteMedicalVocabularyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteMedicalVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a transcription job. To use this operation, specify the name of the job you want to delete using `TranscriptionJobName`. Job names are case sensitive.
     */
    override suspend fun deleteTranscriptionJob(input: DeleteTranscriptionJobRequest): DeleteTranscriptionJobResponse {
        val op = SdkHttpOperation.build<DeleteTranscriptionJobRequest, DeleteTranscriptionJobResponse> {
            serializer = DeleteTranscriptionJobOperationSerializer()
            deserializer = DeleteTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTranscriptionJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteTranscriptionJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteTranscriptionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a custom vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete using `VocabularyName`. Custom vocabulary names are case sensitive.
     */
    override suspend fun deleteVocabulary(input: DeleteVocabularyRequest): DeleteVocabularyResponse {
        val op = SdkHttpOperation.build<DeleteVocabularyRequest, DeleteVocabularyResponse> {
            serializer = DeleteVocabularyOperationSerializer()
            deserializer = DeleteVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVocabulary"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteVocabularyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a custom vocabulary filter. To use this operation, specify the name of the custom vocabulary filter you want to delete using `VocabularyFilterName`. Custom vocabulary filter names are case sensitive.
     */
    override suspend fun deleteVocabularyFilter(input: DeleteVocabularyFilterRequest): DeleteVocabularyFilterResponse {
        val op = SdkHttpOperation.build<DeleteVocabularyFilterRequest, DeleteVocabularyFilterResponse> {
            serializer = DeleteVocabularyFilterOperationSerializer()
            deserializer = DeleteVocabularyFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVocabularyFilter"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteVocabularyFilterRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteVocabularyFilter-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the specified custom language model.
     *
     * This operation also shows if the base language model that you used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model.
     *
     * If you tried to create a new custom language model and the request wasn't successful, you can use `DescribeLanguageModel` to help identify the reason for this failure.
     */
    override suspend fun describeLanguageModel(input: DescribeLanguageModelRequest): DescribeLanguageModelResponse {
        val op = SdkHttpOperation.build<DescribeLanguageModelRequest, DescribeLanguageModelResponse> {
            serializer = DescribeLanguageModelOperationSerializer()
            deserializer = DescribeLanguageModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLanguageModel"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeLanguageModelRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeLanguageModel-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the specified Call Analytics category.
     *
     * To get a list of your Call Analytics categories, use the operation.
     */
    override suspend fun getCallAnalyticsCategory(input: GetCallAnalyticsCategoryRequest): GetCallAnalyticsCategoryResponse {
        val op = SdkHttpOperation.build<GetCallAnalyticsCategoryRequest, GetCallAnalyticsCategoryResponse> {
            serializer = GetCallAnalyticsCategoryOperationSerializer()
            deserializer = GetCallAnalyticsCategoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCallAnalyticsCategory"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCallAnalyticsCategoryRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCallAnalyticsCategory-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the specified Call Analytics job.
     *
     * To view the job's status, refer to `CallAnalyticsJobStatus`. If the status is `COMPLETED`, the job is finished. You can find your completed transcript at the URI specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the location specified in `RedactedTranscriptFileUri`.
     *
     * If you chose to redact the audio in your media file, you can find your redacted media file at the location specified in `RedactedMediaFileUri`.
     *
     * To get a list of your Call Analytics jobs, use the operation.
     */
    override suspend fun getCallAnalyticsJob(input: GetCallAnalyticsJobRequest): GetCallAnalyticsJobResponse {
        val op = SdkHttpOperation.build<GetCallAnalyticsJobRequest, GetCallAnalyticsJobResponse> {
            serializer = GetCallAnalyticsJobOperationSerializer()
            deserializer = GetCallAnalyticsJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCallAnalyticsJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetCallAnalyticsJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetCallAnalyticsJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the specified medical transcription job.
     *
     * To view the status of the specified medical transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished. You can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * To get a list of your medical transcription jobs, use the operation.
     */
    override suspend fun getMedicalTranscriptionJob(input: GetMedicalTranscriptionJobRequest): GetMedicalTranscriptionJobResponse {
        val op = SdkHttpOperation.build<GetMedicalTranscriptionJobRequest, GetMedicalTranscriptionJobResponse> {
            serializer = GetMedicalTranscriptionJobOperationSerializer()
            deserializer = GetMedicalTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMedicalTranscriptionJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetMedicalTranscriptionJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetMedicalTranscriptionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the specified custom medical vocabulary.
     *
     * To view the status of the specified custom medical vocabulary, check the `VocabularyState` field. If the status is `READY`, your custom vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary failed.
     *
     * To get a list of your custom medical vocabularies, use the operation.
     */
    override suspend fun getMedicalVocabulary(input: GetMedicalVocabularyRequest): GetMedicalVocabularyResponse {
        val op = SdkHttpOperation.build<GetMedicalVocabularyRequest, GetMedicalVocabularyResponse> {
            serializer = GetMedicalVocabularyOperationSerializer()
            deserializer = GetMedicalVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMedicalVocabulary"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetMedicalVocabularyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetMedicalVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the specified transcription job.
     *
     * To view the status of the specified transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished. You can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * If you enabled content redaction, the redacted transcript can be found at the location specified in `RedactedTranscriptFileUri`.
     *
     * To get a list of your transcription jobs, use the operation.
     */
    override suspend fun getTranscriptionJob(input: GetTranscriptionJobRequest): GetTranscriptionJobResponse {
        val op = SdkHttpOperation.build<GetTranscriptionJobRequest, GetTranscriptionJobResponse> {
            serializer = GetTranscriptionJobOperationSerializer()
            deserializer = GetTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTranscriptionJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTranscriptionJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTranscriptionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the specified custom vocabulary.
     *
     * To view the status of the specified custom vocabulary, check the `VocabularyState` field. If the status is `READY`, your custom vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your custom vocabulary failed.
     *
     * To get a list of your custom vocabularies, use the operation.
     */
    override suspend fun getVocabulary(input: GetVocabularyRequest): GetVocabularyResponse {
        val op = SdkHttpOperation.build<GetVocabularyRequest, GetVocabularyResponse> {
            serializer = GetVocabularyOperationSerializer()
            deserializer = GetVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVocabulary"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetVocabularyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides information about the specified custom vocabulary filter.
     *
     * To get a list of your custom vocabulary filters, use the operation.
     */
    override suspend fun getVocabularyFilter(input: GetVocabularyFilterRequest): GetVocabularyFilterResponse {
        val op = SdkHttpOperation.build<GetVocabularyFilterRequest, GetVocabularyFilterResponse> {
            serializer = GetVocabularyFilterOperationSerializer()
            deserializer = GetVocabularyFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVocabularyFilter"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetVocabularyFilterRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetVocabularyFilter-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     *
     * To get detailed information about a specific Call Analytics category, use the operation.
     */
    override suspend fun listCallAnalyticsCategories(input: ListCallAnalyticsCategoriesRequest): ListCallAnalyticsCategoriesResponse {
        val op = SdkHttpOperation.build<ListCallAnalyticsCategoriesRequest, ListCallAnalyticsCategoriesResponse> {
            serializer = ListCallAnalyticsCategoriesOperationSerializer()
            deserializer = ListCallAnalyticsCategoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCallAnalyticsCategories"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListCallAnalyticsCategoriesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListCallAnalyticsCategories-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call Analytics jobs are returned.
     *
     * To get detailed information about a specific Call Analytics job, use the operation.
     */
    override suspend fun listCallAnalyticsJobs(input: ListCallAnalyticsJobsRequest): ListCallAnalyticsJobsResponse {
        val op = SdkHttpOperation.build<ListCallAnalyticsJobsRequest, ListCallAnalyticsJobsResponse> {
            serializer = ListCallAnalyticsJobsOperationSerializer()
            deserializer = ListCallAnalyticsJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCallAnalyticsJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListCallAnalyticsJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListCallAnalyticsJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all custom language models are returned.
     *
     * To get detailed information about a specific custom language model, use the operation.
     */
    override suspend fun listLanguageModels(input: ListLanguageModelsRequest): ListLanguageModelsResponse {
        val op = SdkHttpOperation.build<ListLanguageModelsRequest, ListLanguageModelsResponse> {
            serializer = ListLanguageModelsOperationSerializer()
            deserializer = ListLanguageModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLanguageModels"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListLanguageModelsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListLanguageModels-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified, all medical transcription jobs are returned.
     *
     * To get detailed information about a specific medical transcription job, use the operation.
     */
    override suspend fun listMedicalTranscriptionJobs(input: ListMedicalTranscriptionJobsRequest): ListMedicalTranscriptionJobsResponse {
        val op = SdkHttpOperation.build<ListMedicalTranscriptionJobsRequest, ListMedicalTranscriptionJobsResponse> {
            serializer = ListMedicalTranscriptionJobsOperationSerializer()
            deserializer = ListMedicalTranscriptionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMedicalTranscriptionJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListMedicalTranscriptionJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListMedicalTranscriptionJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified, all custom medical vocabularies are returned.
     *
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     */
    override suspend fun listMedicalVocabularies(input: ListMedicalVocabulariesRequest): ListMedicalVocabulariesResponse {
        val op = SdkHttpOperation.build<ListMedicalVocabulariesRequest, ListMedicalVocabulariesResponse> {
            serializer = ListMedicalVocabulariesOperationSerializer()
            deserializer = ListMedicalVocabulariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMedicalVocabularies"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListMedicalVocabulariesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListMedicalVocabularies-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsForResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all transcription jobs are returned.
     *
     * To get detailed information about a specific transcription job, use the operation.
     */
    override suspend fun listTranscriptionJobs(input: ListTranscriptionJobsRequest): ListTranscriptionJobsResponse {
        val op = SdkHttpOperation.build<ListTranscriptionJobsRequest, ListTranscriptionJobsResponse> {
            serializer = ListTranscriptionJobsOperationSerializer()
            deserializer = ListTranscriptionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTranscriptionJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTranscriptionJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTranscriptionJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
     *
     * To get detailed information about a specific custom vocabulary, use the operation.
     */
    override suspend fun listVocabularies(input: ListVocabulariesRequest): ListVocabulariesResponse {
        val op = SdkHttpOperation.build<ListVocabulariesRequest, ListVocabulariesResponse> {
            serializer = ListVocabulariesOperationSerializer()
            deserializer = ListVocabulariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVocabularies"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListVocabulariesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListVocabularies-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
     *
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     */
    override suspend fun listVocabularyFilters(input: ListVocabularyFiltersRequest): ListVocabularyFiltersResponse {
        val op = SdkHttpOperation.build<ListVocabularyFiltersRequest, ListVocabularyFiltersResponse> {
            serializer = ListVocabularyFiltersOperationSerializer()
            deserializer = ListVocabularyFiltersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVocabularyFilters"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListVocabularyFiltersRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListVocabularyFilters-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to include in your request.
     *
     * In addition to many standard transcription features, Call Analytics provides you with call characteristics, call summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can also apply custom categories to flag specified conditions. To learn more about these features and insights, refer to [Analyzing call center audio with Call Analytics](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html).
     *
     * If you want to apply categories to your Call Analytics job, you must create them before submitting your job request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To learn more about Call Analytics categories, see [Creating categories for batch transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html) and [Creating categories for streaming transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html).
     *
     * To make a `StartCallAnalyticsJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartCallAnalyticsJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `CallAnalyticsJobName`: A custom name that you create for your transcription job that's unique within your Amazon Web Services account.
     * + `DataAccessRoleArn`: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files.
     * + `Media` (`MediaFileUri` or `RedactedMediaFileUri`): The Amazon S3 location of your media file.
     *
     * With Call Analytics, you can redact the audio contained in your media file by including `RedactedMediaFileUri`, instead of `MediaFileUri`, to specify the location of your input audio. If you choose to redact your audio, you can find your redacted media at the location specified in the `RedactedMediaFileUri` field of your response.
     */
    override suspend fun startCallAnalyticsJob(input: StartCallAnalyticsJobRequest): StartCallAnalyticsJobResponse {
        val op = SdkHttpOperation.build<StartCallAnalyticsJobRequest, StartCallAnalyticsJobResponse> {
            serializer = StartCallAnalyticsJobOperationSerializer()
            deserializer = StartCallAnalyticsJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartCallAnalyticsJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartCallAnalyticsJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartCallAnalyticsJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you choose to include in your request.
     *
     * In addition to many standard transcription features, Amazon Transcribe Medical provides you with a robust medical vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To learn more about these features, refer to [How Amazon Transcribe Medical works](https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html).
     *
     * To make a `StartMedicalTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartMedicalTranscriptionJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `MedicalTranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
     * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
     * + `LanguageCode`: This must be `en-US`.
     * + `OutputBucketName`: The Amazon S3 bucket where you want your transcript stored. If you want your output stored in a sub-folder of this bucket, you must also include `OutputKey`.
     * + `Specialty`: This must be `PRIMARYCARE`.
     * + `Type`: Choose whether your audio is a conversation or a dictation.
     */
    override suspend fun startMedicalTranscriptionJob(input: StartMedicalTranscriptionJobRequest): StartMedicalTranscriptionJobResponse {
        val op = SdkHttpOperation.build<StartMedicalTranscriptionJobRequest, StartMedicalTranscriptionJobResponse> {
            serializer = StartMedicalTranscriptionJobOperationSerializer()
            deserializer = StartMedicalTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartMedicalTranscriptionJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartMedicalTranscriptionJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartMedicalTranscriptionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in your request.
     *
     * To make a `StartTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartTranscriptionJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `TranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
     * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
     * + One of `LanguageCode`, `IdentifyLanguage`, or `IdentifyMultipleLanguages`: If you know the language of your media file, specify it using the `LanguageCode` parameter; you can find all valid language codes in the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table. If you don't know the languages spoken in your media, use either `IdentifyLanguage` or `IdentifyMultipleLanguages` and let Amazon Transcribe identify the languages for you.
     */
    override suspend fun startTranscriptionJob(input: StartTranscriptionJobRequest): StartTranscriptionJobResponse {
        val op = SdkHttpOperation.build<StartTranscriptionJobRequest, StartTranscriptionJobResponse> {
            serializer = StartTranscriptionJobOperationSerializer()
            deserializer = StartTranscriptionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartTranscriptionJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartTranscriptionJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartTranscriptionJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the specified tags from the specified Amazon Transcribe resource.
     *
     * If you include `UntagResource` in your request, you must also include `ResourceArn` and `TagKeys`.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the specified Call Analytics category with new rules. Note that the `UpdateCallAnalyticsCategory` operation overwrites all existing rules contained in the specified category. You cannot append additional rules onto an existing category.
     *
     * To create a new category, see .
     */
    override suspend fun updateCallAnalyticsCategory(input: UpdateCallAnalyticsCategoryRequest): UpdateCallAnalyticsCategoryResponse {
        val op = SdkHttpOperation.build<UpdateCallAnalyticsCategoryRequest, UpdateCallAnalyticsCategoryResponse> {
            serializer = UpdateCallAnalyticsCategoryOperationSerializer()
            deserializer = UpdateCallAnalyticsCategoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCallAnalyticsCategory"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateCallAnalyticsCategoryRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateCallAnalyticsCategory-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing custom vocabulary.
     */
    override suspend fun updateMedicalVocabulary(input: UpdateMedicalVocabularyRequest): UpdateMedicalVocabularyResponse {
        val op = SdkHttpOperation.build<UpdateMedicalVocabularyRequest, UpdateMedicalVocabularyResponse> {
            serializer = UpdateMedicalVocabularyOperationSerializer()
            deserializer = UpdateMedicalVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMedicalVocabulary"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateMedicalVocabularyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateMedicalVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing custom vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing custom vocabulary.
     */
    override suspend fun updateVocabulary(input: UpdateVocabularyRequest): UpdateVocabularyResponse {
        val op = SdkHttpOperation.build<UpdateVocabularyRequest, UpdateVocabularyResponse> {
            serializer = UpdateVocabularyOperationSerializer()
            deserializer = UpdateVocabularyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVocabulary"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateVocabularyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateVocabulary-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all previous entries; you cannot append new terms onto an existing custom vocabulary filter.
     */
    override suspend fun updateVocabularyFilter(input: UpdateVocabularyFilterRequest): UpdateVocabularyFilterResponse {
        val op = SdkHttpOperation.build<UpdateVocabularyFilterRequest, UpdateVocabularyFilterResponse> {
            serializer = UpdateVocabularyFilterOperationSerializer()
            deserializer = UpdateVocabularyFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVocabularyFilter"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateVocabularyFilterRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("Transcribe", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "transcribe"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateVocabularyFilter-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "transcribe")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
