// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



public class UpdateVocabularyFilterRequest private constructor(builder: Builder) {
    /**
     * The Amazon S3 location of the text file that contains your custom vocabulary filter terms. The URI must be located in the same Amazon Web Services Region as the resource you're calling.
     *
     * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt`
     *
     * Note that if you include `VocabularyFilterFileUri` in your request, you cannot use `Words`; you must choose one or the other.
     */
    public val vocabularyFilterFileUri: kotlin.String? = builder.vocabularyFilterFileUri
    /**
     * The name of the custom vocabulary filter you want to update. Vocabulary filter names are case sensitive.
     */
    public val vocabularyFilterName: kotlin.String? = requireNotNull(builder.vocabularyFilterName) { "A non-null value must be provided for vocabularyFilterName" }
    /**
     * Use this parameter if you want to update your vocabulary filter by including all desired terms, as comma-separated values, within your request. The other option for updating your vocabulary filter is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the `VocabularyFilterFileUri` parameter.
     *
     * Note that if you include `Words` in your request, you cannot use `VocabularyFilterFileUri`; you must choose one or the other.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     */
    public val words: List<String>? = builder.words

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyFilterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateVocabularyFilterRequest(")
        append("vocabularyFilterFileUri=$vocabularyFilterFileUri,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("words=$words)")
    }

    override fun hashCode(): kotlin.Int {
        var result = vocabularyFilterFileUri?.hashCode() ?: 0
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (words?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateVocabularyFilterRequest

        if (vocabularyFilterFileUri != other.vocabularyFilterFileUri) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (words != other.words) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyFilterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon S3 location of the text file that contains your custom vocabulary filter terms. The URI must be located in the same Amazon Web Services Region as the resource you're calling.
         *
         * Here's an example URI path: `s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt`
         *
         * Note that if you include `VocabularyFilterFileUri` in your request, you cannot use `Words`; you must choose one or the other.
         */
        public var vocabularyFilterFileUri: kotlin.String? = null
        /**
         * The name of the custom vocabulary filter you want to update. Vocabulary filter names are case sensitive.
         */
        public var vocabularyFilterName: kotlin.String? = null
        /**
         * Use this parameter if you want to update your vocabulary filter by including all desired terms, as comma-separated values, within your request. The other option for updating your vocabulary filter is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the `VocabularyFilterFileUri` parameter.
         *
         * Note that if you include `Words` in your request, you cannot use `VocabularyFilterFileUri`; you must choose one or the other.
         *
         * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
         */
        public var words: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyFilterRequest) : this() {
            this.vocabularyFilterFileUri = x.vocabularyFilterFileUri
            this.vocabularyFilterName = x.vocabularyFilterName
            this.words = x.words
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyFilterRequest = UpdateVocabularyFilterRequest(this)
    }
}
