// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Flag the presence or absence of specific words or phrases detected in your Call Analytics transcription output.
 *
 * Rules using `TranscriptFilter` are designed to match:
 * + Custom words or phrases spoken by the agent, the customer, or both
 * + Custom words or phrases **not** spoken by the agent, the customer, or either
 * + Custom words or phrases that occur at a specific time frame
 *
 * See [Rule criteria](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html#call-analytics-create-categories-rules) for examples.
 */
public class TranscriptFilter private constructor(builder: Builder) {
    /**
     * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for the specified key words or phrases. See for more detail.
     */
    public val absoluteTimeRange: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange? = builder.absoluteTimeRange
    /**
     * Set to `TRUE` to flag the absence of the phrase you specified in your request. Set to `FALSE` to flag the presence of the phrase you specified in your request.
     */
    public val negate: kotlin.Boolean? = builder.negate
    /**
     * Specify the participant you want to flag. Omitting this parameter is equivalent to specifying both participants.
     */
    public val participantRole: aws.sdk.kotlin.services.transcribe.model.ParticipantRole? = builder.participantRole
    /**
     * Allows you to specify a time range (in percentage) in your media file, during which you want to search for the specified key words or phrases. See for more detail.
     */
    public val relativeTimeRange: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange? = builder.relativeTimeRange
    /**
     * Specify the phrases you want to flag.
     */
    public val targets: List<String>? = builder.targets
    /**
     * Flag the presence or absence of an exact match to the phrases you specify. For example, if you specify the phrase "speak to a manager" as your `Targets` value, only that exact phrase is flagged.
     *
     * Note that semantic matching is not supported. For example, if your customer says "speak to *the* manager", instead of "speak to *a* manager", your content is not flagged.
     */
    public val transcriptFilterType: aws.sdk.kotlin.services.transcribe.model.TranscriptFilterType? = builder.transcriptFilterType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.TranscriptFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TranscriptFilter(")
        append("absoluteTimeRange=$absoluteTimeRange,")
        append("negate=$negate,")
        append("participantRole=$participantRole,")
        append("relativeTimeRange=$relativeTimeRange,")
        append("targets=$targets,")
        append("transcriptFilterType=$transcriptFilterType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = absoluteTimeRange?.hashCode() ?: 0
        result = 31 * result + (negate?.hashCode() ?: 0)
        result = 31 * result + (participantRole?.hashCode() ?: 0)
        result = 31 * result + (relativeTimeRange?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (transcriptFilterType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TranscriptFilter

        if (absoluteTimeRange != other.absoluteTimeRange) return false
        if (negate != other.negate) return false
        if (participantRole != other.participantRole) return false
        if (relativeTimeRange != other.relativeTimeRange) return false
        if (targets != other.targets) return false
        if (transcriptFilterType != other.transcriptFilterType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.TranscriptFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for the specified key words or phrases. See for more detail.
         */
        public var absoluteTimeRange: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange? = null
        /**
         * Set to `TRUE` to flag the absence of the phrase you specified in your request. Set to `FALSE` to flag the presence of the phrase you specified in your request.
         */
        public var negate: kotlin.Boolean? = null
        /**
         * Specify the participant you want to flag. Omitting this parameter is equivalent to specifying both participants.
         */
        public var participantRole: aws.sdk.kotlin.services.transcribe.model.ParticipantRole? = null
        /**
         * Allows you to specify a time range (in percentage) in your media file, during which you want to search for the specified key words or phrases. See for more detail.
         */
        public var relativeTimeRange: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange? = null
        /**
         * Specify the phrases you want to flag.
         */
        public var targets: List<String>? = null
        /**
         * Flag the presence or absence of an exact match to the phrases you specify. For example, if you specify the phrase "speak to a manager" as your `Targets` value, only that exact phrase is flagged.
         *
         * Note that semantic matching is not supported. For example, if your customer says "speak to *the* manager", instead of "speak to *a* manager", your content is not flagged.
         */
        public var transcriptFilterType: aws.sdk.kotlin.services.transcribe.model.TranscriptFilterType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.TranscriptFilter) : this() {
            this.absoluteTimeRange = x.absoluteTimeRange
            this.negate = x.negate
            this.participantRole = x.participantRole
            this.relativeTimeRange = x.relativeTimeRange
            this.targets = x.targets
            this.transcriptFilterType = x.transcriptFilterType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.TranscriptFilter = TranscriptFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange] inside the given [block]
         */
        public fun absoluteTimeRange(block: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange.Builder.() -> kotlin.Unit) {
            this.absoluteTimeRange = aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange] inside the given [block]
         */
        public fun relativeTimeRange(block: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange.Builder.() -> kotlin.Unit) {
            this.relativeTimeRange = aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange.invoke(block)
        }
    }
}
