// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



public class TagResourceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource you want to tag. ARNs have the format `arn:partition:service:region:account-id:resource-type/resource-id`.
     *
     * For example, `arn:aws:transcribe:us-west-2:account-id:transcription-job/transcription-job-name`.
     *
     * Valid values for `resource-type` are: `transcription-job`, `medical-transcription-job`, `vocabulary`, `medical-vocabulary`, `vocabulary-filter`, and `language-model`.
     */
    public val resourceArn: kotlin.String? = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.TagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.TagResourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource you want to tag. ARNs have the format `arn:partition:service:region:account-id:resource-type/resource-id`.
         *
         * For example, `arn:aws:transcribe:us-west-2:account-id:transcription-job/transcription-job-name`.
         *
         * Valid values for `resource-type` are: `transcription-job`, `medical-transcription-job`, `vocabulary`, `medical-vocabulary`, `vocabulary-filter`, and `language-model`.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
         *
         * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.TagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.TagResourceRequest = TagResourceRequest(this)
    }
}
