// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Flag the presence or absence of specific sentiments detected in your Call Analytics transcription output.
 *
 * Rules using `SentimentFilter` are designed to match:
 * + The presence or absence of a positive sentiment felt by the customer, agent, or both at specified points in the call
 * + The presence or absence of a negative sentiment felt by the customer, agent, or both at specified points in the call
 * + The presence or absence of a neutral sentiment felt by the customer, agent, or both at specified points in the call
 * + The presence or absence of a mixed sentiment felt by the customer, the agent, or both at specified points in the call
 *
 * See [Rule criteria](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html#call-analytics-create-categories-rules) for examples.
 */
public class SentimentFilter private constructor(builder: Builder) {
    /**
     * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for the specified sentiments. See for more detail.
     */
    public val absoluteTimeRange: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange? = builder.absoluteTimeRange
    /**
     * Set to `TRUE` to flag the sentiments you didn't include in your request. Set to `FALSE` to flag the sentiments you specified in your request.
     */
    public val negate: kotlin.Boolean? = builder.negate
    /**
     * Specify the participant you want to flag. Omitting this parameter is equivalent to specifying both participants.
     */
    public val participantRole: aws.sdk.kotlin.services.transcribe.model.ParticipantRole? = builder.participantRole
    /**
     * Allows you to specify a time range (in percentage) in your media file, during which you want to search for the specified sentiments. See for more detail.
     */
    public val relativeTimeRange: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange? = builder.relativeTimeRange
    /**
     * Specify the sentiments you want to flag.
     */
    public val sentiments: List<SentimentValue>? = builder.sentiments

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.SentimentFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SentimentFilter(")
        append("absoluteTimeRange=$absoluteTimeRange,")
        append("negate=$negate,")
        append("participantRole=$participantRole,")
        append("relativeTimeRange=$relativeTimeRange,")
        append("sentiments=$sentiments)")
    }

    override fun hashCode(): kotlin.Int {
        var result = absoluteTimeRange?.hashCode() ?: 0
        result = 31 * result + (negate?.hashCode() ?: 0)
        result = 31 * result + (participantRole?.hashCode() ?: 0)
        result = 31 * result + (relativeTimeRange?.hashCode() ?: 0)
        result = 31 * result + (sentiments?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SentimentFilter

        if (absoluteTimeRange != other.absoluteTimeRange) return false
        if (negate != other.negate) return false
        if (participantRole != other.participantRole) return false
        if (relativeTimeRange != other.relativeTimeRange) return false
        if (sentiments != other.sentiments) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.SentimentFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for the specified sentiments. See for more detail.
         */
        public var absoluteTimeRange: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange? = null
        /**
         * Set to `TRUE` to flag the sentiments you didn't include in your request. Set to `FALSE` to flag the sentiments you specified in your request.
         */
        public var negate: kotlin.Boolean? = null
        /**
         * Specify the participant you want to flag. Omitting this parameter is equivalent to specifying both participants.
         */
        public var participantRole: aws.sdk.kotlin.services.transcribe.model.ParticipantRole? = null
        /**
         * Allows you to specify a time range (in percentage) in your media file, during which you want to search for the specified sentiments. See for more detail.
         */
        public var relativeTimeRange: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange? = null
        /**
         * Specify the sentiments you want to flag.
         */
        public var sentiments: List<SentimentValue>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.SentimentFilter) : this() {
            this.absoluteTimeRange = x.absoluteTimeRange
            this.negate = x.negate
            this.participantRole = x.participantRole
            this.relativeTimeRange = x.relativeTimeRange
            this.sentiments = x.sentiments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.SentimentFilter = SentimentFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange] inside the given [block]
         */
        public fun absoluteTimeRange(block: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange.Builder.() -> kotlin.Unit) {
            this.absoluteTimeRange = aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange] inside the given [block]
         */
        public fun relativeTimeRange(block: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange.Builder.() -> kotlin.Unit) {
            this.relativeTimeRange = aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange.invoke(block)
        }
    }
}
